package jp.sourceforge.talisman.xmlcli;

import java.io.FileInputStream;
import java.io.IOException;

import jp.sourceforge.talisman.xmlcli.builder.OptionsBuilderFactory;

import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 28 $ $Date: 2007-08-21 10:27:00 +0900 (Tue, 21 Aug 2007) $
 */
public class XmlCli {
	private Options options;

	public XmlCli(String xmlfile){
		parseOptions(xmlfile);
	}

	public Options getOptions()	{
		return options;
	}

	public void printHelp(){
		printHelp("syntax");
	}

	public void printHelp(String syntax){
		HelpFormatter formatter = new HelpFormatter();
		formatter.printHelp(syntax, options);
	}

	private void parseOptions(String file){
		try{
		    OptionsBuilderFactory factory = OptionsBuilderFactory.getInstance();
		    OptionsBuilder builder = factory.createBuilder(new FileInputStream(file));
		    options = builder.buildOptions();

		} catch(DOMException e){
		    // some exception handle process...
		} catch(SAXException e){
		    // some exception handle process...
		} catch(IOException e){
		    // some exception handle process...
		}
	}

	public static void main(String[] args){
		for(String arg: args){
			new XmlCli(arg).printHelp();
		}
	}
}
