package jp.sourceforge.talisman.xmlcli;

/*
 * $Id: ResourceHelpFormatter.java 28 2007-08-21 01:27:00Z tama3 $
 */

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;

import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

/**
 * This class is a instance of {@link HelpFormatter
 * <code>HelpFormatter</code>}, which prints the message obtained from
 * ResourceBundle.
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 28 $ $Date: 2007-08-21 10:27:00 +0900 (Tue, 21 Aug 2007) $
 */
public class ResourceHelpFormatter extends HelpFormatter {
    private ResourceBundle bundle;

    /**
     * @param bundle stored message
     */
    public ResourceHelpFormatter(ResourceBundle bundle){
        this.bundle = bundle;
    }

    @SuppressWarnings("unchecked")
	protected StringBuffer renderOptions(StringBuffer sb, int width, Options options,
                                         int leftPad, int descPad) {
        Options newOptions = new Options();
        Map<String, OptionGroup> groups = new HashMap<String, OptionGroup>();

        for(Iterator i = options.getOptions().iterator(); i.hasNext(); ){
            Option o = new ResourceOption(bundle, (Option)i.next());
            newOptions.addOption(o);

            if(options.getOptionGroup(o) != null && groups.get(o.getOpt()) == null){
                OptionGroup og = options.getOptionGroup(o);
                for(Iterator ii = og.getOptions().iterator(); i.hasNext(); ){
                    Option oo = (Option)ii.next();
                    groups.put(oo.getOpt(), og);
                }
                newOptions.addOptionGroup(og);
            }
        }

        return super.renderOptions(sb, width, newOptions, leftPad, descPad);
    }
}
