package jp.sourceforge.talisman.xmlcli;

/*
 * $Id: OptionsBuilder.java 28 2007-08-21 01:27:00Z tama3 $
 */

import java.io.IOException;

import org.apache.commons.cli.Options;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/**
 * <a href="http://jakarta.apache.org/commons/cli/">Jakarta Commons
 * CLI</a> is very useful.  However, if the structur of options is
 * complexed, to build a instance of Options are tired and uncool.
 * The best solution I think, the structur of options is described in
 * some configuration file, and build the instance of Options at
 * runtime by {@link OptionsBuilder <code>OptionsBuilder</code>}.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 28 $ $Date: 2007-08-21 10:27:00 +0900 (Tue, 21 Aug 2007) $
 */
public interface OptionsBuilder{
    public String getDefinitionName();

    public Options buildOptions() throws IOException, SAXException, DOMException;
}
