/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.csvio;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import jp.sourceforge.talisman.csvio.CsvIOSetting;
import jp.sourceforge.talisman.csvio.CsvLine;
import jp.sourceforge.talisman.csvio.EscapeMode;
import jp.sourceforge.talisman.csvio.QuotationMode;

public class CsvLineWriter
extends FilterWriter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private CsvIOSetting setting;

    public CsvLineWriter(Writer out) {
        super(out);
        this.setting = new CsvIOSetting();
    }

    public CsvLineWriter(Writer out, CsvIOSetting setting) {
        super(out);
        this.setting = setting;
    }

    public CsvIOSetting getSetting() {
        return this.setting;
    }

    public void setSetting(CsvIOSetting setting) {
        this.setting = setting;
    }

    public void write(CsvLine line) throws IOException {
        boolean first = true;
        for (String string : line) {
            if (!first) {
                super.write(this.getSetting().getSeparator());
            }
            this.writeElement(string);
            first = false;
        }
        this.writeString(LINE_SEPARATOR);
    }

    private void writeElement(String element) throws IOException {
        CsvIOSetting setting = this.getSetting();
        QuotationMode mode = setting.getQuotationMode();
        EscapeMode escape = setting.getEscapeMode();
        boolean quote = mode == QuotationMode.ALWAYS;
        char qb = setting.getQuoteBegin();
        char qe = setting.getQuoteBegin();
        String ec = String.valueOf(setting.getEscapeCharacter());
        if (mode == QuotationMode.AS_NEEDED) {
            boolean bl = quote = element.indexOf(setting.getSeparator()) >= 0;
        }
        if (escape == EscapeMode.ESCAPE_CHARACTER) {
            if (ec.equals("\\")) {
                ec = "\\\\";
            }
            element = element.replaceAll(String.valueOf(ec), String.valueOf(ec) + ec);
            element = element.replaceAll(String.valueOf(qb), String.valueOf(ec) + qb);
            if (qb != qe) {
                element = element.replaceAll(String.valueOf(qe), String.valueOf(ec) + qe);
            }
        } else if (escape == EscapeMode.DOUBLE_CHARACTER) {
            element = element.replaceAll(String.valueOf(qb), new String(new StringBuilder().append(qb).append(qb)));
            if (qb != qe) {
                element = element.replaceAll(String.valueOf(qe), new String(new StringBuilder().append(qe).append(qe)));
            }
        }
        if (quote) {
            element = String.valueOf(setting.getQuoteBegin()) + element + setting.getQuoteEnd();
        }
        this.writeString(element);
    }

    private void writeString(String string) throws IOException {
        char[] c = string.toCharArray();
        int i = 0;
        while (i < c.length) {
            super.write(c[i]);
            ++i;
        }
    }
}

