<?php
// $Id$
// Hyp_KAKASI Class by nao-pon http://hypweb.net
////////////////////////////////////////////////

if( ! class_exists( 'Hyp_KAKASHI' ) )
{
class Hyp_KAKASHI
{
	var $kakasi_path = "/usr/bin/kakasi";    // KAKASI Υѥ
	
	var $encoding = "";      // ʸ(EUC-JPѤΤѤ)
	var $tmp_dir ="";        // ʬѥå¸ѥǥ쥯ȥ
	
	var $gc_probability = 1; // gcΨ x  x/1000γΨǽ
	var $cache_expire = 24;  // åͭ(h)
	
	var $dicts = array();
	var $cmd = "";
	
	function Hyp_KAKASHI()
	{
		//$this->encoding = _CHARSET ;
		//$this->tmp_dir = XOOPS_ROOT_PATH . "/cache2/kakasi/";
	}
	
	function add_dict($dict)
	{
		if (is_file($dict))
		{
			array_push($this->dicts,$dict);
		}
	}
	
	function get_wakatigaki(&$str)
	{
		if (!$this->kakasi_path) return false;
		
		if ($this->tmp_dir)
		{
			// gc(١쥯)
			if (mt_rand(1,100000) <= $this->gc_probability * 100)
			{
				if ($handle = opendir($this->tmp_dir))
				{
					while (false !== ($file = readdir($handle)))
					{
						if (strpos($file,".") === 0) continue;
						if (filemtime($this->tmp_dir.$file) < time() - $this->cache_expire * 3600)
						{
							unlink($this->tmp_dir.$file);
						}
					}
					closedir($handle); 
				}
			}
			
			$tmpfile = $this->tmp_dir.md5($str).".tmp";
			
			// å
			if (file_exists($tmpfile))
			{
				touch($tmpfile);
				$str = join("",file($tmpfile));
				return true;
			}
		}
		
		$put = $str;
		$nwa = "";
		$match = array();
		if (preg_match_all("/((\"|'||).+?(?:\\2))/",$put,$match,PREG_PATTERN_ORDER))
		{
			$match[1] = array_unique($match[1]);
			foreach($match[1] as $rep)
			{
				$put = str_replace($rep," ",$put);
			}
			
			$put = preg_replace("/ +/"," ",$put);
			$nwa = join(" ",$match[1])." ";
		}
		
		if (!$this->execute($put, "-w -c")) return false;
		
		$str = $nwa.$put;
		
		if ($this->tmp_dir)
		{
			if ($fp = fopen($tmpfile, "wb"))
			{
				fputs($fp, $str);
				fclose($fp);
			}
		}
		
		return true;
	}
	
	function get_katakana(&$str)
	{
		return $this->execute($str, "-kK -HK -JK");
	}

	function get_hiragana(&$str)
	{
		return $this->execute($str, "-kH -KH -JH");
	}
	
	function get_roma(&$str)
	{
		return $this->execute($str, "-Ha -Ka -Ja -Ea -ka");
	}
	
	function get_expert(&$str,&$cmd)
	{
		$cmd = trim($cmd);
		$reg = "/^\-(a[jE]|j[aE]|g[ajE]|k[ajKH]|E[aj]|H[ajkK]|K[ajkH]|J[ajkHK]|[pfscCUw]|r[hk]?)$/";
		$_tmp = array();
		foreach(explode(" ",$cmd) as $_cmd)
		{
			if (preg_match($reg, $_cmd))
			{
				$_tmp[] = $_cmd;
			}
		}
		$cmd = join(" ",$_tmp);
		if (!$cmd) return false;
		return $this->execute($str, $cmd);
	}

	function execute(&$str,$cmd)
	{
		$ret = false;
		$dic = "";
		$cmd = " -ieuc ".$cmd;
		if (is_file($this->kakasi_path) && (function_exists('is_executable'))? is_executable($this->kakasi_path) : 1)
		{
			if ($this->dicts)
			{
				$dic = " ".join(", ",$this->dicts);
			}
			$pipes = array();
			$descriptorspec = array(
				0 => array("pipe", "r"),  // stdin is a pipe that the child will read from
				1 => array("pipe", "w"),  // stdout is a pipe that the child will write to
			);
			$this->cmd = $cmd.$dic;
			$process = proc_open($this->kakasi_path.$this->cmd, $descriptorspec, $pipes);
			if (is_resource($process))
			{
				fputs($pipes[0], $str);
				fclose($pipes[0]);
				$rstr = $_str = "";
				while($_str = fgets ($pipes[1]))
				{
					$rstr .= $_str;
				}
				if ($rstr)
				{
					$str = $rstr;
					$ret = true;
				}
				fclose($pipes[1]);
				proc_close($process);
			}
		}
		return $ret;
	}
}
}
?>