/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.common.actions;

import com.hisagisoft.common.History;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Shell;

public class HistoryAction<E>
extends Action {
    private static Logger logger = Logger.getLogger(HistoryAction.class.getName());
    private History<E> history;
    private Viewer viewer;
    private Type type;

    public HistoryAction(Type type) {
        this.type = type;
        this.setEnabled(false);
    }

    public void setHistory(History<E> history) {
        this.history = history;
    }

    public void setViewer(Viewer viewer) {
        this.viewer = viewer;
    }

    public void run() {
        logger.fine((Object)((Object)this.type) + " ACTION - start");
        try {
            Cursor cursor = new Cursor(null, 1);
            Shell shell = this.viewer.getControl().getShell();
            shell.setCursor(cursor);
            Object input = this.viewer.getInput();
            if (this.type == Type.PREV && this.history.hasPrev(input)) {
                Object prev = this.history.prev(input);
                this.viewer.setInput(prev);
            } else if (this.type == Type.NEXT && this.history.hasNext(input)) {
                Object next = this.history.next(input);
                this.viewer.setInput(next);
            }
            cursor.dispose();
            shell.setCursor(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        logger.fine((Object)((Object)this.type) + " ACTION - end");
    }

    public static enum Type {
        PREV,
        NEXT;

    }
}

