/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemePopupArrowDrawInfo;
import org.eclipse.swt.internal.carbon.HIThemeSeparatorDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.theme.ToolBarDrawData;

public class ToolItemDrawData
extends DrawData {
    public ToolBarDrawData parent;
    static final int ARROW_WIDTH = 9;
    static final int INSET = 3;

    public ToolItemDrawData() {
        this.state = new int[2];
    }

    Rectangle computeTrim(Theme theme, GC gc) {
        int x = this.clientArea.x - 3;
        int y = this.clientArea.y - 3;
        int width = this.clientArea.width + 6;
        int height = this.clientArea.height + 6;
        if ((this.style & 4) != 0) {
            width += 9;
        }
        return new Rectangle(x, y, width, height);
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        Object info;
        CGRect rect = new CGRect();
        rect.x = bounds.x;
        rect.y = bounds.y;
        rect.width = bounds.width;
        rect.height = bounds.height;
        if ((this.style & 2) != 0) {
            info = this.getSeparatorInfo();
            OS.HIThemeDrawSeparator(rect, (HIThemeSeparatorDrawInfo)info, gc.handle, 0);
        } else if ((this.state[0] & 2) != 0) {
            OS.CGContextSaveGState(gc.handle);
            OS.CGContextSetFillColor(gc.handle, new float[]{0.025f, 0.025f, 0.025f, 0.025f});
            OS.CGContextFillRect(gc.handle, rect);
            OS.CGContextSetStrokeColor(gc.handle, new float[]{0.2f, 0.2f, 0.2f, 0.2f});
            rect.x += 0.5f;
            rect.y += 0.5f;
            rect.width -= 1.0f;
            rect.height -= 1.0f;
            OS.CGContextStrokeRect(gc.handle, rect);
            OS.CGContextRestoreGState(gc.handle);
        }
        if (this.clientArea != null) {
            this.clientArea.x = bounds.x;
            this.clientArea.y = bounds.y;
            this.clientArea.width = bounds.width;
            this.clientArea.height = bounds.height;
        }
        if ((this.style & 4) != 0) {
            rect.y = (float)bounds.y + rect.height / 2.0f - 1.0f;
            rect.x = (float)bounds.x + rect.width - 9.0f;
            info = this.getArrowInfo();
            OS.HIThemeDrawPopupArrow(rect, (HIThemePopupArrowDrawInfo)info, gc.handle, 0);
            if (this.clientArea != null) {
                this.clientArea.width -= 9;
            }
        }
    }

    HIThemePopupArrowDrawInfo getArrowInfo() {
        HIThemePopupArrowDrawInfo info = new HIThemePopupArrowDrawInfo();
        int state = this.state[1];
        info.state = (state & 8) != 0 ? 2 : ((state & 0x10) != 0 ? ((state & 0x20) == 0 ? 1 : 7) : ((state & 0x20) == 0 ? 0 : 8));
        info.orientation = 1;
        info.size = 1;
        return info;
    }

    HIThemeSeparatorDrawInfo getSeparatorInfo() {
        HIThemeSeparatorDrawInfo info = new HIThemeSeparatorDrawInfo();
        int state = this.state[0];
        info.state = (state & 0x10) != 0 ? ((state & 0x20) == 0 ? 1 : 7) : ((state & 0x20) == 0 ? 0 : 8);
        return info;
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        if (!bounds.contains(position)) {
            return -1;
        }
        if ((this.style & 4) != 0 && bounds.x + bounds.width - 9 <= position.x) {
            return 1;
        }
        return 0;
    }
}

