/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell parent) {
        this(parent, 32768);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        this.fullPath = null;
        if ((this.style & 0x2002) == 2) {
            int list = OS.gtk_file_chooser_get_filenames(this.handle);
            int listLength = OS.g_slist_length(list);
            this.fileNames = new String[listLength];
            int current = list;
            int writePos = 0;
            int i = 0;
            while (i < listLength) {
                int name = OS.g_slist_data(current);
                int utf8Ptr = OS.g_filename_to_utf8(name, -1, null, null, null);
                OS.g_free(name);
                if (utf8Ptr != 0) {
                    int[] items_written = new int[1];
                    int utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1, null, items_written, null);
                    OS.g_free(utf8Ptr);
                    if (utf16Ptr != 0) {
                        int clength = items_written[0];
                        char[] chars = new char[clength];
                        OS.memmove(chars, utf16Ptr, clength * 2);
                        OS.g_free(utf16Ptr);
                        this.fullPath = new String(chars);
                        this.fileNames[writePos++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                current = OS.g_slist_next(current);
                ++i;
            }
            if (writePos != 0 && writePos != listLength) {
                String[] validFileNames = new String[writePos];
                System.arraycopy(this.fileNames, 0, validFileNames, 0, writePos);
                this.fileNames = validFileNames;
            }
            OS.g_slist_free(list);
        } else {
            int path = OS.gtk_file_chooser_get_filename(this.handle);
            if (path != 0) {
                int utf8Ptr = OS.g_filename_to_utf8(path, -1, null, null, null);
                OS.g_free(path);
                if (utf8Ptr != 0) {
                    int[] items_written = new int[1];
                    int utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1, null, items_written, null);
                    OS.g_free(utf8Ptr);
                    if (utf16Ptr != 0) {
                        int clength = items_written[0];
                        char[] chars = new char[clength];
                        OS.memmove(chars, utf16Ptr, clength * 2);
                        OS.g_free(utf16Ptr);
                        this.fullPath = new String(chars);
                        this.fileNames = new String[1];
                        this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
            }
        }
        if (this.fullPath != null) {
            int separatorIndex = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(separatorIndex + 1);
            this.filterPath = this.fullPath.substring(0, separatorIndex);
        }
        return this.fullPath;
    }

    String computeResultClassicDialog() {
        GtkFileSelection selection = new GtkFileSelection();
        OS.memmove(selection, this.handle);
        int entry = selection.selection_entry;
        int entryText = OS.gtk_entry_get_text(entry);
        int entryLength = OS.strlen(entryText);
        if (entryLength == 0) {
            int[] model;
            int fileList = selection.file_list;
            int listSelection = OS.gtk_tree_view_get_selection(fileList);
            int selectedList = OS.gtk_tree_selection_get_selected_rows(listSelection, model = new int[1]);
            if (selectedList == 0) {
                return null;
            }
            int listLength = OS.g_list_length(selectedList);
            if (listLength == 0) {
                OS.g_list_free(selectedList);
                return null;
            }
            int path = OS.g_list_nth_data(selectedList, 0);
            int[] ptr = new int[1];
            int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter(model[0], iter, path)) {
                OS.gtk_tree_model_get(model[0], iter, 0, ptr, -1);
            }
            OS.g_free(iter);
            int i = 0;
            while (i < listLength) {
                OS.gtk_tree_path_free(OS.g_list_nth_data(selectedList, i));
                ++i;
            }
            OS.g_list_free(selectedList);
            if (ptr[0] == 0) {
                return null;
            }
            int length = OS.strlen(ptr[0]);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, ptr[0], length);
            OS.g_free(ptr[0]);
            OS.gtk_entry_set_text(entry, buffer);
        }
        int fileNamePtr = OS.gtk_file_selection_get_filename(this.handle);
        int utf8Ptr = OS.g_filename_to_utf8(fileNamePtr, -1, null, null, null);
        int[] items_written = new int[1];
        int utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1, null, items_written, null);
        entryLength = items_written[0];
        char[] buffer = new char[entryLength];
        OS.memmove(buffer, utf16Ptr, entryLength * 2);
        String osAnswer = new String(buffer);
        OS.g_free(utf16Ptr);
        OS.g_free(utf8Ptr);
        if (osAnswer == null) {
            return null;
        }
        int separatorIndex = osAnswer.lastIndexOf(SEPARATOR);
        if (separatorIndex + 1 == osAnswer.length()) {
            return null;
        }
        String answer = this.fullPath = osAnswer;
        this.fileName = this.fullPath.substring(separatorIndex + 1);
        this.filterPath = this.fullPath.substring(0, separatorIndex);
        if ((this.style & 2) == 0) {
            this.fileNames = new String[]{this.fileName};
        } else {
            int namesPtr;
            int namesPtr1 = namesPtr = OS.gtk_file_selection_get_selections(this.handle);
            int[] namePtr = new int[1];
            OS.memmove(namePtr, namesPtr1, OS.PTR_SIZEOF);
            int length = 0;
            while (namePtr[0] != 0) {
                ++length;
                OS.memmove(namePtr, namesPtr1 += OS.PTR_SIZEOF, OS.PTR_SIZEOF);
            }
            this.fileNames = new String[length];
            namePtr = new int[length];
            OS.memmove(namePtr, namesPtr, length * OS.PTR_SIZEOF);
            int i = 0;
            while (i < length) {
                utf8Ptr = OS.g_filename_to_utf8(namePtr[i], -1, null, null, null);
                items_written = new int[1];
                utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1, null, items_written, null);
                buffer = new char[items_written[0]];
                OS.memmove(buffer, utf16Ptr, items_written[0] * 2);
                String name = new String(buffer);
                this.fileNames[i] = name.substring(name.lastIndexOf(SEPARATOR) + 1);
                OS.g_free(utf16Ptr);
                OS.g_free(utf8Ptr);
                ++i;
            }
            OS.g_strfreev(namesPtr);
        }
        return answer;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        boolean useChooserDialog;
        boolean bl = useChooserDialog = OS.GTK_VERSION >= OS.VERSION(2, 4, 10);
        if (useChooserDialog) {
            return this.openChooserDialog();
        }
        return this.openClassicDialog();
    }

    String openChooserDialog() {
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        int action = (this.style & 0x2000) != 0 ? 1 : 0;
        int shellHandle = this.parent.topHandle();
        this.handle = OS.gtk_file_chooser_dialog_new(titleBytes, shellHandle, action, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0);
        int pixbufs = OS.gtk_window_get_icon_list(shellHandle);
        if (pixbufs != 0) {
            OS.gtk_window_set_icon_list(this.handle, pixbufs);
            OS.g_list_free(pixbufs);
        }
        this.presetChooserDialog();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        String answer = null;
        if (OS.gtk_dialog_run(this.handle) == -5) {
            answer = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return answer;
    }

    String openClassicDialog() {
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        this.handle = OS.gtk_file_selection_new(titleBytes);
        if (this.parent != null) {
            int shellHandle = this.parent.topHandle();
            OS.gtk_window_set_transient_for(this.handle, shellHandle);
            int pixbufs = OS.gtk_window_get_icon_list(shellHandle);
            if (pixbufs != 0) {
                OS.gtk_window_set_icon_list(this.handle, pixbufs);
                OS.g_list_free(pixbufs);
            }
        }
        this.presetClassicDialog();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        String answer = null;
        if (OS.gtk_dialog_run(this.handle) == -5) {
            answer = this.computeResultClassicDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return answer;
    }

    void presetChooserDialog() {
        byte[] buffer;
        int ptr;
        if ((this.style & 0x2002) == 2) {
            OS.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if (this.filterPath.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.filterPath.charAt(0) != SEPARATOR) {
                stringBuffer.append(SEPARATOR);
            }
            stringBuffer.append(this.filterPath);
            if (this.filterPath.charAt(this.filterPath.length() - 1) != SEPARATOR) {
                stringBuffer.append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                stringBuffer.append(this.fileName);
            } else {
                stringBuffer.append('.');
            }
            byte[] buffer2 = Converter.wcsToMbcs(null, stringBuffer.toString(), true);
            int ptr2 = OS.realpath(buffer2, null);
            if (ptr2 != 0) {
                OS.gtk_file_chooser_set_filename(this.handle, ptr2);
                OS.g_free(ptr2);
            }
        } else if (this.fileName.length() > 0 && this.fileName.charAt(0) == SEPARATOR && (ptr = OS.realpath(buffer = Converter.wcsToMbcs(null, this.fileName, true), null)) != 0) {
            OS.gtk_file_chooser_set_filename(this.handle, ptr);
            OS.g_free(ptr);
        }
        if ((this.style & 0x2000) != 0 && this.fileName.length() > 0) {
            buffer = Converter.wcsToMbcs(null, this.fileName, true);
            OS.gtk_file_chooser_set_current_name(this.handle, buffer);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        int i = 0;
        while (i < this.filterExtensions.length) {
            if (this.filterExtensions[i] != null) {
                byte[] filterString;
                String current;
                byte[] name;
                int filter = OS.gtk_file_filter_new();
                if (this.filterNames.length > i && this.filterNames[i] != null) {
                    name = Converter.wcsToMbcs(null, this.filterNames[i], true);
                    OS.gtk_file_filter_set_name(filter, name);
                } else {
                    name = Converter.wcsToMbcs(null, this.filterExtensions[i], true);
                    OS.gtk_file_filter_set_name(filter, name);
                }
                int start = 0;
                int index = this.filterExtensions[i].indexOf(59);
                while (index != -1) {
                    current = this.filterExtensions[i].substring(start, index);
                    filterString = Converter.wcsToMbcs(null, current, true);
                    OS.gtk_file_filter_add_pattern(filter, filterString);
                    start = index + 1;
                    index = this.filterExtensions[i].indexOf(59, start);
                }
                current = this.filterExtensions[i].substring(start);
                filterString = Converter.wcsToMbcs(null, current, true);
                OS.gtk_file_filter_add_pattern(filter, filterString);
                OS.gtk_file_chooser_add_filter(this.handle, filter);
            }
            ++i;
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    void presetClassicDialog() {
        OS.gtk_file_selection_set_select_multiple(this.handle, (this.style & 2) != 0);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filterPath == null) {
            this.filterPath = "";
        } else if (this.filterPath.length() > 0) {
            stringBuffer.append(this.filterPath);
            if (this.filterPath.charAt(this.filterPath.length() - 1) != SEPARATOR) {
                stringBuffer.append(SEPARATOR);
            }
        }
        if (this.fileName == null) {
            this.fileName = "";
        } else {
            stringBuffer.append(this.fileName);
        }
        this.fullPath = stringBuffer.toString();
        int length = this.fullPath.length();
        char[] buffer = new char[length + 1];
        this.fullPath.getChars(0, length, buffer, 0);
        int utf8Ptr = OS.g_utf16_to_utf8(buffer, -1, null, null, null);
        int fileNamePtr = OS.g_filename_from_utf8(utf8Ptr, -1, null, null, null);
        OS.gtk_file_selection_set_filename(this.handle, fileNamePtr);
        OS.g_free(utf8Ptr);
        OS.g_free(fileNamePtr);
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

