/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.TrimDragPreferences;
import org.eclipse.ui.internal.layout.ICachingLayout;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.SizeCache;
import org.eclipse.ui.internal.layout.TrimArea;
import org.eclipse.ui.internal.layout.TrimCommonUIHandle;
import org.eclipse.ui.internal.layout.TrimDescriptor;
import org.eclipse.ui.internal.layout.TrimToolBarBase;

public class TrimLayout
extends Layout
implements ICachingLayout,
ITrimManager {
    public static final Integer TOP_ID = new Integer(128);
    public static final Integer BOTTOM_ID = new Integer(1024);
    public static final Integer LEFT_ID = new Integer(16384);
    public static final Integer RIGHT_ID = new Integer(131072);
    public static final Integer NONTRIM_ID = new Integer(-1);
    private static final int[] TRIM_ID_INFO = new int[]{16384, 131072, 128, 1024};
    private SizeCache centerArea = new SizeCache();
    private Map fTrimArea = new HashMap();
    private Map fTrimDescriptors = new HashMap();
    private int marginWidth;
    private int marginHeight;
    private int topSpacing;
    private int bottomSpacing;
    private int leftSpacing;
    private int rightSpacing;
    private int spacing = 3;
    private boolean trimLocked;
    private HashMap preferredLocationMap = new HashMap();

    public TrimLayout() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        this.trimLocked = store.getBoolean("LOCK_TRIM");
        this.createTrimArea(TOP_ID, TOP_ID.toString(), -1, 128);
        this.createTrimArea(BOTTOM_ID, BOTTOM_ID.toString(), -1, 1024);
        this.createTrimArea(LEFT_ID, LEFT_ID.toString(), -1, 16384);
        this.createTrimArea(RIGHT_ID, RIGHT_ID.toString(), -1, 131072);
    }

    private void createTrimArea(Integer id, String displayName, int trimSize, int trimMods) {
        TrimArea top = new TrimArea(id, displayName);
        top.setTrimSize(trimSize);
        top.setControlModifiers(trimMods);
        this.fTrimArea.put(id, top);
    }

    public void setSpacing(int left, int right, int top, int bottom) {
        this.leftSpacing = left;
        this.rightSpacing = right;
        this.topSpacing = top;
        this.bottomSpacing = bottom;
    }

    public void setMargins(int marginWidth, int marginHeight) {
        this.marginWidth = marginWidth;
        this.marginHeight = marginHeight;
    }

    public void setTrimSize(int areaId, int size) {
        TrimArea area = (TrimArea)this.fTrimArea.get(new Integer(areaId));
        if (area != null) {
            area.setTrimSize(size);
        }
    }

    public int getTrimAreaId(Control trimControl) {
        TrimDescriptor desc = this.findTrimDescription(trimControl);
        if (desc != null) {
            return desc.getAreaId();
        }
        return -1;
    }

    public void addTrim(IWindowTrim control, int areaId) {
        this.addTrim(areaId, control, null);
    }

    public void addTrim(IWindowTrim trim, int areaId, IWindowTrim beforeMe) {
        this.addTrim(areaId, trim, beforeMe);
    }

    public void addTrim(int areaId, IWindowTrim trim) {
        IWindowTrim insertBefore = null;
        List trimDescs = this.getAreaTrim(areaId);
        Iterator trimIter = trimDescs.iterator();
        while (trimIter.hasNext()) {
            IWindowTrim curTrim = (IWindowTrim)trimIter.next();
            if (!curTrim.getId().equals(trim.getId()) || !trimIter.hasNext()) continue;
            insertBefore = (IWindowTrim)trimIter.next();
        }
        this.addTrim(areaId, trim, insertBefore);
    }

    public void addTrim(int areaId, IWindowTrim trim, IWindowTrim beforeMe) {
        TrimArea area = (TrimArea)this.fTrimArea.get(new Integer(areaId));
        if (area == null) {
            return;
        }
        this.removeTrim(trim);
        TrimDescriptor desc = new TrimDescriptor(trim, areaId);
        boolean isAlreadyAHandle = trim instanceof TrimToolBarBase;
        if (!this.trimLocked && trim.getValidSides() != 0 && !isAlreadyAHandle) {
            TrimCommonUIHandle dockingHandle = new TrimCommonUIHandle(this, trim, areaId);
            desc.setDockingCache(new SizeCache((Control)dockingHandle));
        }
        SizeCache cache = new SizeCache(trim.getControl());
        trim.getControl().setLayoutData((Object)trim);
        desc.setCache(cache);
        trim.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control control = (Control)e.widget;
                if (control.getLayoutData() instanceof IWindowTrim) {
                    IWindowTrim trim = (IWindowTrim)control.getLayoutData();
                    TrimLayout.this.removeTrim(trim);
                }
            }
        });
        this.fTrimDescriptors.put(desc.getId(), desc);
        if (beforeMe != null) {
            TrimDescriptor beforeDesc = (TrimDescriptor)this.fTrimDescriptors.get(beforeMe.getId());
            if (beforeDesc != null && beforeDesc.getAreaId() == areaId) {
                area.addTrim(desc, beforeDesc);
            } else {
                area.addTrim(desc);
            }
        } else {
            area.addTrim(desc);
        }
    }

    public void forceLayout() {
        this.removeDisposed();
        Iterator d = this.fTrimDescriptors.values().iterator();
        while (d.hasNext()) {
            TrimDescriptor desc = (TrimDescriptor)d.next();
            if (desc.getTrim().getControl() == null) continue;
            LayoutUtil.resize(desc.getTrim().getControl());
            return;
        }
    }

    public void removeTrim(IWindowTrim toRemove) {
        TrimDescriptor desc = (TrimDescriptor)this.fTrimDescriptors.remove(toRemove.getId());
        if (desc == null) {
            return;
        }
        TrimArea area = (TrimArea)this.fTrimArea.get(new Integer(desc.getAreaId()));
        if (area != null) {
            area.removeTrim(desc);
            desc.getCache().getControl().setLayoutData(null);
        }
        if (desc.getDockingCache() != null) {
            Control ctrl = desc.getDockingCache().getControl();
            ctrl.setVisible(false);
            desc.setDockingCache(null);
        }
    }

    public IWindowTrim getTrim(String id) {
        TrimDescriptor desc = (TrimDescriptor)this.fTrimDescriptors.get(id);
        if (desc != null) {
            return desc.getTrim();
        }
        return null;
    }

    private void removeDisposed() {
        Iterator a = this.fTrimArea.values().iterator();
        while (a.hasNext()) {
            TrimArea area = (TrimArea)a.next();
            Iterator d = area.getDescriptors().iterator();
            while (d.hasNext()) {
                TrimDescriptor desc = (TrimDescriptor)d.next();
                Control nextControl = desc.getTrim().getControl();
                if (nextControl != null && !nextControl.isDisposed()) continue;
                area.removeTrim(desc);
                this.fTrimDescriptors.remove(desc.getId());
            }
        }
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point result = new Point(wHint, hHint);
        TrimArea top = (TrimArea)this.fTrimArea.get(TOP_ID);
        TrimArea bottom = (TrimArea)this.fTrimArea.get(BOTTOM_ID);
        TrimArea left = (TrimArea)this.fTrimArea.get(LEFT_ID);
        TrimArea right = (TrimArea)this.fTrimArea.get(RIGHT_ID);
        int horizontalTrim = left.calculateTrimSize(wHint, hHint) + right.calculateTrimSize(wHint, hHint) + 2 * this.marginWidth + this.leftSpacing + this.rightSpacing;
        int verticalTrim = top.calculateTrimSize(wHint, hHint) + bottom.calculateTrimSize(wHint, hHint) + 2 * this.marginHeight + this.topSpacing + this.bottomSpacing;
        Point innerSize = this.centerArea.computeSize(wHint == -1 ? wHint : wHint - horizontalTrim, hHint == -1 ? hHint : hHint - verticalTrim);
        if (wHint == -1) {
            result.x = innerSize.x + horizontalTrim;
        } else if (hHint == -1) {
            result.y = innerSize.y + verticalTrim;
        }
        return new Point(0, 0);
    }

    protected void layout(Composite composite, boolean flushCache) {
        this.removeDisposed();
        TrimArea top = (TrimArea)this.fTrimArea.get(TOP_ID);
        TrimArea bottom = (TrimArea)this.fTrimArea.get(BOTTOM_ID);
        TrimArea left = (TrimArea)this.fTrimArea.get(LEFT_ID);
        TrimArea right = (TrimArea)this.fTrimArea.get(RIGHT_ID);
        Rectangle clientArea = composite.getClientArea();
        clientArea.x += this.marginWidth;
        clientArea.width -= 2 * this.marginWidth;
        clientArea.y += this.marginHeight;
        clientArea.height -= 2 * this.marginHeight;
        int trim_top = top.calculateTrimSize(clientArea.width, clientArea.height);
        int trim_bottom = bottom.calculateTrimSize(clientArea.width, clientArea.height);
        int trim_left = left.calculateTrimSize(clientArea.width, clientArea.height);
        int trim_right = right.calculateTrimSize(clientArea.width, clientArea.height);
        int leftOfLayout = clientArea.x;
        int leftOfCenterPane = leftOfLayout + trim_left + this.leftSpacing;
        int widthOfCenterPane = clientArea.width - trim_left - trim_right - this.leftSpacing - this.rightSpacing;
        int rightOfCenterPane = clientArea.x + clientArea.width - trim_right;
        int topOfLayout = clientArea.y;
        trim_top = TrimLayout.arrange(new Rectangle(leftOfLayout, topOfLayout, clientArea.width, trim_top), top.getCaches(), !top.isVertical(), this.spacing);
        int topOfCenterPane = topOfLayout + trim_top + this.topSpacing;
        int heightOfCenterPane = clientArea.height - trim_top - trim_bottom - this.topSpacing - this.bottomSpacing;
        int bottomOfCenterPane = clientArea.y + clientArea.height - trim_bottom;
        TrimLayout.arrange(new Rectangle(leftOfCenterPane, bottomOfCenterPane, widthOfCenterPane, trim_bottom), bottom.getCaches(), !bottom.isVertical(), this.spacing);
        TrimLayout.arrange(new Rectangle(leftOfLayout, topOfCenterPane, trim_left, clientArea.height - trim_top), left.getCaches(), !left.isVertical(), this.spacing);
        TrimLayout.arrange(new Rectangle(rightOfCenterPane, topOfCenterPane, trim_right, clientArea.height - trim_top), right.getCaches(), !right.isVertical(), this.spacing);
        if (this.centerArea.getControl() != null) {
            this.centerArea.getControl().setBounds(leftOfCenterPane, topOfCenterPane, widthOfCenterPane, heightOfCenterPane);
        }
    }

    private static int arrange(Rectangle area, List caches, boolean horizontally, int spacing) {
        Point currentPosition = new Point(area.x, area.y);
        ArrayList resizable = new ArrayList(caches.size());
        ArrayList nonResizable = new ArrayList(caches.size());
        TrimArea.filterResizable(caches, resizable, nonResizable, horizontally);
        int[] sizes = new int[nonResizable.size()];
        int idx = 0;
        int used = 0;
        int hint = Geometry.getDimension((Rectangle)area, (!horizontally ? 1 : 0) != 0);
        Iterator iter = nonResizable.iterator();
        while (iter.hasNext()) {
            SizeCache next = (SizeCache)iter.next();
            sizes[idx] = TrimArea.getSize(next, hint, horizontally);
            used += sizes[idx];
            ++idx;
        }
        int available = Geometry.getDimension((Rectangle)area, (boolean)horizontally) - used - spacing * (caches.size() - 1);
        idx = 0;
        int remainingResizable = resizable.size();
        iter = caches.iterator();
        while (iter.hasNext()) {
            int thisSize;
            SizeCache next = (SizeCache)iter.next();
            if (!next.getControl().isVisible()) continue;
            if (TrimArea.isResizable(next.getControl(), horizontally)) {
                thisSize = available / remainingResizable;
                available -= thisSize;
                --remainingResizable;
            } else {
                thisSize = sizes[idx];
                ++idx;
            }
            if (TrimDragPreferences.showRaggedTrim()) {
                Point prefSize = next.computeSize(-1, -1);
                if (horizontally) {
                    if (next.getControl() instanceof CBanner) {
                        prefSize = next.getControl().computeSize(thisSize, -1);
                        if (prefSize.y > hint) {
                            hint = prefSize.y;
                        }
                    }
                    next.getControl().setBounds(currentPosition.x, currentPosition.y, thisSize, prefSize.y);
                    currentPosition.x += thisSize + spacing;
                    continue;
                }
                next.getControl().setBounds(currentPosition.x, currentPosition.y, prefSize.x, thisSize);
                currentPosition.y += thisSize + spacing;
                continue;
            }
            if (horizontally) {
                next.getControl().setBounds(currentPosition.x, currentPosition.y, thisSize, hint);
                currentPosition.x += thisSize + spacing;
                continue;
            }
            next.getControl().setBounds(currentPosition.x, currentPosition.y, hint, thisSize);
            currentPosition.y += thisSize + spacing;
        }
        return hint;
    }

    public void setCenterControl(Control center) {
        this.centerArea.setControl(center);
    }

    public Control getCenterControl() {
        return this.centerArea.getControl();
    }

    public void flush(Control dirtyControl) {
        if (dirtyControl == this.centerArea.getControl()) {
            this.centerArea.flush();
        } else {
            TrimDescriptor desc = this.findTrimDescription(dirtyControl);
            if (desc != null) {
                desc.flush();
            }
        }
    }

    public int[] getAreaIds() {
        return (int[])TRIM_ID_INFO.clone();
    }

    public List getAreaTrim(int areaId) {
        TrimArea area = (TrimArea)this.fTrimArea.get(new Integer(areaId));
        if (area == null) {
            return Collections.EMPTY_LIST;
        }
        return area.getTrims();
    }

    public void updateAreaTrim(int id, List trim, boolean removeExtra) {
        IWindowTrim t;
        TrimArea area = (TrimArea)this.fTrimArea.get(new Integer(id));
        if (area == null) {
            return;
        }
        List current = area.getTrims();
        Iterator i = trim.iterator();
        while (i.hasNext()) {
            t = (IWindowTrim)i.next();
            t.dock(id);
            this.addTrim(id, t, null);
            current.remove(t);
        }
        if (removeExtra) {
            i = current.iterator();
            while (i.hasNext()) {
                t = (IWindowTrim)i.next();
                this.removeTrim(t);
            }
        }
    }

    public Rectangle getTrimRect(Composite window, int areaId) {
        Rectangle bb = window.getBounds();
        Rectangle cr = window.getClientArea();
        Rectangle tr = window.computeTrim(cr.x, cr.y, cr.width, cr.height);
        Geometry.moveRectangle((Rectangle)cr, (Point)new Point(bb.x - tr.x, bb.y - tr.y));
        TrimArea top = (TrimArea)this.fTrimArea.get(TOP_ID);
        TrimArea bottom = (TrimArea)this.fTrimArea.get(BOTTOM_ID);
        TrimArea left = (TrimArea)this.fTrimArea.get(LEFT_ID);
        TrimArea right = (TrimArea)this.fTrimArea.get(RIGHT_ID);
        int trim_top = top.calculateTrimSize(cr.width, cr.height);
        int trim_bottom = bottom.calculateTrimSize(cr.width, cr.height);
        int trim_left = left.calculateTrimSize(cr.width, cr.height);
        int trim_right = right.calculateTrimSize(cr.width, cr.height);
        if (trim_top == 0) {
            trim_top = this.marginHeight;
        }
        if (trim_bottom == 0) {
            trim_bottom = this.marginHeight;
        }
        if (trim_left == 0) {
            trim_left = this.marginWidth;
        }
        if (trim_right == 0) {
            trim_right = this.marginWidth;
        }
        Rectangle trimRect = new Rectangle(0, 0, 0, 0);
        switch (areaId) {
            case 128: {
                trimRect.x = cr.x;
                trimRect.width = cr.width;
                trimRect.y = cr.y;
                trimRect.height = trim_top;
                break;
            }
            case 1024: {
                trimRect.x = cr.x;
                trimRect.width = cr.width;
                trimRect.y = cr.y + cr.height - trim_bottom;
                trimRect.height = trim_bottom;
                break;
            }
            case 16384: {
                trimRect.x = cr.x;
                trimRect.width = trim_left;
                trimRect.y = cr.y + trim_top;
                trimRect.height = cr.height - (trim_top + trim_bottom);
                break;
            }
            case 131072: {
                trimRect.x = cr.x + cr.width - trim_right;
                trimRect.width = trim_right;
                trimRect.y = cr.y + trim_top;
                trimRect.height = cr.height - (trim_top + trim_bottom);
            }
        }
        return trimRect;
    }

    public List getAllTrim() {
        ArrayList<IWindowTrim> trimList = new ArrayList<IWindowTrim>(this.fTrimDescriptors.size());
        Iterator d = this.fTrimDescriptors.values().iterator();
        while (d.hasNext()) {
            TrimDescriptor desc = (TrimDescriptor)d.next();
            trimList.add(desc.getTrim());
        }
        return trimList;
    }

    public void setTrimVisible(IWindowTrim trim, boolean visible) {
        TrimDescriptor desc = this.findTrimDescription(trim.getControl());
        if (desc != null) {
            desc.setVisible(visible);
        }
    }

    private TrimDescriptor findTrimDescription(Control trim) {
        Iterator d = this.fTrimDescriptors.values().iterator();
        while (d.hasNext()) {
            TrimDescriptor desc = (TrimDescriptor)d.next();
            if (desc.getTrim().getControl() == trim) {
                return desc;
            }
            if (desc.getDockingCache() == null || desc.getDockingCache().getControl() != trim) continue;
            return desc;
        }
        return null;
    }

    public TrimArea getTrimArea(int areaId) {
        return (TrimArea)this.fTrimArea.get(new Integer(areaId));
    }

    public void setPreferredLocations(int areaId, List preferredLocations) {
        this.preferredLocationMap.put(new Integer(areaId), preferredLocations);
    }

    public int getPreferredArea(String trimId) {
        Iterator keyIter = this.preferredLocationMap.keySet().iterator();
        while (keyIter.hasNext()) {
            Integer key = (Integer)keyIter.next();
            List areaList = (List)this.preferredLocationMap.get(key);
            if (!areaList.contains(trimId)) continue;
            return key;
        }
        return -1;
    }

    public IWindowTrim getPreferredLocation(String trimId) {
        Iterator keyIter = this.preferredLocationMap.keySet().iterator();
        while (keyIter.hasNext()) {
            Integer key = (Integer)keyIter.next();
            List areaList = (List)this.preferredLocationMap.get(key);
            int index = areaList.indexOf(trimId);
            if (index == -1) continue;
            int i = index + 1;
            while (i < areaList.size()) {
                String id = (String)areaList.get(i);
                IWindowTrim trim = this.getTrim(id);
                if (trim != null) {
                    return trim;
                }
                ++i;
            }
        }
        return null;
    }

    public List disableTrim(IWindowTrim ignoreMe) {
        ArrayList<Control> disabledControls = new ArrayList<Control>();
        List allTrim = this.getAllTrim();
        Iterator trimIter = allTrim.iterator();
        while (trimIter.hasNext()) {
            Control ctrl;
            IWindowTrim trim = (IWindowTrim)trimIter.next();
            if (ignoreMe == trim || (ctrl = trim.getControl()) == null || ctrl.isDisposed() || !ctrl.isVisible() || !ctrl.isEnabled()) continue;
            ctrl.setEnabled(false);
            disabledControls.add(ctrl);
        }
        return disabledControls;
    }

    public void enableTrim(List disabledControls) {
        Iterator dcIter = disabledControls.iterator();
        while (dcIter.hasNext()) {
            Control ctrl = (Control)dcIter.next();
            if (ctrl.isDisposed() || ctrl.isEnabled()) continue;
            ctrl.setEnabled(true);
        }
    }
}

