/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.layout;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

abstract class AbstractColumnLayout
extends Layout {
    private static int COLUMN_TRIM = "carbon".equals(SWT.getPlatform()) ? 24 : 3;
    static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());
    static final String LAYOUT_DATA = "org.eclipse.jface.LAYOUT_DATA";
    private boolean inupdateMode = false;
    private boolean relayout = true;
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            if (!AbstractColumnLayout.this.inupdateMode) {
                AbstractColumnLayout.this.updateColumnData(event.widget);
            }
        }
    };

    AbstractColumnLayout() {
    }

    public void setColumnData(Widget column, ColumnLayoutData data) {
        if (column.getData(LAYOUT_DATA) == null) {
            column.addListener(11, this.resizeListener);
        }
        column.setData(LAYOUT_DATA, (Object)data);
    }

    private Point computeTableTreeSize(Scrollable scrollable, int wHint, int hHint) {
        Point result = scrollable.computeSize(wHint, hHint);
        int width = 0;
        int size = this.getColumnCount(scrollable);
        int i = 0;
        while (i < size) {
            ColumnLayoutData col;
            ColumnLayoutData layoutData = this.getLayoutData(scrollable, i);
            if (layoutData instanceof ColumnPixelData) {
                col = (ColumnPixelData)layoutData;
                width += col.width;
                if (col.addTrim) {
                    width += COLUMN_TRIM;
                }
            } else if (layoutData instanceof ColumnWeightData) {
                col = (ColumnWeightData)layoutData;
                width += ((ColumnWeightData)col).minimumWidth;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++i;
        }
        if (width > result.x) {
            result.x = width;
        }
        return result;
    }

    private void layoutTableTree(Scrollable scrollable, int width, Rectangle area, boolean increase) {
        int size = this.getColumnCount(scrollable);
        int[] widths = new int[size];
        int[] weightIteration = new int[size];
        int numberOfWeightColumns = 0;
        int fixedWidth = 0;
        int minWeightWidth = 0;
        int totalWeight = 0;
        int i = 0;
        while (i < size) {
            ColumnLayoutData col = this.getLayoutData(scrollable, i);
            if (col instanceof ColumnPixelData) {
                ColumnPixelData cpd = (ColumnPixelData)col;
                int pixels = cpd.width;
                if (cpd.addTrim) {
                    pixels += COLUMN_TRIM;
                }
                widths[i] = pixels;
                fixedWidth += pixels;
            } else if (col instanceof ColumnWeightData) {
                ColumnWeightData cw = (ColumnWeightData)col;
                weightIteration[numberOfWeightColumns] = i;
                ++numberOfWeightColumns;
                totalWeight += cw.weight;
                minWeightWidth += cw.minimumWidth;
                widths[i] = cw.minimumWidth;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++i;
        }
        int restIncludingMinWidths = width - fixedWidth;
        int rest = restIncludingMinWidths - minWeightWidth;
        if (numberOfWeightColumns > 0 && rest > 0) {
            int totalWantedPixels = 0;
            int[] wantedPixels = new int[numberOfWeightColumns];
            int i2 = 0;
            while (i2 < numberOfWeightColumns) {
                ColumnWeightData cw = (ColumnWeightData)this.getLayoutData(scrollable, weightIteration[i2]);
                wantedPixels[i2] = totalWeight == 0 ? 0 : cw.weight * restIncludingMinWidths / totalWeight;
                totalWantedPixels += wantedPixels[i2];
                ++i2;
            }
            int totalDistributed = 0;
            int i3 = 0;
            while (i3 < numberOfWeightColumns) {
                int pixels = totalWantedPixels == 0 ? 0 : wantedPixels[i3] * rest / totalWantedPixels;
                totalDistributed += pixels;
                int n = weightIteration[i3];
                widths[n] = widths[n] + pixels;
                ++i3;
            }
            int diff = rest - totalDistributed;
            int i4 = 0;
            while (diff > 0) {
                int n = weightIteration[i4];
                widths[n] = widths[n] + 1;
                --diff;
                i4 = (i4 + 1) % numberOfWeightColumns;
            }
        }
        if (increase) {
            scrollable.setSize(area.width, area.height);
        }
        this.inupdateMode = true;
        this.setColumnWidths(scrollable, widths);
        scrollable.update();
        this.inupdateMode = false;
        if (!increase) {
            scrollable.setSize(area.width, area.height);
        }
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return this.computeTableTreeSize(this.getControl(composite), wHint, hHint);
    }

    protected void layout(Composite composite, boolean flushCache) {
        int tableWidth;
        Scrollable table;
        Rectangle area = composite.getClientArea();
        int trim = this.computeTrim(area, table = this.getControl(composite), tableWidth = table.getSize().x);
        int width = Math.max(0, area.width - trim);
        if (width > 1) {
            this.layoutTableTree(table, width, area, tableWidth < area.width);
        }
        if (this.relayout) {
            this.relayout = false;
            composite.layout();
        }
    }

    private int computeTrim(Rectangle area, Scrollable scrollable, int currentWidth) {
        int trim = currentWidth > 1 ? currentWidth - scrollable.getClientArea().width : 2 * scrollable.getBorderWidth() + 1;
        return trim;
    }

    Scrollable getControl(Composite composite) {
        return (Scrollable)composite.getChildren()[0];
    }

    abstract int getColumnCount(Scrollable var1);

    abstract void setColumnWidths(Scrollable var1, int[] var2);

    abstract ColumnLayoutData getLayoutData(Scrollable var1, int var2);

    abstract void updateColumnData(Widget var1);
}

