/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XAnyEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    int cursor;
    int window;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int[] unused = new int[1];
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        int xDisplay = this.display.xDisplay;
        OS.XWarpPointer(xDisplay, 0, this.window, 0, 0, 0, 0, newX, newY);
        OS.XQueryPointer(xDisplay, this.window, unused, unused, actualX, actualY, unused, unused, unused);
        return new Point(actualX[0], actualY[0]);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        int[] unused = new int[1];
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        int xDisplay = this.display.xDisplay;
        OS.XWarpPointer(xDisplay, 0, this.window, 0, 0, 0, 0, newX, newY);
        OS.XQueryPointer(xDisplay, this.window, unused, unused, actualX, actualY, unused, unused, unused);
        return new Point(actualX[0], actualY[0]);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int i = 0;
            while (i < rects.length) {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.bounds.width != 0) {
                    x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                    width = rects[i].width * 100 / this.bounds.width;
                } else {
                    width = 100;
                }
                if (this.bounds.height != 0) {
                    y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                    height = rects[i].height * 100 / this.bounds.height;
                } else {
                    height = 100;
                }
                result[i] = new Rectangle(x, y, width, height);
                ++i;
            }
        }
        return result;
    }

    void drawRectangles(Rectangle[] rects, boolean stippled) {
        int xDisplay = this.display.xDisplay;
        int color = OS.XWhitePixel(xDisplay, 0);
        int xWindow = OS.XDefaultRootWindow(xDisplay);
        if (this.parent != null) {
            xWindow = OS.XtWindow(this.parent.handle);
            if (xWindow == 0) {
                return;
            }
            int foreground = this.parent.getForegroundPixel();
            Control control = this.parent.findBackgroundControl();
            if (control == null) {
                control = this.parent;
            }
            int background = control.getBackgroundPixel();
            color = foreground ^ background;
        }
        int gc = OS.XCreateGC(xDisplay, xWindow, 0, null);
        OS.XSetForeground(xDisplay, gc, color);
        OS.XSetSubwindowMode(xDisplay, gc, 1);
        OS.XSetFunction(xDisplay, gc, 6);
        int stipplePixmap = 0;
        if (stippled) {
            byte[] byArray = new byte[16];
            byArray[0] = -86;
            byArray[2] = 85;
            byArray[4] = -86;
            byArray[6] = 85;
            byArray[8] = -86;
            byArray[10] = 85;
            byArray[12] = -86;
            byArray[14] = 85;
            byte[] bits = byArray;
            stipplePixmap = OS.XCreateBitmapFromData(xDisplay, xWindow, bits, 8, 8);
            OS.XSetStipple(xDisplay, gc, stipplePixmap);
            OS.XSetFillStyle(xDisplay, gc, 2);
            OS.XSetLineAttributes(xDisplay, gc, 3, 0, 1, 0);
        }
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            OS.XDrawRectangle(xDisplay, xWindow, gc, rect.x, rect.y, rect.width, rect.height);
            ++i;
        }
        if (stippled) {
            OS.XFreePixmap(xDisplay, stipplePixmap);
        }
        OS.XFreeGC(xDisplay, gc);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] result = new Rectangle[this.rectangles.length];
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    public boolean open() {
        int mouseMasks;
        boolean mouseDown;
        int hStyle;
        this.checkWidget();
        int xDisplay = this.display.xDisplay;
        this.window = OS.XDefaultRootWindow(xDisplay);
        if (this.parent != null) {
            this.window = OS.XtWindow(this.parent.handle);
            if (this.window == 0) {
                return false;
            }
        }
        this.cancelled = false;
        this.tracking = true;
        this.update();
        this.drawRectangles(this.rectangles, this.stippled);
        int[] oldX = new int[1];
        int[] oldY = new int[1];
        int[] unused = new int[1];
        int[] mask = new int[1];
        OS.XQueryPointer(xDisplay, this.window, unused, unused, oldX, oldY, unused, unused, mask);
        int vStyle = this.style & 0x480;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 0x24000) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        boolean bl = mouseDown = (mask[0] & (mouseMasks = 1792)) != 0;
        if (!mouseDown) {
            Point cursorPos = null;
            cursorPos = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
            if (cursorPos != null) {
                oldX[0] = cursorPos.x;
                oldY[0] = cursorPos.y;
            }
        }
        this.oldX = oldX[0];
        this.oldY = oldY[0];
        int ptrGrabResult = OS.XGrabPointer(xDisplay, this.window, 0, 76, 1, 1, 0, 0, 0);
        int kbdGrabResult = OS.XGrabKeyboard(xDisplay, this.window, 0, 1, 1, 0);
        XAnyEvent anyEvent = new XAnyEvent();
        int xEvent = OS.XtMalloc(96);
        int dispatch = OS.XtMalloc(4);
        int xtContext = OS.XtDisplayToApplicationContext(xDisplay);
        while (this.tracking) {
            if (this.parent != null && this.parent.isDisposed()) break;
            OS.XtAppNextEvent(xtContext, xEvent);
            OS.memmove(anyEvent, xEvent, 20);
            int widget = OS.XtWindowToWidget(anyEvent.display, anyEvent.window);
            switch (anyEvent.type) {
                case 6: {
                    this.XPointerMotion(widget, 0, xEvent, dispatch);
                    break;
                }
                case 5: {
                    this.XButtonRelease(widget, 0, xEvent, dispatch);
                    break;
                }
                case 2: {
                    this.XKeyPress(widget, 0, xEvent, dispatch);
                    break;
                }
                case 3: {
                    this.XKeyRelease(widget, 0, xEvent, dispatch);
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    break;
                }
                case 12: {
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                    OS.XtDispatchEvent(xEvent);
                    this.drawRectangles(this.rectangles, this.stippled);
                    break;
                }
                default: {
                    OS.XtDispatchEvent(xEvent);
                }
            }
        }
        if (xEvent != 0) {
            OS.XtFree(xEvent);
        }
        if (dispatch != 0) {
            OS.XtFree(dispatch);
        }
        if (!this.isDisposed()) {
            this.update();
            this.drawRectangles(this.rectangles, this.stippled);
        }
        if (ptrGrabResult == 0) {
            OS.XUngrabPointer(xDisplay, 0);
        }
        if (kbdGrabResult == 0) {
            OS.XUngrabKeyboard(xDisplay, 0);
        }
        this.window = 0;
        return !this.cancelled;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor value) {
        this.checkWidget();
        this.cursor = 0;
        if (value != null) {
            this.cursor = value.handle;
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        this.rectangles = new Rectangle[rectangles.length];
        int i = 0;
        while (i < rectangles.length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }

    void update() {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
    }

    int XButtonRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        return this.xMouse(5, w, client_data, call_data, continue_to_dispatch);
    }

    int XKeyPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XKeyPress(w, client_data, call_data, continue_to_dispatch);
        if (result != 0) {
            return result;
        }
        XKeyEvent keyEvent = new XKeyEvent();
        OS.memmove(keyEvent, call_data, 60);
        if (keyEvent.keycode != 0) {
            int[] keysym = new int[1];
            OS.XLookupString(keyEvent, null, 0, keysym, null);
            keysym[0] = keysym[0] & 0xFFFF;
            int xChange = 0;
            int yChange = 0;
            int stepSize = (keyEvent.state & 4) != 0 ? 1 : 9;
            switch (keysym[0]) {
                case 65293: 
                case 65421: {
                    this.tracking = false;
                    OS.XtAppNextEvent(OS.XtDisplayToApplicationContext(keyEvent.display), call_data);
                    break;
                }
                case 65307: {
                    this.tracking = false;
                    this.cancelled = true;
                    OS.XtAppNextEvent(OS.XtDisplayToApplicationContext(keyEvent.display), call_data);
                    break;
                }
                case 65361: {
                    xChange = -stepSize;
                    break;
                }
                case 65363: {
                    xChange = stepSize;
                    break;
                }
                case 65362: {
                    yChange = -stepSize;
                    break;
                }
                case 65364: {
                    yChange = stepSize;
                }
            }
            if (xChange != 0 || yChange != 0) {
                Point cursorPos;
                Rectangle[] oldRectangles = this.rectangles;
                boolean oldStippled = this.stippled;
                Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
                int i = 0;
                while (i < this.rectangles.length) {
                    Rectangle current = this.rectangles[i];
                    rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                    ++i;
                }
                Event event = new Event();
                event.x = this.oldX + xChange;
                event.y = this.oldY + yChange;
                if ((this.style & 0x10) != 0) {
                    this.resizeRectangles(xChange, yChange);
                    this.sendEvent(11, event);
                    if (this.isDisposed()) {
                        this.cancelled = true;
                        return 1;
                    }
                    boolean draw = false;
                    if (this.rectangles != oldRectangles) {
                        int length = this.rectangles.length;
                        if (length != rectsToErase.length) {
                            draw = true;
                        } else {
                            int i2 = 0;
                            while (i2 < length) {
                                if (!this.rectangles[i2].equals(rectsToErase[i2])) {
                                    draw = true;
                                    break;
                                }
                                ++i2;
                            }
                        }
                    } else {
                        draw = true;
                    }
                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.update();
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustResizeCursor();
                } else {
                    this.moveRectangles(xChange, yChange);
                    this.sendEvent(10, event);
                    if (this.isDisposed()) {
                        this.cancelled = true;
                        return 1;
                    }
                    boolean draw = false;
                    if (this.rectangles != oldRectangles) {
                        int length = this.rectangles.length;
                        if (length != rectsToErase.length) {
                            draw = true;
                        } else {
                            int i3 = 0;
                            while (i3 < length) {
                                if (!this.rectangles[i3].equals(rectsToErase[i3])) {
                                    draw = true;
                                    break;
                                }
                                ++i3;
                            }
                        }
                    } else {
                        draw = true;
                    }
                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.update();
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustMoveCursor();
                }
                if (cursorPos != null) {
                    this.oldX = cursorPos.x;
                    this.oldY = cursorPos.y;
                }
            }
        }
        return result;
    }

    int XPointerMotion(int w, int client_data, int call_data, int continue_to_dispatch) {
        if (this.cursor != 0) {
            int xDisplay = this.display.xDisplay;
            OS.XChangeActivePointerGrab(xDisplay, 76, this.cursor, 0);
        }
        return this.xMouse(6, w, client_data, call_data, continue_to_dispatch);
    }

    int xMouse(int type, int w, int client_data, int call_data, int continue_to_dispatch) {
        int xDisplay = this.display.xDisplay;
        int[] newX = new int[1];
        int[] newY = new int[1];
        int[] unused = new int[1];
        OS.XQueryPointer(xDisplay, this.window, unused, unused, newX, newY, unused, unused, unused);
        if (this.oldX != newX[0] || this.oldY != newY[0]) {
            Rectangle[] oldRectangles = this.rectangles;
            boolean oldStippled = this.stippled;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i = 0;
            while (i < this.rectangles.length) {
                Rectangle current = this.rectangles[i];
                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i;
            }
            Event event = new Event();
            event.x = newX[0];
            event.y = newY[0];
            if ((this.style & 0x10) != 0) {
                Point cursorPos;
                this.resizeRectangles(newX[0] - this.oldX, newY[0] - this.oldY);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i2 = 0;
                        while (i2 < length) {
                            if (!this.rectangles[i2].equals(rectsToErase[i2])) {
                                draw = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(rectsToErase, oldStippled);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                if ((cursorPos = this.adjustResizeCursor()) != null) {
                    newX[0] = cursorPos.x;
                    newY[0] = cursorPos.y;
                }
            } else {
                this.moveRectangles(newX[0] - this.oldX, newY[0] - this.oldY);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i3 = 0;
                        while (i3 < length) {
                            if (!this.rectangles[i3].equals(rectsToErase[i3])) {
                                draw = true;
                                break;
                            }
                            ++i3;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(rectsToErase, oldStippled);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
            }
            this.oldX = newX[0];
            this.oldY = newY[0];
        }
        this.tracking = type != 5;
        return 0;
    }
}

