/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    int drawCount;
    int itemCount;
    ToolItem[] items;
    ToolItem lastFocus;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            width = Integer.MAX_VALUE;
        }
        if (hHint == -1) {
            height = Integer.MAX_VALUE;
        }
        int[] result = this.layout(width, height, false);
        int border = this.getBorderWidth() * 2;
        Point extent = new Point(result[1], result[2]);
        if (wHint != -1) {
            extent.x = wHint;
        }
        if (hHint != -1) {
            extent.y = hHint;
        }
        extent.x += border;
        extent.y += border;
        return extent;
    }

    void createHandle(int index) {
        super.createHandle(index);
        this.state &= 0xFFFFFFFD;
    }

    void createItem(ToolItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] newItems = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.createWidget(index);
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
        this.relayout();
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    void destroyItem(ToolItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        shell.bringToTop(false);
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (item.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.forceFocus();
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            return this.items[index];
        }
        this.error(6);
        return null;
    }

    public ToolItem getItem(Point pt) {
        this.checkWidget();
        if (pt == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            Rectangle rect = this.items[i].getBounds();
            if (rect.contains(pt)) {
                return this.items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] result = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public int getRowCount() {
        this.checkWidget();
        Rectangle rect = this.getClientArea();
        return this.layout(rect.width, rect.height, false)[0];
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int[] layoutHorizontal(int width, int height, boolean resize) {
        int xSpacing = 0;
        int ySpacing = (this.style & 0x80000) != 0 ? 4 : 2;
        int marginWidth = 0;
        int marginHeight = 0;
        int x = marginWidth;
        int y = marginHeight;
        int maxX = 0;
        int rows = 1;
        boolean wrap = (this.style & 0x40) != 0;
        int itemHeight = 0;
        Point[] sizes = new Point[this.itemCount];
        GC gc = new GC(this);
        int i = 0;
        while (i < this.itemCount) {
            Point size = sizes[i] = this.items[i].computeSize(gc);
            itemHeight = Math.max(itemHeight, size.y);
            ++i;
        }
        i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            Point size = sizes[i];
            if (wrap && i != 0 && x + size.x > width) {
                ++rows;
                x = marginWidth;
                y += ySpacing + itemHeight;
            }
            if (resize) {
                item.setBounds(x, y, size.x, itemHeight);
                boolean visible = x + size.x <= width && y + itemHeight <= height;
                item.setVisible(visible);
                Control control = item.control;
                if (control != null) {
                    int controlY = y + (itemHeight - size.y) / 2;
                    control.setBounds(x, controlY, size.x, itemHeight - (controlY - y));
                }
            }
            maxX = Math.max(maxX, x += xSpacing + size.x);
            ++i;
        }
        gc.dispose();
        return new int[]{rows, maxX, y + itemHeight};
    }

    int[] layoutVertical(int width, int height, boolean resize) {
        int xSpacing = (this.style & 0x80000) != 0 ? 4 : 2;
        int ySpacing = 0;
        int marginWidth = 0;
        int marginHeight = 0;
        int x = marginWidth;
        int y = marginHeight;
        int maxY = 0;
        int cols = 1;
        boolean wrap = (this.style & 0x40) != 0;
        int itemWidth = 0;
        Point[] sizes = new Point[this.itemCount];
        GC gc = new GC(this);
        int i = 0;
        while (i < this.itemCount) {
            Point size = sizes[i] = this.items[i].computeSize(gc);
            itemWidth = Math.max(itemWidth, size.x);
            ++i;
        }
        i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            Point size = sizes[i];
            if (wrap && i != 0 && y + size.y > height) {
                ++cols;
                x += xSpacing + itemWidth;
                y = marginHeight;
            }
            if (resize) {
                item.setBounds(x, y, itemWidth, size.y);
                boolean visible = x + itemWidth <= width && y + size.y <= height;
                item.setVisible(visible);
                Control control = item.control;
                if (control != null) {
                    int controlX = x + (itemWidth - size.x) / 2;
                    control.setBounds(controlX, y, itemWidth - (controlX - x), size.y);
                }
            }
            maxY = Math.max(maxY, y += ySpacing + size.y);
            ++i;
        }
        return new int[]{cols, x + itemWidth, maxY};
    }

    int[] layout(int nWidth, int nHeight, boolean resize) {
        if ((this.style & 0x200) != 0) {
            return this.layoutVertical(nWidth, nHeight, resize);
        }
        return this.layoutHorizontal(nWidth, nHeight, resize);
    }

    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            char mnemonic = this.findMnemonic(item.getText());
            if (mnemonic != '\u0000' && Character.toUpperCase(key) == Character.toUpperCase(mnemonic)) {
                this.XmProcessTraversal(item.handle, 0);
                item.click(false, 0);
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        int i = 0;
        while (i < this.itemCount) {
            char mnemonic;
            ToolItem item = this.items[i];
            if (item.getEnabled() && (mnemonic = this.findMnemonic(item.getText())) != '\u0000' && Character.toUpperCase(key) == Character.toUpperCase(mnemonic)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        int i = 0;
        while (i < this.itemCount) {
            this.items[i].propagateWidget(enabled);
            ++i;
        }
    }

    void realizeChildren() {
        super.realizeChildren();
        if (this.items != null) {
            int i = 0;
            while (i < this.itemCount) {
                ToolItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.realizeChildren();
                }
                ++i;
            }
        }
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean allChildren, boolean trim) {
        super.redrawWidget(x, y, width, height, redrawAll, allChildren, trim);
        if (this.items != null) {
            int i = 0;
            while (i < this.itemCount) {
                ToolItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.redrawWidget(x, y, width, height, redrawAll, allChildren, true);
                }
                ++i;
            }
        }
    }

    void relayout() {
        if (this.drawCount > 0) {
            return;
        }
        Rectangle rect = this.getClientArea();
        this.layout(rect.width, rect.height, true);
    }

    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.itemCount) {
                ToolItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int i = 0;
        while (i < this.itemCount) {
            this.items[i].setBackgroundPixel(pixel);
            ++i;
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && resize) {
            this.relayout();
        }
        return changed;
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.relayout();
    }

    void setForegroundPixel(int pixel) {
        super.setForegroundPixel(pixel);
        int i = 0;
        while (i < this.itemCount) {
            this.items[i].setForegroundPixel(pixel);
            ++i;
        }
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                this.relayout();
            }
        } else {
            ++this.drawCount;
        }
    }

    boolean setTabItemFocus(boolean next) {
        int index = 0;
        while (index < this.itemCount) {
            ToolItem item = this.items[index];
            if ((item.style & 2) == 0 && item.getEnabled()) break;
            ++index;
        }
        if (index == this.itemCount) {
            return false;
        }
        return super.setTabItemFocus(next);
    }

    int traversalCode(int key, XKeyEvent xEvent) {
        return super.traversalCode(key, xEvent) | 0x80;
    }

    int xFocusIn(XFocusChangeEvent xEvent) {
        int newFocus = OS.XmGetFocusWidget(this.handle);
        if (newFocus != this.focusHandle()) {
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i].handle == newFocus) {
                    this.lastFocus = this.items[i];
                    break;
                }
                ++i;
            }
        }
        return super.xFocusIn(xEvent);
    }
}

