/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String filterPath = "";
    boolean cancel = true;
    String message = "";
    static final String SEPARATOR = System.getProperty("file.separator");

    public DirectoryDialog(Shell parent) {
        this(parent, 32768);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    int activate(int widget, int client, int call) {
        this.cancel = client == 2;
        OS.XtUnmanageChild(widget);
        return 0;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        int parent2;
        byte[] name;
        int parentHandle;
        int dialog;
        int child;
        String string = this.title;
        if (string.length() == 0) {
            string = " ";
        }
        byte[] buffer1 = Converter.wcsToMbcs(null, string, true);
        int xmStringPtr1 = OS.XmStringParseText(buffer1, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        byte[] buffer2 = Converter.wcsToMbcs(null, "*", true);
        int xmStringPtr2 = OS.XmStringParseText(buffer2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        byte[] buffer3 = Converter.wcsToMbcs(null, this.filterPath, true);
        int xmStringPtr3 = OS.XmStringParseText(buffer3, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        byte[] buffer7 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Selection"), true);
        int xmStringPtr4 = OS.XmStringParseText(buffer7, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        boolean defaultPos = this.parent.isVisible();
        Display display = this.parent.display;
        int[] nArray = new int[18];
        nArray[0] = OS.XmNresizePolicy;
        nArray[2] = OS.XmNdialogStyle;
        nArray[3] = 1;
        nArray[4] = OS.XmNwidth;
        nArray[5] = OS.XDisplayWidth(display.xDisplay, OS.XDefaultScreen(display.xDisplay)) * 4 / 9;
        nArray[6] = OS.XmNdialogTitle;
        nArray[7] = xmStringPtr1;
        nArray[8] = OS.XmNpattern;
        nArray[9] = xmStringPtr2;
        nArray[10] = OS.XmNdirectory;
        nArray[11] = xmStringPtr3;
        nArray[12] = OS.XmNpathMode;
        nArray[14] = OS.XmNfilterLabelString;
        nArray[15] = xmStringPtr4;
        nArray[16] = OS.XmNdefaultPosition;
        nArray[17] = defaultPos ? 1 : 0;
        int[] argList1 = nArray;
        if (OS.IsAIX) {
            this.parent.realizeWidget();
        }
        if ((child = OS.XmFileSelectionBoxGetChild(dialog = OS.XmCreateFileSelectionDialog(parentHandle = this.parent.shellHandle, name = new byte[1], argList1, argList1.length / 2), 7)) != 0) {
            OS.XtUnmanageChild(child);
        }
        if ((child = OS.XmFileSelectionBoxGetChild(dialog, 8)) != 0 && (parent2 = OS.XtParent(child)) != 0) {
            OS.XtUnmanageChild(parent2);
        }
        if ((child = OS.XmFileSelectionBoxGetChild(dialog, 9)) != 0) {
            OS.XtUnmanageChild(child);
        }
        if ((child = OS.XmFileSelectionBoxGetChild(dialog, 13)) != 0) {
            OS.XtUnmanageChild(child);
        }
        if ((child = OS.XmFileSelectionBoxGetChild(dialog, 11)) != 0) {
            OS.XtUnmanageChild(child);
        }
        OS.XmStringFree(xmStringPtr1);
        OS.XmStringFree(xmStringPtr2);
        OS.XmStringFree(xmStringPtr3);
        OS.XmStringFree(xmStringPtr4);
        byte[] buffer4 = Converter.wcsToMbcs(null, this.message, true);
        int xmString1 = OS.XmStringGenerate(buffer4, null, 0, null);
        int[] argList2 = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, xmString1};
        int textArea = OS.XmCreateLabel(dialog, name, argList2, argList2.length / 2);
        OS.XtManageChild(textArea);
        OS.XmStringFree(xmString1);
        Callback callback = new Callback(this, "activate", 3);
        int address = callback.getAddress();
        if (address == 0) {
            SWT.error(3);
        }
        OS.XtAddCallback(dialog, OS.XmNokCallback, address, 4);
        OS.XtAddCallback(dialog, OS.XmNcancelCallback, address, 2);
        this.cancel = true;
        if (!defaultPos) {
            OS.XtRealizeWidget(dialog);
            int[] nArray2 = new int[4];
            nArray2[0] = OS.XmNwidth;
            nArray2[2] = OS.XmNheight;
            int[] argList3 = nArray2;
            OS.XtGetValues(dialog, argList3, argList3.length / 2);
            Monitor monitor = this.parent.getMonitor();
            Rectangle bounds = monitor.getBounds();
            int x = bounds.x + (bounds.width - argList3[1]) / 2;
            int y = bounds.y + (bounds.height - argList3[3]) / 2;
            int[] argList4 = new int[]{OS.XmNx, x, OS.XmNy, y};
            OS.XtSetValues(dialog, argList4, argList4.length / 2);
        }
        OS.XtManageChild(dialog);
        while (OS.XtIsRealized(dialog) && OS.XtIsManaged(dialog)) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        String directoryPath = "";
        if (!this.cancel) {
            int[] nArray3 = new int[2];
            nArray3[0] = OS.XmNdirMask;
            int[] argList5 = nArray3;
            OS.XtGetValues(dialog, argList5, argList5.length / 2);
            int xmString3 = argList5[1];
            int[] table = new int[]{display.tabMapping, display.crMapping};
            int ptr = OS.XmStringUnparse(xmString3, null, 0, 0, table, table.length, 0);
            if (ptr != 0) {
                int length = OS.strlen(ptr);
                byte[] buffer = new byte[length];
                OS.memmove(buffer, ptr, length);
                OS.XtFree(ptr);
                directoryPath = new String(Converter.mbcsToWcs(null, buffer));
            }
            OS.XmStringFree(xmString3);
            int length = directoryPath.length();
            if (directoryPath.charAt(length - 1) == '*') {
                directoryPath = directoryPath.substring(0, length - 1);
                --length;
            }
            if (directoryPath.endsWith(SEPARATOR) && !directoryPath.equals(SEPARATOR)) {
                directoryPath = directoryPath.substring(0, length - 1);
            }
            this.filterPath = directoryPath;
        }
        if (OS.XtIsRealized(dialog)) {
            OS.XtDestroyWidget(dialog);
        }
        callback.dispose();
        if (this.cancel) {
            return null;
        }
        return directoryPath;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

