/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.common.actions;

import com.hisagisoft.common.ISelectable;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CopyToClipActions
extends Action {
    private static Logger logger = Logger.getLogger(CopyToClipActions.class.getName());
    private ISelectable selectable;

    public CopyToClipActions(String text) {
        super(text);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    public void setSelectable(ISelectable selectable) {
        this.selectable = selectable;
    }

    public void run() {
        logger.fine("CopyToClip - START");
        try {
            if (this.selectable.isEmpty()) {
                return;
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Clipboard clipboard = new Clipboard(shell.getDisplay());
            clipboard.setContents(new Object[]{this.selectable.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        logger.fine("CopyToClip - END");
    }
}

