/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import jp.ossc.tstruts.common.DynaUserProfile;

import junit.framework.TestCase;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class UserProfileConfigTest extends TestCase {

	/**
	 * Constructor for UserProfileConfigTest.
	 * @param arg0
	 */
	public UserProfileConfigTest(String name) {
		super(name);
	}

	String className;
	String initializerClassName;
	UserProfilePropertyConfig properties[];

	protected void setUp() throws Exception {
		className = "jp.ossc.tstruts.common.DynaUserProfile";
		initializerClassName = "jp.ossc.tstruts.auth.DefaultInitializer";
		properties = new UserProfilePropertyConfig[0];
	}

	/**
	 * UserProfileNXƂDynaUserProfilẽTuNXw肵Ƃ
	 * isDynamictrueԂ
	 * @throws Exception
	 */
	public void testIsDynamic() throws Exception {
		setUp();
		UserProfileConfig config = createUserProfileConfig();
		assertEquals(config.isDynamic(), true);
	}

	/**
	 * UserProfileNXƂDynaUserProfilẽTuNXȊOw肵Ƃ
	 * isDynamicfalseԂ
	 * @throws Exception
	 */
	public void testIsNotDynamic() throws Exception {
		setUp();
		className = "java.lang.Object";
		UserProfileConfig config = createUserProfileConfig();
		assertEquals(config.isDynamic(), false);
	}

	/**
	 * w肵[Uvt@CNX邩
	 * @throws Exception
	 */
	public void testCreateUserProfile() throws Exception {
		setUp();
		UserProfileConfig config = createUserProfileConfig();
		DynaUserProfile profile = (DynaUserProfile)config.createUserProfile();
		assertEquals(profile.getClass(), DynaUserProfile.class);
	}

	/**
	 * ꖼ̂̍ڂ`ꂽG[ɂȂ邩
	 * @throws Exception
	 */
	public void testPropertyConfig() throws Exception {
		setUp();
		properties = new UserProfilePropertyConfig[] {
			new UserProfilePropertyConfig("test1", "String", 0),
			new UserProfilePropertyConfig("test1", "String", 0)
		};
		try {
			createUserProfileConfig();
			fail();
		} catch (IllegalArgumentException ex) {
		}
	}

	/**
	 * 쐬ڂɒlݒłAl擾ł邩
	 * @throws Exception
	 */
	public void testProperties() throws Exception {
		setUp();
		properties = new UserProfilePropertyConfig[] {
			new UserProfilePropertyConfig("test1", "String", 0),
		};
		UserProfileConfig config = createUserProfileConfig();
		DynaUserProfile profile = (DynaUserProfile)config.createUserProfile();

		profile.set("test1", "test string");
		assertEquals(profile.get("test1"), "test string");
	}
	
	/**
	 * [Uvt@Cڂ̃f[^^[hłȂƂɃG[Oo͂A
	 * [Uvt@C쐬\bhnullԂƂmF
	 * @throws Exception
	 */
	public void testPropertyInstantiationFailure() throws Exception {
		setUp();
		properties = new UserProfilePropertyConfig[] {
			new UserProfilePropertyConfig("test1", "org.hoge.Moge", 0)
		};
		UserProfileConfig config = createUserProfileConfig();
		DynaUserProfile profile = (DynaUserProfile)config.createUserProfile();
		assertNull(profile);
	}

	/**
	 * UserProfileConfigCX^X쐬eXgp[eBeB\bhB
	 * @param className
	 * @param initializerClassName
	 * @param properties
	 * @return
	 * @throws Exception
	 */
	public static UserProfileConfig createUserProfileConfig(
		String className, String initializerClassName,
		UserProfilePropertyConfig properties[])
	throws Exception {
		UserProfileConfig config = new UserProfileConfig(className, initializerClassName);
		if (properties != null) {
			for (int i = 0; i < properties.length; ++i) {
				config.addProperty(properties[i]);
			}
		}
		return config;
	}

	/**
	 * UserProfile쐬eXgp[eBeB\bh
	 * @param className
	 * @param initializerClassName
	 * @param properties
	 * @return
	 * @throws Exception
	 */
	public static Object createUserProfile(
		String className, String initializerClassName,
		UserProfilePropertyConfig properties[])
	throws Exception {
		UserProfileConfig config =
			createUserProfileConfig(className, initializerClassName, properties);
		return config.createUserProfile();
	}

	/**
	 * UserProfileConfigNX쐬Bȉ̃oϐgAsB
	 * <dl>
	 *   <dt>className</dt>
	 *   <dd>vt@C̃NX</dd>
	 *   <dt>initializerClassName</dt>
	 *   <dd>CjVCŨNX</dd>
	 *   <dt>properties</dt>
	 *   <dd>UserProfilePropertyConfig̔z</dd>
	 * </dl>
	 * @return
	 * @throws Exception
	 */
	private UserProfileConfig createUserProfileConfig() throws Exception {
		return createUserProfileConfig(className, initializerClassName, properties);
	}
}
