/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.taglib.html;

import java.io.IOException;

import javax.servlet.ServletException;

import org.apache.cactus.JspTestCase;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

import jp.ossc.tstruts.config.ExtendFormPropertyConfig;


/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class TestExtendFormTag extends JspTestCase {


	public void testTransferParameter() throws IOException, ServletException {
		String url = "http://localhost:8080/tstruts-cactus/testTransfer.do";
		WebRequest webRequest = new GetMethodWebRequest(url);
		webRequest.setParameter("nottransfer", "string-nottransfer");
		webRequest.setParameter("transfer", "string-transfer");

		try {
			WebConversation webConversation = new WebConversation();
			WebResponse webResponse = webConversation.getResponse(webRequest);
			webResponse = webResponse.getForms()[0].submit();
			assertTrue(StringUtils.contains(webResponse.getText(), "string-transfer"));

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}
	
	public void testImportParameter() {
		String url = "http://localhost:8080/tstruts-cactus/testImport.do";
		WebRequest webRequest = new GetMethodWebRequest(url);
		webRequest.setParameter("nottransfer", "string-nottransfer");
		webRequest.setParameter("transfer", "string-transfer");

		try {
			WebConversation webConversation = new WebConversation();
			WebResponse webResponse = webConversation.getResponse(webRequest);

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}

		// NGXgɒlݒ肳Ă邩`FbN
		ActionMapping mapping = (ActionMapping)request.getAttribute(Globals.MAPPING_KEY);
		
		boolean result = ((ExtendFormPropertyConfig)
					((ModuleConfig) request.getAttribute(Globals.MODULE_KEY)).
					findFormBeanConfig("testParameterFormBean").findFormPropertyConfig("nottransfer")).
					getTransfer();
		assertFalse(result);

		// vpeBtransferimportĂ邩
		result = ((ExtendFormPropertyConfig)
					((ModuleConfig) request.getAttribute(Globals.MODULE_KEY)).
					findFormBeanConfig("testImportFormBean").findFormPropertyConfig("transfer")).
					getTransfer();
		assertTrue(result);

		result = ((ExtendFormPropertyConfig)
					((ModuleConfig) request.getAttribute(Globals.MODULE_KEY)).
					findFormBeanConfig("testImportFormBean").findFormPropertyConfig("nottransfer")).
					getTransfer();
		assertFalse(result);

	}

	public void testImportParameterAttribute() {
		String url = "http://localhost:8080/tstruts-cactus/testImportAttribute.do";
		WebRequest webRequest = new GetMethodWebRequest(url);
		webRequest.setParameter("nottransfer", "string-nottransfer");
		webRequest.setParameter("transfer", "string-transfer");

		try {
			WebConversation webConversation = new WebConversation();
			WebResponse webResponse = webConversation.getResponse(webRequest);

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}

		// importtransfereɔfĂ邩
		boolean result = ((ExtendFormPropertyConfig)
					((ModuleConfig) request.getAttribute(Globals.MODULE_KEY)).
					findFormBeanConfig("testImportAttributeFormBean").findFormPropertyConfig("transfer")).
					getTransfer();
		assertTrue(result);

		result = ((ExtendFormPropertyConfig)
					((ModuleConfig) request.getAttribute(Globals.MODULE_KEY)).
					findFormBeanConfig("testImportAttributeFormBean").findFormPropertyConfig("nottransfer")).
					getTransfer();
		assertTrue(result);
	}

//	JunitɈڍs
//
//	public void testSameFormProperty() {
//		String url = "http://localhost:8080/tstruts-cactus/testSameFormProperty.do";
//		WebRequest webRequest = new GetMethodWebRequest(url);
//		webRequest.setParameter("nottransfer", "string-nottransfer");
//		webRequest.setParameter("transfer", "string-transfer");
//
//		try {
//			WebConversation webConversation = new WebConversation();
//			WebResponse webResponse = webConversation.getResponse(webRequest);
//
//			fail("not catch any Exception.");
//		} catch (Exception e) {
//			e.printStackTrace();
//			// 
//		}
//	}

//  JunitɈڍs
//
//	public void testNotExistForm() {
//		String url = "http://localhost:8080/tstruts-cactus/testSameFormProperty.do";
//		WebRequest webRequest = new GetMethodWebRequest(url);
//		webRequest.setParameter("nottransfer", "string-nottransfer");
//		webRequest.setParameter("transfer", "string-transfer");
//
//		try {
//			WebConversation webConversation = new WebConversation();
//			WebResponse webResponse = webConversation.getResponse(webRequest);
//
//			fail("not catch any Exception.");
//		} catch (Exception e) {
//			e.printStackTrace();
//			// 
//		}
//
//		try{
//			setActionServlet(new ExtendActionServlet());
//
//			setConfigFile("/WEB-INF/struts-config-test-ExtendFormTag.xml,/WEB-INF/struts-config-test-NotExistFormImport.xml");	
//
//			// eXg郊NGXg̃pXݒ肷
//			setRequestPathInfo("/testNotNameForm");
//			// ANVĂяo
//			actionPerform();
//			
//			fail("not catch any Exception.");
//		}catch(IllegalArgumentException e){
//			e.printStackTrace();
//			// 
//		}
//
//	}
}
