/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.taglib.env;

import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;

import junit.framework.TestCase;


/**
 * &lt;tstruts:env&gt;^ÕeXg
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class EnvTagTest extends TestCase {
	
	protected com.meterware.httpunit.WebConversation webConversation = null;

	/**
	 * @param eXgP[X
	 */
	public EnvTagTest(String arg0) {
		super(arg0);
	}


	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		webConversation = new com.meterware.httpunit.WebConversation();
	}

	/**
	 * <ul>
	 *   <li>&lt;env&gt;^Opropertyŕϐw肵Al擾ł邱
	 *   <li>&lt;env&gt;^Õ^Õ{fBŕϐw肵Al擾ł邱
	 * </ul>
	 * @throws Exception
	 */
	public void testEnvTag() throws Exception {
		WebResponse webResponse = webConversation.getResponse(
			"http://localhost:8080/tstruts-cactus/testEnvTag.do");
		WebTable table = webResponse.getTables()[0];

		// propertyɂ擾
		String env1 = table.getCellAsText(0, 0);
		assertEquals("env1value", env1);

		// {fBɂ擾
		String env2 = table.getCellAsText(0, 1);
		assertEquals("env2value", env2);
		
	}

	/**
	 * <ul>
	 *   <li>&lt;bean:write&gt;ŕϐw肵Al擾ł邱
	 * </ul>
	 * @throws Exception
	 */	
	public void testEnvByBeanTag() throws Exception {
		WebResponse webResponse = webConversation.getResponse(
			"http://localhost:8080/tstruts-cactus/testEnvTag.do");
		WebTable table = webResponse.getTables()[0];

		String env1 = table.getCellAsText(1, 0);
		assertEquals("env1value", env1);
	}
}
