/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.auth;

import javax.sql.DataSource;

import org.apache.cactus.FilterTestCase;
import org.apache.cactus.WebRequest;
import org.apache.cactus.client.authentication.BasicAuthentication;
import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.common.DynaUserProfile;
import jp.ossc.tstruts.config.RootModuleConfigImpl;
import jp.ossc.tstruts.config.UserProfileConfig;
import jp.ossc.tstruts.util.MyRequestUtil;


/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class DefaultJDBCInitializerTest extends FilterTestCase {

	/**
	 * Constructor for DefaultJDBCInitializerTest.
	 * @param arg0
	 */
	public DefaultJDBCInitializerTest(String arg0) {
		super(arg0);
	}

	/**
	 * w肵f[^\[X𐳂擾łĂ邩B
	 * @throws Exception
	 */
	public void testDataSource() throws Exception {
		RootModuleConfigImpl moduleConfig = MyRequestUtil.getRootModuleConfig(config.getServletContext());
		UserProfileConfig profileConfig = moduleConfig.getUserProfileConfig();
		DefaultJDBCInitializer initializer = (DefaultJDBCInitializer)profileConfig.getInitializer();
		DataSource ds = initializer.getDataSource();
		assertNotNull(ds);
	}

	public void beginAuth(WebRequest theRequest) throws Exception {
		initAuth(theRequest);
	}

	/**
	 * F؂sꂽAF؍ς݃[Uvt@C쐬Ă邩B
	 * @throws Exception
	 */
	public void testAuth() throws Exception {	
		DefaultInitializerTest.doFilter(config, request, response);
		assertEquals("user1", request.getUserPrincipal().getName());
		DynaUserProfile profile = (DynaUserProfile)request.getAttribute(MyGlobals.USER_PROFILE_KEY);
		assertNotNull(profile);
	}

	public void beginQuery(WebRequest theRequest) throws Exception {
		initAuth(theRequest);
	}
	
	/**
	 * DBʂzłȂf[^^єzf[^^ɐݒłĂ邩
	 * @throws Exception
	 */
	public void testQuery() throws Exception {
		DefaultInitializerTest.doFilter(config, request, response);
		DynaUserProfile profile = (DynaUserProfile)request.getAttribute(MyGlobals.USER_PROFILE_KEY);
		assertEquals("user1", profile.get("nickname"));
		assertEquals(new Integer(1), profile.get("userId"));
		assertEquals("user1", profile.get("array3", 0));
		assertEquals("1", profile.get("array3", 1));
	}
	
	public void beginDefault(WebRequest theRequest) throws Exception {
		initAuth(theRequest);
	}

	/**
	 * DB珉悤ݒ肳ĂȂtB[hftHglݒɂďĂ邩
	 * @throws Exception
	 */	
	public void testDefault() throws Exception {
		DefaultInitializerTest.doFilter(config, request, response);
		DynaUserProfile profile = (DynaUserProfile)request.getAttribute(MyGlobals.USER_PROFILE_KEY);
		String array1[] = (String[])profile.get("array1");
		assertEquals("a", array1[0]);
		assertEquals("b", array1[1]);
	}

	
	protected void initAuth(WebRequest theRequest) throws Exception {
		theRequest.setRedirectorName("FilterRedirectorSecure");
		theRequest.setAuthentication(
			new BasicAuthentication("user1", "user1"));
	}
}
