/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.util;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.beans.*;

import jp.ossc.tstruts.config.SystemConfig;
import jp.ossc.tstruts.action.ejb.ServiceNameReference;

/**
 * T[rX[eBeBB<p>
 *
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public class MyServiceUtil{
    
    private MyServiceUtil(){
    }
    
    /**
     * SystemConfigvOCŎw肳ꂽT[rX擾B<p>
     * struts-config.xml&lt;plug-in&gt;vfŃvOC{@link SystemConfig}&lt;set-property&gt;vfpropertyŎw肵lnameɎw肷鎖ŁAvalueɎw肵T[rX̃T[rX擾B<br>
     * SystemConfigCX^XAThreadLocalɐݒ肳ĂKv(SystemConfig.setLocalĂяõXbhŊɍsĂKv)B
     *
     * @param name struts-config.xml&lt;plug-in&gt;vfŃvOCSystemConfig&lt;set-property&gt;vfpropertyŎw肵l
     * @return T[rXIuWFNg
     * @see SystemConfig#getProperty(String)
     */
    public static Object getServiceObjectBySystemConfigProperty(String propertyName){
        final SystemConfig config = SystemConfig.getConfig();
        final String serviceNameString = config.getProperty(propertyName);
        if(serviceNameString == null){
            return null;
        }
        return getServiceObject(serviceNameString);
    }

    /**
     * "<i>GroupName</i>#<i>ServiceName</i>"Ƃ\̃T[rXŃT[rX擾B
     * @param name T[rX̕\
     * @return T[rXIuWFNg
     */    
    public static Object getServiceObject(String name) {
		final ServiceName serviceName = createServiceName(name);
        return getServiceObject(serviceName);
    }

    /**
     * w肵T[rXQƖŁAServiceNameReferenceT[rXT[rX擾B<p>
     * ̃\bȟĂяõT[rX`ꂽ}l[WServiceNameReferenceT[rXɁAw肳ꂽT[rXQƖnăT[rXĂ܂B<br>
     * ServiceNameReferenceT[rXȂꍇ́AnullԂB
     * 
     * @param service ̃\bȟĂяõT[rX
     * @param name T[rXQƖ
     * @return T[rXIuWFNg
     */    
    public static Object getServiceObjectByServiceNameRef(
        Service service,
        String name
    ){
        final ServiceNameReference ref
             = (ServiceNameReference)getServiceObject(
                service != null ? service.getServiceManagerName() : null,
                ServiceNameReference.SERVICE_NAME
             );
        if(ref == null){
            return null;
        }
        return getServiceObject(ref.getServiceName(name));
    }

    /**
     * T[oTCh̃T[rX擾B<p>
     * {@link jp.ossc.tstruts.action.ejb.facade.BusinessGroup}ŃO[sOꂽ{@link jp.ossc.tstruts.action.ejb.business.Business}̃T[rX`t@Cɒ`{@link ServiceNameReference}T[rX&lt;attribute&gt;vfnameŎw肵lnameɎw肷鎖ŁA&lt;attribute&gt;vf̓eɎw肵T[rX̃T[rX擾B<br>
     *
     * @param name {@link ServiceNameReference}T[rX&lt;attribute&gt;vfnameŎw肵l
     * @return T[rXIuWFNg
     * @see ServiceNameReference#getServiceName(String)
     */
    public static Object getServiceObject(
        ServiceManager manager,
        String refName
    ){
        final ServiceNameReference referer = (ServiceNameReference)manager
            .getServiceObject(ServiceNameReference.SERVICE_NAME);
        final ServiceName serviceName = referer.getServiceName(refName);
        return getServiceObject(serviceName);
    }
    
    /**
     * w肵}l[Wɓo^ꂽT[rX擾B<p>
     *
     * @param managerName }l[W
     * @param serviceName T[rX
     * @return T[rXIuWFNg
     * @see ServiceManagerFactory#getServiceObject(String, String)
     */
    public static Object getServiceObject(
        String managerName,
        String serviceName
    ){
        Object service = null;
        try{
           service = ServiceManagerFactory
                .getServiceObject(managerName, serviceName);
        }catch(ServiceNotFoundException e){
            return null;
        }
        return service;
    }
    
    
    /**
     * w肵T[rX̃T[rX擾B<p>
     *
     * @param serviceName ServieceNameIuWFNg
     * @return T[rXIuWFNg
     * @see ServiceManagerFactory#getServiceObject(ServiceName)
     */
    public static Object getServiceObject(ServiceName serviceName){
        Object service = null;
        try{
           service = ServiceManagerFactory.getServiceObject(serviceName);
        }catch(ServiceNotFoundException e){
            return null;
        }
        return service;
    }

	/**
	 * u}l[W + "#" + T[rXvƂ\ServiceNameIuWFNg쐬B
	 * @param name T[rX
	 * @return ServiceNameIuWFNg
	 */
	public static ServiceName createServiceName(String name) {
		ServiceNameEditor editor = new ServiceNameEditor();
		editor.setAsText(name);
		final ServiceName serviceName
			 = (ServiceName)editor.getValue();
		return serviceName;
	}
    
}