/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.taglib.html;

import java.lang.reflect.Array;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.action.ExtendActionMapping;
import jp.ossc.tstruts.action.transaction.TransactionCreateToken;
import jp.ossc.tstruts.config.ExtendFormBeanConfig;
import jp.ossc.tstruts.config.ExtendFormPropertyConfig;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.taglib.html.Constants;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.ResponseUtils;

/**
 * gFormTagB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class ExtendFormTag extends org.apache.struts.taglib.html.FormTag {
	protected static final Log log = LogFactory.getLog(ExtendFormTag.class);

	private String mappingName = null;
	private String bundle = null;
	private String formatKey = null;
	/**
	 * The key to search default format string for 
	 * java.sql.Timestamp in resources.
	 */
	public static final String SQL_TIMESTAMP_FORMAT_KEY =
		"org.apache.struts.taglib.bean.format.sql.timestamp";

	/**
	 * The key to search default format string for 
	 * java.sql.Date in resources.
	 */
	public static final String SQL_DATE_FORMAT_KEY =
		"org.apache.struts.taglib.bean.format.sql.date";

	/**
	 * The key to search default format string for 
	 * java.sql.Time in resources.
	 */
	public static final String SQL_TIME_FORMAT_KEY =
		"org.apache.struts.taglib.bean.format.sql.time";

	/**
	 * The key to search default format string for 
	 * java.util.Date in resources.
	 */
	public static final String DATE_FORMAT_KEY =
		"org.apache.struts.taglib.bean.format.date";

	/**
	 * The key to search default format string for int
	 * (byte, short, etc.) in resources.
	 */
	public static final String INT_FORMAT_KEY =
		"org.apache.struts.taglib.bean.format.int";

	/**
	 * The key to search default format string for float
	 * (double, BigDecimal) in resources.
	 */
	public static final String FLOAT_FORMAT_KEY =
		"org.apache.struts.taglib.bean.format.float";
	
	/**
	 * dM}~p̃vpeB
	 */
	protected boolean transacted = false;

	/**
	 * Struts<html:form>^OI[oChB
	 * transferڂŎw肳Ă鍀ڂ́AhiddenŖߍށB
	 *
	 * @exception JspException if a JSP exception has occurred
	 */
	public int doStartTag() throws JspException {

		// Look up the form bean name, scope, and type if necessary
		lookup();

		// Create an appropriate "form" element based on our parameters
		StringBuffer results = new StringBuffer();

		renderFormStartElement(results);

		renderToken(results);

		renderTransfer(results);

		// Print this field to our output writer
		ResponseUtils.write(pageContext, results.toString());

		// Store this tag itself as a page attribute
		pageContext.setAttribute(
			Constants.FORM_KEY,
			this,
			PageContext.REQUEST_SCOPE);

		initFormBean();

		// Continue processing this page
		return (EVAL_BODY_INCLUDE);

	}

	protected void lookup() throws JspException {

		// Look up the module configuration information we need
		String value = action;
		String prefix = null;

		String lookupAction;
		log.debug("action: " + action);
		int slash = action.indexOf('/');
		if (slash == -1) {
			moduleConfig = RequestUtils.getModuleConfig(pageContext);
			lookupAction = action;
		} else {
			ServletContext servletContext = pageContext.getServletContext();
			String moduleName = RequestUtils.getModuleName(
				action,
				servletContext);
			moduleConfig = (ModuleConfig)servletContext.getAttribute(Globals.MODULE_KEY + moduleName);
			lookupAction = action.substring(moduleName.length());
		}

		if (moduleConfig == null) {
			JspException e =
				new JspException(messages.getMessage("formTag.collections"));
			pageContext.setAttribute(
				Globals.EXCEPTION_KEY,
				e,
				PageContext.REQUEST_SCOPE);
			throw e;
		}

		if (log.isDebugEnabled()) {
			log.debug("ModuleName: " + moduleConfig.getPrefix());
			log.debug("ModuleConfig: " + moduleConfig);
			log.debug("LookupAction: " + lookupAction);
		}

		servlet =
			(ActionServlet) pageContext.getServletContext().getAttribute(
				Globals.ACTION_SERVLET_KEY);

		mappingName = RequestUtils.getActionMappingName(lookupAction);

		mapping = (ActionMapping) moduleConfig.findActionConfig(mappingName);
		if (mapping == null) {
			JspException e =
				new JspException(
					messages.getMessage("formTag.mapping", mappingName));
			pageContext.setAttribute(
				Globals.EXCEPTION_KEY,
				e,
				PageContext.REQUEST_SCOPE);
			throw e;
		}

		// Were the required values already specified?
		if (name != null) {
			if (type == null) {
				JspException e =
					new JspException(messages.getMessage("formTag.nameType"));
				pageContext.setAttribute(
					Globals.EXCEPTION_KEY,
					e,
					PageContext.REQUEST_SCOPE);
				throw e;
			}
			beanName = name;
			beanScope = (scope == null ? "session" : scope);
			beanType = type;
			return;
		}

		// Look up the form bean definition
		FormBeanConfig formBeanConfig =
			moduleConfig.findFormBeanConfig(mapping.getName());
		if (formBeanConfig == null) {
			JspException e =
				new JspException(
					messages.getMessage("formTag.formBean", mapping.getName()));
			pageContext.setAttribute(
				Globals.EXCEPTION_KEY,
				e,
				PageContext.REQUEST_SCOPE);
			throw e;
		}

		// Calculate the required values
		beanName = mapping.getAttribute();
		beanScope = mapping.getScope();
		beanType = formBeanConfig.getType();
	}

	/**
	 * 
	 * @param results
	 */
	protected void renderFormStartElement(StringBuffer results) {
		HttpServletResponse response =
			(HttpServletResponse) pageContext.getResponse();
		results.append("<form");
		results.append(" name=\"");
		results.append(beanName);
		results.append("\"");
		results.append(" method=\"");
		results.append(method == null ? "post" : method);
		results.append("\" action=\"");
		results.append(
			response.encodeURL(
				getActionMappingURL(pageContext)));

		results.append("\"");
		if (styleClass != null) {
			results.append(" class=\"");
			results.append(styleClass);
			results.append("\"");
		}
		if (enctype != null) {
			results.append(" enctype=\"");
			results.append(enctype);
			results.append("\"");
		}
		if (onreset != null) {
			results.append(" onreset=\"");
			results.append(onreset);
			results.append("\"");
		}
		if (onsubmit != null) {
			results.append(" onsubmit=\"");
			results.append(onsubmit);
			results.append("\"");
		}
		if (style != null) {
			results.append(" style=\"");
			results.append(style);
			results.append("\"");
		}
		if (styleId != null) {
			results.append(" id=\"");
			results.append(styleId);
			results.append("\"");
		}
		if (target != null) {
			results.append(" target=\"");
			results.append(target);
			results.append("\"");
		}
		results.append(">");
	}
	
	protected void renderTransfer(StringBuffer results)
	throws JspException {
		ExtendFormBeanConfig config = (ExtendFormBeanConfig)
			moduleConfig.findFormBeanConfig(beanName);
		Object bean = null;
		ActionMapping executed = (ActionMapping)pageContext.getRequest().getAttribute(
			Globals.MAPPING_KEY);
		if (executed != null && executed.getAttribute() != null) {
			String attribute = executed.getAttribute();
			bean = pageContext.findAttribute(attribute);
		}

		if (config != null && bean != null) {
			ExtendFormPropertyConfig props[] =
				(ExtendFormPropertyConfig[])config.findFormPropertyConfigs();

			for (int i = 0; i < props.length; i++) {
				if (props[i].getTransfer()) {
					
					try {
						// Look up the requested property value
						Object value = PropertyUtils.getProperty(bean, props[i].getName());
						Class clazz = null;
						if (value != null) {
							clazz = value.getClass();
						}
						if (clazz != null && clazz.isArray()) {
							for (int ii = 0; ii < Array.getLength(value); ii++) {
								// vpeBz񂾂Ƃ̏
								results.append("<input type=\"hidden\" name=\"");
								results.append(props[i].getName());
								results.append("\" value=\"");
						
								if (value != null){
									results.append(ResponseUtils.filter(Array.get(value, ii).toString()));
								}
						
								if (this.isXhtml()) {
									results.append("\" />");
								} else {
									results.append("\">");
								}
							}
						} else {
							results.append("<input type=\"hidden\" name=\"");
							results.append(props[i].getName());
							results.append("\" value=\"");
						
							if (value != null){
								results.append(ResponseUtils.filter(value.toString()));
							}
						
							if (this.isXhtml()) {
								results.append("\" />");
							} else {
								results.append("\">");
							}
						}

					} catch (Exception e) {
						throw new JspException(e);
					}

				}
			}
		}
	}

	protected void renderToken(StringBuffer results) {
		// Add a transaction token (if present in our session)
		HttpSession session = pageContext.getSession();
		if (session == null) {
			return;
		}

		// TODO XTransaction Token@\͐ĂH
		String token =
			(String) session.getAttribute(Globals.TRANSACTION_TOKEN_KEY);
		if (token != null) {
			results.append("<input type=\"hidden\" name=\"");
			results.append(Constants.TOKEN_KEY);
			results.append("\" value=\"");
			results.append(token);
			if (this.isXhtml()) {
				results.append("\" />");
			} else {
				results.append("\">");
			}
		}

		//TransactedTokenL[̓WJ
		ExtendActionMapping exMapping = (ExtendActionMapping)mapping;
		if(exMapping.getTransacted()){
	
			HttpServletRequest request = (HttpServletRequest) pageContext.getRequest();
			TransactionCreateToken tToken= new TransactionCreateToken();
			String transactedMax = (String) request.getAttribute(MyGlobals.TRANSACTED_MAX_KEY);
			int t = 0;
			if (transactedMax != null) {
				t = Integer.parseInt(transactedMax);
			}
			tToken.createTransactionId(request);
	
			String ttoken =
				(String) request.getAttribute(MyGlobals.TRANSACTION_TOKEN_KEY);
			if (ttoken != null) {
				results.append("<input type=\"hidden\" name=\"");
				results.append(MyGlobals.TRANSACTION_TOKEN_KEY);
				results.append("\" value=\"");
				results.append(ttoken);
				if (this.isXhtml()) {
					results.append("\" />");
				} else {
					results.append("\">");
				}
			}
		}			
	}

	/**
	 * RequestUtils̃\bhpB
	 * prefix̏ύXB
	 * Return the form action converted into a server-relative URL.
	 */
	public String getActionMappingURL(PageContext pageContext) {

		HttpServletRequest request = (HttpServletRequest) pageContext.getRequest();
		StringBuffer value = new StringBuffer(request.getContextPath());
		value.append(moduleConfig.getPrefix());

		// Use our servlet mapping, if one is specified
		String servletMapping =
			(String) pageContext.getAttribute(Globals.SERVLET_KEY, PageContext.APPLICATION_SCOPE);
		if (servletMapping != null) {
			String queryString = null;
			int question = action.indexOf("?");
			if (question >= 0) {
				queryString = action.substring(question);
			}
			if (servletMapping.startsWith("*.")) {
				value.append(mappingName);
				value.append(servletMapping.substring(1));
			} else if (servletMapping.endsWith("/*")) {
				value.append(servletMapping.substring(0, servletMapping.length() - 2));
				value.append(mappingName);
			} else if (servletMapping.equals("/")) {
				value.append(mappingName);
			}
			if (queryString != null) {
				value.append(queryString);
			}
		}

		// Otherwise, assume extension mapping is in use and extension is
		// already included in the action property
		else {
			value.append(mappingName);
		}

		// Return the completed value
		return (value.toString());
	 }

	/**
	 * Returns true if this tag should render as xhtml.
	 */
	private boolean isXhtml() {
		String xhtml =
			(String) this.pageContext.getAttribute(
				Globals.XHTML_KEY,
				PageContext.PAGE_SCOPE);

		return ("true".equalsIgnoreCase(xhtml));
	}

}
