/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * Tile`<putList>^OێNXB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class TilePutListConfig extends TilePutConfigBase {
	
	protected List tileList = new ArrayList();
	protected Map tileMap = new HashMap();
	
	/** Xgȉ̑Svf̃Xg */
	protected List allTileList = new ArrayList();
	/** Xgȉ̑Svf̃}bv */
	protected Map allTileMap = new HashMap();

	public void addPutConfig(TilePutConfigBase config) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		if (config == null) {
			return;
		}
		config.setParent(this);
		tileList.add(config);
		if (config.getName() != null) {
			tileMap.put(config.getName(), config);
		}
	}

	public List getList() {
		return tileList;
	}

	public Map getMap() {
		return this.tileMap;
	}

	public TilePutConfigBase get(int i) {
		return (TilePutConfigBase) tileList.get(i);
	}

	public TilePutConfigBase get(String name) {
		return (TilePutConfigBase) tileMap.get(name);
	}

	public Iterator iterator() {
		return tileList.iterator();
	}

	public int size() {
		return tileList.size();
	}

	/**
	 * ̃^C`ʂȃ^C`extendsꍇɁA
	 * extendx[XɂListMap쐬ȂB
	 * @param src
	 */
	public void extend(TilePutListConfig src) {
		List list = new ArrayList(src.tileList);
		Map map = new HashMap(src.tileMap);

		for (Iterator iter = tileList.iterator(); iter.hasNext();) {
			TilePutConfigBase item = (TilePutConfigBase) iter.next();
			if (item.getName() != null) {
				// O^C̏ꍇ͏㏑
				TilePutConfigBase original =
					(TilePutConfigBase) map.get(item.getName());
				map.put(item.getName(), item);
				if (original != null) {
					if (original instanceof TilePutListConfig &&
						item instanceof TilePutListConfig) {
						// putList̏ꍇ͒gextend
						((TilePutListConfig)item).extend((TilePutListConfig)original);
					}
					int index = list.indexOf(original);
					list.set(index, item);
				} else {
					list.add(item);
				}
			} else {
				// OȂ^C̏ꍇ͕t
				list.add(item);
			}
		}
		tileList = list;
		tileMap = map;
	}

	/* ( Javadoc)
	 * @see jp.ossc.tstruts.config.TilePutConfigBase#doRequest(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.ServletContext)
	 */
	protected String doRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException, IOException {
		// ێĂ郊Xg̎qIuWFNg̏ʍ쐬
		// Xg^Og̏o͂͂Ȃ
		return null;
	}

	/* ( Javadoc)
	 * @see jp.ossc.tstruts.config.TilePutConfigBase#init()
	 */
	public void init() {
		super.init() ;
		// ێĂ郊Xg̎qIuWFNg̏
		for (Iterator iter = tileList.iterator(); iter.hasNext();) {
			TilePutConfigBase tile = (TilePutConfigBase)iter.next();
			tile.init();
		}	
	}

	public void traverse(Map parentMap) {
		if (parentMap == null) {
			allTileMap.putAll(this.tileMap);
		}
		else {
			for (Iterator iter = this.tileMap.keySet().iterator(); iter.hasNext(); ) {
				String key = (String)iter.next();
				if (!parentMap.containsKey(key)) {
					allTileMap.put(key, this.tileMap.get(key));
				}
			}
		}
		// Xg̑Svf𑖍
		for (Iterator iter = this.iterator(); iter.hasNext();) {
			TilePutConfigBase put = (TilePutConfigBase)iter.next();
			allTileList.add(put);
			// qvfXg̏ꍇA̎qvfXgǉ
			if (put instanceof TilePutListConfig) {
				TilePutListConfig putList = (TilePutListConfig)put;
				putList.traverse(allTileMap);
				for (Iterator listIter = putList.allIterator(); listIter.hasNext();) {
					TilePutConfigBase childput = (TilePutConfigBase)listIter.next();
					allTileList.add(childput);
				}
				
				// ̎qvf}bvǉ
				allTileMap.putAll(putList.allTileMap);
			}
		}
	}

	/**
	 * XgȉSvf̃Xg̃Ce[^Ԃ
	 * @return XgȉSvf̃Xg̃Ce[^
	 */
	public Iterator allIterator() {
		return allTileList.iterator();
	}
}
