/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.xml.sax.Attributes;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class TilePutConfigFactory extends AbstractObjectCreationFactory {

	/* ( Javadoc)
	 * @see org.apache.commons.digester.ObjectCreationFactory#createObject(org.xml.sax.Attributes)
	 */
	public Object createObject(Attributes attributes) throws Exception {
		TilePutConfigBase object = null;
		
		String type = attributes.getValue("type");
		
		if(type == null) {
			throw new IllegalArgumentException("type attribute must be specified.");
		}
		

		if (type.equals("resource")) {
			return createTilePutResourceConfigObject(attributes);
		}
		
		if (type.equals("action")) {
			return createTilePutActionConfigObject(attributes);
		}

		if (type.equals("path")) {
			return createTilePutPathConfigObject(attributes);
		}
		
		if (type.equals("value")) {
			return createTilePutValueConfigObject(attributes);
		}
		
		if (type.equals("file")) {
			return new TilePutFileConfig();
		}
		
		if (type.equals("http")) {
			return new TilePutHttpConfig();
		}

		return object;
	}

	/**
	 * @param attributes
	 * @return
	 */
	private Object createTilePutValueConfigObject(Attributes attributes) throws Exception{
		TilePutValueConfig config = 
			(TilePutValueConfig) Class.forName("jp.ossc.tstruts.config.TilePutValueConfig").newInstance();	

		return config;
	}

	/**
	 * @param attributes
	 * @return
	 */
	private Object createTilePutResourceConfigObject(Attributes attributes) throws Exception{
		TilePutResourceConfig config = 
			(TilePutResourceConfig) Class.forName("jp.ossc.tstruts.config.TilePutResourceConfig").newInstance();	

		return config;
	}

	/**
	 * @param attributes
	 * @return
	 */
	private Object createTilePutActionConfigObject(Attributes attributes) throws Exception{
		TilePutActionConfig config = 
			(TilePutActionConfig) Class.forName("jp.ossc.tstruts.config.TilePutActionConfig").newInstance();	

		return config;
	}

	/**
	 * @param attributes
	 * @return
	 */
	private Object createTilePutPathConfigObject(Attributes attributes) throws Exception{
		TilePutPathConfig config = 
			(TilePutPathConfig) Class.forName("jp.ossc.tstruts.config.TilePutPathConfig").newInstance();	

		return config;
	}
}
