/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

import java.util.*;

import jp.ossc.nimbus.util.*;

/**
 * TileݒێNXB
 * Tileݒ͂̕܊֌WɂAeqƑc[ƂȂB
 * eqւ̎QƂ̂TilePutListConfig(т̔hNXłTileDefinitionConfig)݂̂ŁA
 * qeւ̎QƂ͂̃NXparentoێB
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public abstract class TilePutConfigBase {
	private static final String C_SEPT_DEPENDS = ",";
	protected String value;
	protected String name;
	protected TilePropertyConfig[] properties = new TilePropertyConfig[0];
	protected TilePutConfigBase parent = null;
	protected boolean configured = false;
	/** PUT̈ˑPUT̑ */
	protected List depends;
	/** s䎞ɁA^Ȍʂۑ */
	protected ThreadLocal _prefetchResponse = new ThreadLocal();

	public void addPropertyConfig(TilePropertyConfig param) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		TilePropertyConfig[] newParams = new TilePropertyConfig[properties.length + 1];
		System.arraycopy(properties, 0, newParams, 0, properties.length);
		newParams[properties.length] = param;
		properties = newParams;
	}
	
	public TilePropertyConfig[] getPropertyConfigs() {
		return properties;
	}

	public TilePropertyConfig findPropertyConfig(String name) {
		for (int i = 0; i < properties.length; ++i) {
			if (properties[i].getName().equals(name)) {
				return properties[i];
			}
		}
		return null;
	}

	public TilePutConfigBase getParent() {
		return parent;
	}

	public void setParent(TilePutConfigBase parent) {
		this.parent = parent;
	}

	public void freeze() {
		configured = true;
		for (int i = 0; i < properties.length; ++i) {
			properties[i].freeze();
		}
	}

	/**
	 * @return
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param string
	 */
	public void setValue(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		value = string;
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		name = string;
	}
	
	/**
	 * sOɌĂ΂Ainsert^Ȍʂ
	 */
	public void init() {
		this._prefetchResponse.set(null);
	}

	/**
	 * s䎞ɌĂ΂Ainsert^Ȍʂۑ
	 * @param request
	 * @param response
	 * @param servletContext
	 */
	public void makeResponse(HttpServletRequest request,
										HttpServletResponse response, 
										ServletContext servletContext) throws ServletException, IOException {
		String ret = doRequest(request,response,servletContext);
		this._prefetchResponse.set(ret);
	}

	/**
	 * eTilePutɈقȂ郌X|Xo͏LqAuXgNg\bh
	 * @param request
	 * @param response
	 * @param servletContext
	 * @return X|X
	 * @throws ServletException
	 * @throws IOException
	 */
	abstract protected String doRequest(HttpServletRequest request, 
										HttpServletResponse response, 
										ServletContext servletContext) throws ServletException, IOException;

	/**
	 * sɌĂ΂Ainsert^Ȍʂۑ
	 * @return ^Oʕ
	 */
	public String getResponseString() {
		return (String)this._prefetchResponse.get();
	}

	/* ( Javadoc)
	 * insert^OsAʂԂ
	 * ۂɂ́As䒆ɓʂԂB
	 * TileProcessorƂĂ̎
	 * @see jp.ossc.tstruts.tiles.TileProcessor#createContent(jp.ossc.tstruts.config.TilePutConfigBase, javax.servlet.jsp.PageContext)
	 */
	public String createContent(PageContext pageContext) throws JspException, ServletException, IOException {
		return this.getResponseString();
	}
	
	/**
	 * fByhݒ肷
	 * @param fByhl
	 */
	public void setDepends(String argDepends) {
		CsvArrayList tmpList = new CsvArrayList();
		if(argDepends == null || argDepends.length() == 0){
			return;
		}
		tmpList.split(argDepends, C_SEPT_DEPENDS) ;
		this.depends = tmpList;
	}

	/**
	 * depandPUT̃Xgo͂B
	 * @return depandPUT̃Xg
	 */
	public List getDependsList() {
		return this.depends;
	}
	
	public String toString() {
		return this.getName();
	}

	/**
	 * @param tmpDependList
	 */
	public void setDependsList(List argDependsList) {
		this.depends = argDependsList;
	}
}
