/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.Serializable;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

import org.apache.commons.beanutils.BeanUtils;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class TilePropertyConfig implements Serializable {

	private String name;
	private String value;
	private String parameter;
	private String beanName;
	private String property;
	private String scope;
	private boolean configured = false;
	
	public String getName() {
		return name;
	}

	public void setName(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		name = string;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		value = string;
	}
	
	public String getBeanName() {
		return beanName;
	}

	public void setBeanName(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		beanName = string;
	}

	public String getParameter() {
		return parameter;
	}

	public void setParameter(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		parameter = string;
	}

	public String getProperty() {
		return property;
	}

	public void setProperty(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		property = string;
	}

	public void freeze() {
		configured = true;
	}

	public String getScope() {
		return scope;
	}

	public void setScope(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		scope = string;
	}
	
	public Object eval(PageContext context) {
		HttpServletRequest request = (HttpServletRequest)context.getRequest();

		if (parameter != null) {
			return request.getParameter(parameter);
		}

		if (value != null) {
			return value;
		}

		if (beanName != null) {
			Object bean = context.findAttribute(beanName);
			if (property == null) {
				return bean;
			}
			try {
				return BeanUtils.getProperty(bean, property);
			} catch (Exception e) {
				e.printStackTrace();
				// TODO: G[O
			}
		}

		return null;
	}

	/**
	 * @param servletContext
	 * @param request
	 * @return
	 */
	public Object eval(ServletContext servletContext, HttpServletRequest request) {
		if (parameter != null) {
			return request.getParameter(parameter);
		}

		if (value != null) {
			return value;
		}

		if (beanName != null) {
			Object bean = null;

			bean = request.getAttribute(beanName);
			
			if (bean == null) {
				HttpSession session = request.getSession(false);
				bean = session.getAttribute(beanName);
			}
			
			if (bean == null) {
				bean = servletContext.getAttribute(beanName);
			}

			if (property == null) {
				return bean;
			}
			try {
				return BeanUtils.getProperty(bean, property);
			} catch (Exception e) {
				e.printStackTrace();
				// TODO: G[O
			}
		}
		
		return null;
	}
}
