/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.Serializable;

import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.struts.action.ActionForward;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class TStrutsActionForward extends ActionForward implements Serializable {
	protected String test = null;
	protected transient Expression testExpr = null;

	public TStrutsActionForward() {
	}
	
	public TStrutsActionForward(String path) {
		super(path);
	}

	/* (non-Javadoc)
	 * @see org.apache.struts.config.ForwardConfig#getContextRelative()
	 */
	public boolean getContextRelative() {
		if (path == null)
			return false;
		return path.startsWith("/");
	}

	/* (non-Javadoc)
	 * @see org.apache.struts.config.ForwardConfig#setContextRelative(boolean)
	 */
	public void setContextRelative(boolean arg0) {
		// neglect this
	}

	/**
	 * &lt;forward&gt;I邽߂̎(Jexl̕])擾
	 * @return
	 */
	public String getTest() {
		return test;
	}

	/**
	 * &lt;forward&gt;I邽߂̎(Jexl̕])ݒ肷
	 * @param string
	 */
	public void setTest(String string) throws Exception {
		test = string;
		testExpr = ExpressionFactory.createExpression(string);
	}

	/**
	 * &lt;forward&gt;I邽߂ExpressionIuWFNg擾
	 * @return
	 */
	public Expression getTestExpr() throws Exception {
		if (testExpr != null) {
			return testExpr;
		}
		if (test == null) {
			return null;
		}
		testExpr = ExpressionFactory.createExpression(test);
		return testExpr;
	}
}
