/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.util.*;
import javax.servlet.*;

import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.*;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;

import jp.ossc.nimbus.beans.StringArrayEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.common.InvocationContext;
import jp.ossc.tstruts.util.MyServiceUtil;

/**
 * VXe\B<p>
 * TStrutst[[Ngpč쐬AvP[VPʂŁAt[[NKvƂVXe\i[NXłB<br>
 * ̃NX́AStruts̃vOCƂĎĂ邽߁Astruts-config.xmlɒ`ĎgpB<br>
 * <pre>
 *   &lt;plug-in className="jp.ossc.tstruts.config.SystemConfig"&gt;
 *     &lt;set-property property="ServicePaths" value="tstruts-client-service.xml,tstruts-client-service2.xml"/&gt;
 *     &lt;set-property property="InvocationContextClassName" value="sample.MyInvocationContext"/&gt;
 *     &lt;set-property property="BusinessGroupFactory" value="tstruts-client#BusinessGroupFactory"/&gt;
 *     &lt;set-property property="RequestIDSequence" value="tstruts-client#RequestIDSequence"/&gt;
 *     &lt;set-property property="TilesCacheManager" value="tstruts-client#TilesCacheManager"/&gt;
 *   &lt;/plug-in&gt;
 * </pre>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public class SystemConfig implements PlugIn, Map {
    
    /**
     * ftHgInvocationContextC^tF[XNXB<p>
     */
    protected static final String DEFAULT_INVOCATION_CONTEXT_CLASS_NAME
         = jp.ossc.tstruts.common.InvocationContextImpl.class.getName();
    
    /**
     * InvocationContextC^tF[XNX̑B<p>
     */
    protected static final String INVOCATION_CONTEXT_CLASS_NAME
         = "InvocationContextClassName";
    
    /**
     * TStrutst[[ÑNCAgTChŎgpNimbusT[rX̃T[rX`t@C̃pXB<p>
     * pX́AJ}؂ŕw肷鎖\łBw\ȃpX̋Lq@ɂẮA{@link ServiceManagerFactory#loadManager(String)}QƁB<br>
     * ̃\bhŃpXw肳ꂽꍇ́ÃvOC̏{@link #init(ActionServlet, ModuleConfig)}ŁAT[rXՂ̋NsB<br>
     */
    protected static final String SERVICE_PATHS = "ServicePaths";
    
    private static final ThreadLocal localConfig = new InheritableThreadLocal();
    
    private final FastHashMap attributeMap = new FastHashMap();
    
    private Class invocationContextClass = null;
    
    private PlugInConfig config = null;

    protected static final Log log = LogFactory.getLog(SystemConfig.class);

	public void setCurrentPlugInConfigObject(PlugInConfig config) {
		this.config = config;
		attributeMap.putAll(config.getProperties());
	}

    /**
     * vOCƂĂ̏sB<p>
     * ł́Aȉ̏sB
     * <ol>
     *   <li>servicePathsɐݒ肳ꂽpX̃T[rX`t@C[hāANimbusT[rXՂNB</li>
     *   <li>{@link #INVOCATION_CONTEXT_CLASS_NAME}Ŏw肳ꂽ{@link InvocationContext}C^tF[XNX[hĐB</li>
     *   <li>ServletContextɑ{@link MyGlobals#INVOCATION_CONTEXT_KEY}ŁAInvocationContextݒ肷B</li>
     *   <li>EnvironmentValiableHolderɎw肳ꂽˑ萔ێT[rXServletContextMyGlobals.ENVIRONMENT_VARIABLE_KEYƂOsetAttributeB</li>
     * </ol>
     *
     * @param servlet ActionServlet
     * @param config ModuleConfig
     * @exception ServletException Ɏsꍇ
     */
    public void init(ActionServlet servlet, ModuleConfig config)
     throws ServletException{
        attributeMap.setFast(true);
        
        setCurrentPlugInConfigObject(this.config);

        final String[] servicePaths = getServicePaths();
        
        if(servicePaths != null && servicePaths.length != 0){
            for(int i = 0; i < servicePaths.length; i++){
                ServiceManagerFactory.loadManager(servicePaths[i]);
            }
        }
        
        try{
            String invocationContextClassName
                 = getProperty(INVOCATION_CONTEXT_CLASS_NAME);
            if(invocationContextClassName == null){
                invocationContextClassName
                     = DEFAULT_INVOCATION_CONTEXT_CLASS_NAME;
            }
            invocationContextClass = Class.forName(invocationContextClassName);
        }catch(ClassNotFoundException e){
            throw new ServletException(e);
        }
        
        final ServletContext servletContext
             = servlet.getServletConfig().getServletContext();
        servletContext.setAttribute(MyGlobals.SYSTEM_CONFIG_KEY, this);

		String contextServiceName = getProperty(
			MyGlobals.ENVIRONMENT_VARIABLE_HOLDER_PROPERTY);
		if (contextServiceName != null) {        
			Context contextService =
				(Context)MyServiceUtil.getServiceObject(contextServiceName);
			servletContext.setAttribute(MyGlobals.ENVIRONMENT_VARIABLE_KEY,
				contextService);
		}
    }
    
    /**
     * vOCƂĂ̔jsB<p>
     * ł́AservicePathsɐݒ肳ꂽpX̃T[rX`t@CA[hāANimbusT[rXՂ~B<br>
     */
    public void destroy(){
        final String[] servicePaths = getServicePaths();
        
        if(servicePaths != null && servicePaths.length != 0){
            for(int i = 0; i < servicePaths.length; i++){
                ServiceManagerFactory.unloadManager(servicePaths[i]);
            }
        }
    }
    
    private String[] getServicePaths(){
       final String servicePathString = getProperty(SERVICE_PATHS);
        if(servicePathString == null){
            return null;
        }
        final StringArrayEditor editor = new StringArrayEditor();
        editor.setAsText(servicePathString);
        return (String[])editor.getValue();
    }
    
    /**
     * ̃IuWFNg̑擾B<p>
     *
     * @param name 
     * @return 
     */
    public String getProperty(String name){
        return (String)get(name);
    }

	/**
	 * lNimbusT[rX̏ꍇɁAServiceNameIuWFNg𐶐ĕԂ[eBeB\bhB
	 * @param name 
	 * @return lServiceNameIuWFNgɕΐB
	 * lȂꍇ(null̏ꍇ)󕶎A󔒕̏ꍇnullԂB
	 */    
    public ServiceName getServiceNameProperty(String name) {
    	String serviceNameString = (String)get(name);
    	if (serviceNameString == null || serviceNameString.trim().length() == 0) {
    		return null;
    	}
    	ServiceName ret = MyServiceUtil.createServiceName(serviceNameString);
    	return ret;
    }

	/**
	 * w肳ꂽIuWFNg̑ݒ肷B<p>
	 *
	 * @param name IuWFNg
	 * @param attribute 
	 * @return w肳ꂽIuWFNgɊ֘AȑO̒lBnameɃ}bsOȂꍇnullB
	 */
    public String setProperty(String name, String attribute) {
    	return (String)put(name, attribute);
    }

    /**
     * Ɩsp[^i[{@link InvocationContext}𐶐B<p>
     * 
     * @return InvocationContext
     */
    public InvocationContext createInvocationContext()
    throws InstantiationException, IllegalAccessException {
        return (InvocationContext)invocationContextClass.newInstance();
    }
    
    /**
     * ̃NX̃CX^X{@link ThreadLocal}ɓo^B<p>
     * ̃CX^X̎́At[[NÓIɎQƂsB<br>
     * AUŎg鎖lƁAstaticȗ̈ɂ̃CX^XƁAꍇɂẮACX^XՓ˂NÃAvP[V琳ACX^XQƂłȂȂB<br>
     * ŁÃ\bhĂяoŁAXbhPʂɃIuWFNgǗThreadLocalIuWFNgɂ̃CX^Xo^āAstatic̈ł̃CX^X̏Փ˖B<br>
     */
    public void setLocal(){
        localConfig.set(this);
    }
    
    /**
     * CX^X擾B<p>
     * ̃\bhĂԎŁASystemConfigCX^XQƂXbhɁAO{@link #setLocal()}\bhĂяoĂKvB<br>setLocal()\bhĂяoĂȂꍇɂ́AnullԂB<br>
     * 
     * @return SystemConfigCX^X
     * @see #setLocal()
     */
    public static SystemConfig getConfig(){
        return (SystemConfig)localConfig.get();
    }
    
    /**
     * ̃IuWFNg̑̐擾B<p>
     *
     * @return ̐
     */
    public int size(){
        return attributeMap.size();
    }
    
    /**
     * ̃IuWFNg̑ݒ肳ĂȂ𒲂ׂB<p>
     *
     * @return Pݒ肳ĂȂꍇAtrue
     */
    public boolean isEmpty(){
        return attributeMap.isEmpty();
    }
    
    /**
     * w肳ꂽIuWFNg̑ÃIuWFNg̑ɐݒ肳Ă邩𒲂ׂB<p>
     *
     * @param name IuWFNg
     * @return ݒ肳ĂꍇAtrue
     */
    public boolean containsKey(Object name){
        return attributeMap.containsKey(name);
    }
    
    /**
     * w肳ꂽÃIuWFNg̑ɐݒ肳Ă邩𒲂ׂB<p>
     *
     * @param attribute 
     * @return ݒ肳ĂꍇAtrue
     */
    public boolean containsValue(Object attribute){
        return attributeMap.containsValue(attribute);
    }
    
    /**
     * w肳ꂽIuWFNg̑擾B<p>
     *
     * @param name IuWFNg
     * @return 
     */
    public Object get(Object name){
        return attributeMap.get(name);
    }
    
    /**
     * w肳ꂽIuWFNg̑ݒ肷B<p>
     *
     * @param name IuWFNg
     * @param attribute 
     * @return w肳ꂽIuWFNgɊ֘AȑO̒lBnameɃ}bsOȂꍇnullB
     */
    public Object put(Object name, Object attribute){
        return attributeMap.put(name, attribute);
    }
    
    /**
     * w肳ꂽIuWFNg̑폜B<p>
     *
     * @param name IuWFNg
     * @return 폜ꂽ
     */
    public Object remove(Object name){
        return attributeMap.remove(name);
    }
    
    /**
     * w肳ꂽ}bv̑SẴGgÃIuWFNg̑ƂĐݒ肷B<p>
     *
     * @param map }bv
     */
    public void putAll(Map map){
        attributeMap.putAll(map);
    }
    
    /**
     * ̃IuWFNg̑Sč폜B<p>
     */
    public void clear(){
        attributeMap.clear();
    }
    
    /**
     * ̃IuWFNg̑IuWFNg̏W擾B<p>
     *
     * @return IuWFNg̏W
     */
    public Set keySet(){
        return attributeMap.keySet();
    }
    
    /**
     * ̃IuWFNg̑̏W擾B<p>
     *
     * @return ̏W
     */
    public Collection values(){
        return attributeMap.values();
    }
    
    /**
     * ̃IuWFNg̑Gg̏W擾B<p>
     *
     * @return Gg
     */
    public Set entrySet(){
        return attributeMap.entrySet();
    }
}
