/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * JNDIInitializeݒNXB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class JDBCInitializerConfig {
	private static final Log log = LogFactory.getLog(JDBCInitializerConfig.class);

	private String dsJndiName = null;
	private String query = null;
	private JDBCInitializerMappingConfig mappings[] = new JDBCInitializerMappingConfig[0];
	private UserProfilePropertyConfig unmappedProperties[] = null; 
	private boolean configured = false;
	
	/**
	 * [Uvt@C񌟍pf[^\[XJNDIݒ
	 * @param jndiName JNDI :"java:comp/env/jdbc/UserProfileDataSource"
	 */
	public void setDsJndiName(String jndiName) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		dsJndiName = jndiName;
	}

	/**
	 * [Uvt@C񌟍pf[^\[XJNDI擾
	 * @return JNDI
	 */
	public String getDsJndiName() {
		return dsJndiName;
	}

	/**
	 * [Uvt@CpSQLݒ肷B
	 * SQLɂ̓[UID𖄂ߍނƂ"?"ƂLqB
	 * <p>
	 * :
	 * <pre>
	 *   SELECT * FROM user WHERE login_id = ?
	 * </pre>
	 * @param query SQL
	 */
	public void setQuery(String query) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		this.query = query;
	}

	/**
	 * [Uvt@CpSQL擾B
	 * @return SQL
	 */
	public String getQuery() {
		return query;
	}

	/**
	 * [Uvt@Cʂ[Uvt@CNXɐݒ肷邽߂[JƃtB[h]̃}bsOo^B
	 * @param mapping }bsOݒNX
	 */
	public void addMapping(JDBCInitializerMappingConfig mapping) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		JDBCInitializerMappingConfig newMappings[] =
			new JDBCInitializerMappingConfig[mappings.length + 1];
		System.arraycopy(mappings, 0, newMappings, 0, mappings.length);
		newMappings[mappings.length] = mapping;
		mappings = newMappings; 
	}
	
	/**
	 * [J-tB[h]}bsO擾
	 * @return }bsO̔z
	 */
	public JDBCInitializerMappingConfig[] getMappings() {
		return mappings;
	}
	
	/**
	 * }bsOɊ֘AtꂽPropertyConfigAΉMappingConfigɊi[A
	 * ֘AtĂȂPropertyConfigunmappedPropertiesɊi[B
	 * @param parent
	 */
	public void initialize(UserProfileConfig parent) {
		if (dsJndiName == null || dsJndiName.trim().equals("")) {
			String msg = "Empty 'dsJndiName' property on jdbc-initializer configuration.";
			log.fatal(msg);
		}
		
		if (query == null || query.trim().equals("")) {
			String msg = "Empty 'query' property on jdbc-initializer configuration.";
			log.fatal(msg);
		}

		List list = new LinkedList(Arrays.asList(parent.getProperties()));

		for (int i = 0; i < mappings.length; ++i) {
			String name = mappings[i].getProperty();
			int index = name.indexOf('[');
			if (index > -1)
				name = name.substring(0, index);
			UserProfilePropertyConfig property = parent.findProperty(name);
			if (property == null) {
				String msg = "Specified property[" + mappings[i].getProperty() +
					"] to initialize UserProfile is not found.";
				log.warn(msg);
				continue;
			}
			mappings[i].setAssociatedProperty(property);
			list.remove(property);
		}
		
		unmappedProperties = (UserProfilePropertyConfig[])
			list.toArray(new UserProfilePropertyConfig[list.size()]);
	}
	
	/**
	 * JDBC}bsOɊ֘AtĂȂ(܂ADBf[^ł͏Ȃ)tB[h
	 * PropertyConfig擾B
	 * @return
	 */
	public UserProfilePropertyConfig[] getUnmappedPropertyConfig() {
		return unmappedProperties;
	}
	
	public void freeze() {
		configured = true;
		for (int i = 0; i < mappings.length; ++i) {
			mappings[i].freeze();
		}
	}
}
