/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.util.HashMap;

import org.apache.struts.action.ActionFormBean;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.FormPropertyConfig;

/**
 * gFormBeanConfigB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */

public class ExtendFormBeanConfig extends ActionFormBean {

	// ----------------------------------------------------- Instance Variables

	/**
	 * FormImportConfigvfnbV}bvB
	 */
	protected HashMap formImports = new HashMap();

	// --------------------------------------------------------- Public Methods

	/**
	 * Add a new <code>FormPropertyConfig</code> instance to the set associated
	 * with this module.
	 *
	 * @param config The new configuration instance to be added
	 *
	 * @exception IllegalArgumentException if this property name has already
	 *  been defined
	 */
	public void addFormPropertyConfig(ExtendFormPropertyConfig config) {

		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		if (formProperties.containsKey(config.getName())) {
			throw new IllegalArgumentException(
				"Property " + config.getName() + " already defined");
		}
		formProperties.put(config.getName(), config);

	}

	/**
	 * ̃W[Ɋ֘AtꂽFormImportConfigǉB
	 * 
	 *
	 * @param config ǉFormImportConfig
	 *
	 * @exception IllegalArgumentException ɓFormImportConfig
	 * ݂ꍇB
	 */
	public void addFormImportConfig(FormImportConfig config) {

		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}

		if (formImports.containsKey(config.getName())) {
			throw new IllegalArgumentException(
				"Property " + config.getName() + " already defined");
		}
		formImports.put(config.getName(), config);

	}

	/**
	 * ֘AtꂽFormImportConfigname猩AԂBKvH
	 *
	 * @param name FormImportConfig̖O
	 */
	public FormImportConfig findFormImportConfig(String name) {

		return ((FormImportConfig) formImports.get(name));

	}

	/**
	 * ֘AtꂽFormImportConfigFormProperties𐶐B
	 */
	public void putFormImportConfigs() {

		if (formImports.isEmpty())
			return;

		String formImportNames[] = new String[formImports.size()];
		formImports.keySet().toArray(formImportNames);

		for (int i = 0; i < formImports.size(); i++) {

			FormBeanConfig conf =
				getModuleConfig().findFormBeanConfig(formImportNames[i]);

			if(conf == null){
				throw new IllegalArgumentException(
					"Import " + formImportNames[i] + " is not defined");
			}

			FormPropertyConfig p[] = conf.findFormPropertyConfigs();

			ExtendFormPropertyConfig prop[] = (ExtendFormPropertyConfig[]) p;
			FormImportConfig formImportConfig =
				(FormImportConfig) formImports.get(formImportNames[i]);
			boolean isTransfer = formImportConfig.getTransfer();
			boolean isEncrypt = formImportConfig.getEncrypt();

			for (int j = 0; j < prop.length; j++) {
				if (formProperties.containsKey(prop[j].getName())) {
					throw new IllegalArgumentException(
						"Property " + prop[j].getName() + " already defined");
				}

				// importFormPropertyConfig̑Rs[
				// TODO: yzƂ܂Rs[̂肩肻
				//        RXgN^H
				ExtendFormPropertyConfig copyProp =
					new ExtendFormPropertyConfig();
				copyProp.setName(prop[j].getName());
				copyProp.setType(prop[j].getType());
				copyProp.setSize(prop[j].getSize());
				copyProp.setInitial(prop[j].getInitial());
				copyProp.setTransfer(prop[j].getTransfer());
				copyProp.setEncrypt(prop[j].getEncrypt());

				// FormImportConfigtransfer, encrypttrueȂ
				// FormPropertyConfigɔf
				if (isTransfer == true) {
					copyProp.setTransfer(isTransfer);
				}
				if (isEncrypt == true) {
					copyProp.setEncrypt(isEncrypt);
				}

				formProperties.put(prop[j].getName(), copyProp);
			}
		}

		formImports.clear();
	}

	/**
	 * I[oChB
	 * FormImportConfigC|[gvpeBǉƁA
	 * FormPropertyConfig̔zԂB
	 */
	public FormPropertyConfig[] findFormPropertyConfigs() {

		putFormImportConfigs();

		ExtendFormPropertyConfig results[] =
			new ExtendFormPropertyConfig[formProperties.size()];

		return (
			(FormPropertyConfig[]) formProperties.values().toArray(results));

	}

}