/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.common;

import java.io.Serializable;
import java.util.*;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionError;

import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.tstruts.util.MyServiceUtil;

/**
 * ƖsReLXgB<p>
 * InvocationContextC^tF[X̎ɉāACӂ̑ݒyю擾郁\bhǉNXłB<br>
 * <p>
 * ̎ł́ANGXgID̕oɁAKurofune{@link Sequence}T[rXgpBKurofunẽT[rXgp邽߁AOɃT[rX̒`sĂKvBKurofunẽT[rX`ł́AT[rXǗ}l[W̖OƂŊǗT[rX̖O`B̃NXŎgpSequenceT[rX̃T[rX́A{@link #SEQUENCE_NAME}ł̂ŁAT[rX`t@CSequence&lt;service&gt;vfnameɓOw肷KvB<br>
 * ܂ÃT[rXǗ}l[W̖ÓAstruts-config.xmlɃvOCƂĐݒ肷{@link jp.ossc.tstruts.config.SystemConfig SystemConfig}̑SystemServiceManagerNameŐݒ肷鎖ł̂ŁAT[rX`t@C&lt;manager&gt;vf̖OƈvKvB<br>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 * @see <a href="../doc-files/tstruts-client-service.xml">NCAgpT[rX`t@CiKurofuneT[rX`j</a>
 */
public class InvocationContextImpl
 implements InvocationContext, Serializable, Cloneable{
    
    /**
     * SequencẽT[rXB<p>
     */
    protected static final String SEQUENCE_NAME = "RequestIDSequence";
    
    private final Map map = new HashMap();
    
    private final Map requestAttributes = new HashMap();
    
    private final Map requestParams = new HashMap();
    
    private final Map httpHeaders = new HashMap();
    
    private final Map errors = new HashMap();
    
    private transient boolean isLocal;
    
    private String requestID;
    
    private Object userProfile;
    
    private ActionForm actionForm;
    
    private String forwardName;
    
    /**
     * RXgN^B<p>
     * CX^X鎞ɁAT[rX{@link #SEQUENCE_NAME}̃V[PXT[rXQƂāANGXgID𕥂o܂B<br>
     */
    public InvocationContextImpl(){
        this(true);
    }
    
    /**
     * RXgN^B
     * <p>
     * NGXgID̔
     * </p>
     * @param isNew
     */
    private InvocationContextImpl(boolean isNew){
        if(isNew){
            final Sequence sequence
                 = (Sequence)MyServiceUtil.getServiceObjectBySystemConfigProperty(SEQUENCE_NAME);
            setRequestID(sequence.increment());
        }
        
        isLocal = true;
    }
    
    public String getRequestID(){
        return requestID;
    }
    
    public void setRequestID(String requestID){
        this.requestID = requestID;
    }
    
    public Object getUserProfile(){
        return userProfile;
    }
    
    public void setUserProfile(Object profile){
        userProfile = profile;
    }
    
    public ActionForm getActionForm(){
        return actionForm;
    }
    
    public void setActionForm(ActionForm form){
        actionForm = form;
    }
    
    /**
     * ݒ肷B<p>
     *
     * @param name 
     * @param value 
     * @see #getAttribute(String)
     * @see #removeAttribute(String)
     * @see #clear()
     */
    public void setAttribute(String name, Object value){
        if(value instanceof Serializable){
            map.put(name, value);
        }
    }
    
    /**
     * 擾B<p>
     *
     * @param name 
     * @return 
     * @see #setAttribute(String, Object)
     * @see #removeAttribute(String)
     * @see #clear()
     */
    public Object getAttribute(String name){
        return map.get(name);
    }
    
    /**
     * ̌JԂ擾B<p>
     *
     * @return ̌JԂ
     */
    public Iterator getAttributeNames(){
        return new HashSet(map.keySet()).iterator();
    }
    
    /**
     * 폜B<p>
     *
     * @param name 
     * @see #setAttribute(String, Object)
     * @see #getAttribute(String)
     * @see #clear()
     */
    public void removeAttribute(String name){
        map.remove(name);
    }
    
    /**
     * i[ꂽSč폜B<p>
     * 
     * @see #setAttribute(String, Object)
     * @see #getAttribute(String)
     * @see #removeAttribute(String)
     */
    public void clear(){
        map.clear();
    }
    
    public boolean isLocal(){
        return isLocal;
    }
    
    public void setLocal(boolean isLocal){
        this.isLocal = isLocal;
    }
    
    public void addError(String key, ActionError error){
        errors.put(key, error);
    }
    
    public ActionError getError(String key){
        return (ActionError)errors.get(key);
    }
    
    public String[] getErrorKeys(){
        return (String[])errors.keySet().toArray(new String[errors.size()]);
    }
    
    public ActionError[] getErrors(){
        return (ActionError[])errors.values().toArray(
            new ActionError[errors.size()]
        );
    }
    public void setForwardName(String forward){
        forwardName = forward;
    }
    
    public String getForwardName(){
        return forwardName;
    }
    
    public String getServletRequestParameter(String name){
        final String[] values = getServletRequestParameterValues(name);
        return values != null && values.length != 0 ? values[0] : null;
    }
    
    public String[] getServletRequestParameterValues(String name){
        return (String[])requestParams.get(name);
    }
    
    public Object getServletRequestAttribute(String name){
        return requestAttributes.get(name);
    }
    
    public void setServletRequestAttribute(String name, Object value){
        if(value instanceof Serializable){
            requestAttributes.put(name, value);
        }
    }
    
    public String getServletRequestHeader(String name){
        final Enumeration enum = getServletRequestHeaders(name);
        return enum.hasMoreElements() ? (String)enum.nextElement() : null;
    }
    
    public Enumeration getServletRequestHeaders(String name){
        return (Enumeration)httpHeaders.get(name);
    }
    
    /**
     * ƖɓnHTTPNGXg̏i[B<p>
     * BKvȎɃI[o[ChĎ邱ƁB<br>
     *
     * @param request HTTPNGXg
     * @see #bridgeToServletRequest(HttpServletRequest)
     */
    public void bridgeFromServletRequest(HttpServletRequest request){
//        requestParams.putAll(request.getParameterMap());
        
//        Enumeration enum = request.getAttributeNames();
//        while(enum.hasMoreElements()){
//            final String name = (String)enum.nextElement();
//            final Object attribute = request.getAttribute(name);
//            if(attribute instanceof Serializable){
//                requestAttributes.put(name, attribute);
//            }
//        }
        
//        enum = request.getHeaderNames();
//        while(enum.hasMoreElements()){
//            final String name = (String)enum.nextElement();
//            httpHeaders.put(name, request.getHeaders(name));
//        }
    }
    
    public void bridgeToServletRequest(HttpServletRequest request){
        final Iterator keys = requestAttributes.keySet().iterator();
        while(keys.hasNext()){
            final String key = (String)keys.next();
            request.setAttribute(key, requestAttributes.get(key));
        }
    }
    
    public Object clone(){
        final InvocationContextImpl ctx = new InvocationContextImpl(false);
        ctx.setRequestID(requestID);
        ctx.setActionForm(actionForm);
        ctx.setUserProfile(userProfile);
        ctx.map.putAll(map);
        ctx.requestAttributes.putAll(requestAttributes);
        ctx.requestParams.putAll(requestParams);
        ctx.httpHeaders.putAll(httpHeaders);
        ctx.isLocal = isLocal;
        ctx.setForwardName(forwardName);
        ctx.errors.putAll(errors);
        return ctx;
    }
    
    /**
     * requestIDȊOB
     */
    public void reset() {
    	actionForm = null;
    	errors.clear();
    	forwardName = null;
    	httpHeaders.clear();
    	requestAttributes.clear();
    	requestParams.clear();
    	userProfile = null;
    }
}
