/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.common;

import java.io.Serializable;
import java.util.*;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionError;

/**
 * ƖsReLXgC^tF[XB<p>
 * Ɩs̓o͏i[ReLXgƂȂIuWFNgׂC^tF[XłB<br>
 * ̃C^tF[X̎NX́AʂƖ֓no͂̑ƂāAȉ̂̂񋟂KvB<br>
 * <table border="1">
 *   <tr bgcolor="#CCCCFF"><th>^</th><th>e</th><th>ANZT</th></tr>
 *   <tr><td rowspan="2">String</td><td rowspan="2">NGXgӂɎʂ郊NGXgID</td><td>{@link #getRequestID()}</td></tr>
 *   <tr><td>{@link #setRequestID(String)}</td></tr>
 *   <tr><td rowspan="2">Object</td><td rowspan="2">[Ui[IuWFNg</td><td>{@link #getUserProfile()}</td></tr>
 *   <tr><td>{@link #setUserProfile(Object)}</td></tr>
 *   <tr><td rowspan="2">ActionForm</td><td rowspan="2">ʂ̋Ɩւ̓͂ƂȂActionFormIuWFNg</td><td>{@link #getActionForm()}</td></tr>
 *   <tr><td>{@link #setActionForm(ActionForm)}</td></tr>
 *   <tr><td>String</td><td>NGXgp[^</td><td>{@link #getServletRequestParameter(String)}<br>{@link #getServletRequestParameterValues(String)}</td></tr>
 *   <tr><td rowspan="2">Object</td><td rowspan="2">NGXg</td><td>{@link #getServletRequestAttribute(String)}</td></tr>
 *   <tr><td>{@link #setServletRequestAttribute(String, Object)}</td></tr>
 *   <tr><td>String</td><td>HTTPNGXgwb_</td><td>{@link #getServletRequestHeader(String)}<br>{@link #getServletRequestHeaders(String)}</td></tr>
 * </table>
 * <p>
 * ̃IuWFNgnĂяoŁAJava VMׂ邩ǂ{@link #isLocal()}KvB̎́ÃIuWFNgJava VMEzfalseԂȂ΂ȂȂB܂ÃIuWFNgnĂяos\lāȂCӂɐݒ肷{@link #setLocal(boolean)}񋟂KvB<br>
 * ܂ÃIuWFNg̕T|[g邽߂ɁA{@link #clone()}KvB<br>
 * isLocal()AsetLocal(boolean)Aclone()́Apass by referenceŋƖĂяosۂɁÃIuWFNg̃[obNۏ؂邽߂łB<br>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public interface InvocationContext extends Serializable, Cloneable{
    
    /**
     * NGXgID擾B<p>
     *
     * @return NGXgID
     * @see #setRequestID(String)
     */
    public String getRequestID();
    
    /**
     * NGXgIDݒ肷B<p>
     *
     * @param requestID NGXgID
     * @see #getRequestID()
     */
    public void setRequestID(String requestID);
    
    /**
     * [Ui[IuWFNg擾B<p>
     * 
     * @return [Ui[IuWFNg
     * @see #setUserProfile(Object)
     */
    public Object getUserProfile();
    
    /**
     * [Ui[IuWFNgݒ肷B<p>
     * 
     * @param profile [Ui[IuWFNg
     * @see #getUserProfile()
     */
    public void setUserProfile(Object profile);
    
    /**
     * ʂƋƖԂł̓o͂ƂȂActionForm擾B<p>
     *
     * @return ʂƋƖԂł̓o͂ƂȂActionForm
     * @see #setActionForm(ActionForm)
     */
    public ActionForm getActionForm();
    
    /**
     * ʂƋƖԂł̓o͂ƂȂActionFormݒ肷B<p>
     *
     * @param form ʂƋƖԂł̓o͂ƂȂActionForm
     * @see #getActionForm()
     */
    public void setActionForm(ActionForm form);
    
    /**
     * ݒ肷B<p>
     *
     * @param name 
     * @param value 
     * @see #getAttribute(String)
     * @see #removeAttribute(String)
     * @see #clear()
     */
    public void setAttribute(String name, Object value);
    
    /**
     * 擾B<p>
     *
     * @param name 
     * @return 
     * @see #setAttribute(String, Object)
     * @see #removeAttribute(String)
     * @see #clear()
     */
    public Object getAttribute(String name);
    
    /**
     * ̌JԂ擾B<p>
     *
     * @return ̌JԂ
     */
    public Iterator getAttributeNames();
    
    /**
     * 폜B<p>
     *
     * @param name 
     * @see #setAttribute(String, Object)
     * @see #getAttribute(String)
     * @see #clear()
     */
    public void removeAttribute(String name);
    
    /**
     * i[ꂽSč폜B<p>
     * 
     * @see #setAttribute(String, Object)
     * @see #getAttribute(String)
     * @see #removeAttribute(String)
     */
    public void clear();
    
    /**
     * [JĂяoǂ𔻒肷B<p>
     * ̎́ÃIuWFNgJava VMEzfalseԂȂ΂ȂȂB<br>
     *
     * @return Java VMׂȂ[JĂяołꍇtrueAłȂꍇfalse
     * @see #setLocal(boolean)
     */
    public boolean isLocal();
    
    /**
     * [JĂяoǂݒ肷B<p>
     * ̃IuWFNgnĂяos\lāȂCӂɐݒ肷邽߂ɁA̎񋟂KvB<br>
     *
     * @param isLocal Java VMׂȂ[JĂяołꍇtrueAłȂꍇfalse
     * @see #isLocal()
     */
    public void setLocal(boolean isLocal);
    
    /**
     * NCAgɕԂG[ǉB<p>
     *
     * @param key G[̃L[
     * @param error G[
     */
    public void addError(String key, ActionError error);
    
    /**
     * w肵L[̃G[擾B<p>
     *
     * @param key G[̃L[
     * @return G[
     */
    public ActionError getError(String key);
    
    /**
     * NCAgɕԂG[̃L[̔z擾B<p>
     *
     * @return G[̃L[̔z
     */
    public String[] getErrorKeys();
    
    /**
     * NCAgɕԂG[̔z擾B<p>
     *
     * @return G[̔z
     */
    public ActionError[] getErrors();
    
    /**
     * tH[h肷tH[hw肷B<p>
     * w肵ȂꍇA&lt;select-forward&gt;ŃtH[h肷B<br>
     *
     * @param forward tH[h
     */
    public void setForwardName(String forward);
    
    /**
     * tH[h肷tH[hw肷B<p>
     *
     * @return tH[h
     */
    public String getForwardName();
    
    /**
     * HTTPNGXg̃p[^擾B<p>
     *
     * @param name p[^
     * @return HTTPNGXg̃p[^Bp[^̃p[^݂ꍇɂ́Aŏ̂PԂB
     * @see #getServletRequestParameterValues(String)
     */
    public String getServletRequestParameter(String name);
    
    /**
     * HTTPNGXg̃p[^擾B<p>
     *
     * @param name p[^
     * @return HTTPNGXg̃p[^zB
     * @see #getServletRequestParameter(String)
     */
    public String[] getServletRequestParameterValues(String name);
    
    /**
     * HTTPNGXg̑擾B<p>
     *
     * @param name 
     * @return HTTPNGXg̑
     * @see #setServletRequestAttribute(String, Object)
     */
    public Object getServletRequestAttribute(String name);
    
    /**
     * HTTPNGXg̑ݒ肷B<p>
     *
     * @param name 
     * @param value HTTPNGXg̑
     * @see #getServletRequestAttribute(String)
     */
    public void setServletRequestAttribute(String name, Object value);
    
    /**
     * HTTPNGXg̃wb_擾B<p>
     *
     * @param name wb_
     * @return HTTPNGXg̃wb_Bwb_̃wb_݂ꍇɂ́Aŏ̂PԂB
     * @see #getServletRequestHeaders(String)
     */
    public String getServletRequestHeader(String name);
    
    /**
     * HTTPNGXg̃wb_擾B<p>
     *
     * @param name wb_
     * @return HTTPNGXg̃wb_
     * @see #getServletRequestHeader(String)
     */
    public Enumeration getServletRequestHeaders(String name);
    
    /**
     * ƖɓnHTTPNGXg̏i[B<p>
     *
     * @param request HTTPNGXg
     * @see #bridgeToServletRequest(HttpServletRequest)
     */
    public void bridgeFromServletRequest(HttpServletRequest request);
    
    /**
     * Ɩ߂ĂHTTPNGXg̏AHTTPNGXgɊi[B<p>
     *
     * @param request HTTPNGXg
     * @see #bridgeFromServletRequest(HttpServletRequest)
     */
    public void bridgeToServletRequest(HttpServletRequest request);
    
    /**
     * ̃CX^X̕B<p>
     *
     * @return ̃CX^X̕
     */
    public Object clone();
    
    /**
     * InvocationContextB
     * <p>
     * x̃NGXgŕBLĂяoƂɁAInvocationContext͍ėpB
     * ̍ہAOBLݒ肵ActionErrorforwardNA邽߂ɌĂ΂B
     * </p>
     *
     */
    public void reset();
}
