/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.ossc.tstruts.auth.UserProfileInitializer;
import jp.ossc.tstruts.config.UserProfileConfig;
import jp.ossc.tstruts.config.UserProfilePropertyConfig;

/**
 * [Ui[DynClassB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 * @see jp.ossc.tstruts.common.DynaUserProfile
 */
public class DynaUserProfileClass implements DynaClass, Serializable {
	private static final Log log = LogFactory.getLog(DynaUserProfileClass.class);

	private String name = null;
	private DynaProperty properties[] = null;
	private transient Class dynaBeanClass = null;
	private transient Map propertiesMap = null;

	public DynaUserProfileClass() {
	}

	public DynaUserProfileClass(UserProfileConfig config) throws ClassNotFoundException {
		UserProfilePropertyConfig propertyConfigs[] = config.getProperties();
		name = config.getClassName();
		properties = new DynaProperty[propertyConfigs.length + 1];
		for (int i = 0; i < propertyConfigs.length; i++) {
			properties[i] = new DynaProperty(propertyConfigs[i].getName(),
				propertyConfigs[i].getTypeClass());
		}
		
		// F؍ς݃tÕtB[hǉ
		properties[propertyConfigs.length] =
			new DynaProperty(UserProfileInitializer.PROFILEKEY_AUTHENTICATED,
				Boolean.TYPE);
	}

	/**
	 *
	 */
	public String getName() {
		return name;
	}

	protected Class getDynaBeanClass() throws ClassNotFoundException {
		if (dynaBeanClass == null) {
			ClassLoader classLoader =
				Thread.currentThread().getContextClassLoader();
			if (classLoader == null) {
				classLoader = this.getClass().getClassLoader();
			}
			dynaBeanClass = classLoader.loadClass(name);
		}
		return dynaBeanClass;
	}

	/**
	 *
	 */
	public DynaProperty getDynaProperty(String name) {
		if (propertiesMap == null) {
			propertiesMap = new HashMap();
			for (int i = 0; i < properties.length; i++) {
				propertiesMap.put(properties[i].getName(), properties[i]);
			}
		}
		return (DynaProperty)propertiesMap.get(name);
	}

	/**
	 *
	 */
	public DynaProperty[] getDynaProperties() {
		return properties;
	}

	/**
	 *
	 */
	public DynaBean newInstance() {
		DynaUserProfile profile;
		try {
			profile = (DynaUserProfile)getDynaBeanClass().newInstance();
		} catch (Exception e) {
			String msg = "Specified UserProfile class is not instantiated.";
			log.fatal(msg, e);
			return null;
		}
		try {
			profile.setDynaClass(this);
		} catch (Exception e) {
			String msg = "Specified UserProfile property is invalid.";
			log.fatal(msg, e);
			return null;
		}
		return profile;
	}

}
