/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.FactoryService;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameRef;
import jp.ossc.nimbus.service.cache.Cache;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class DefaultActionCacheService
	extends ServiceBase
	implements ActionCache
	//, DefaultCacheHolderServiceMBean {
	{

	/**
	 * LbṼL[̂Ƃ(܂AActionɑ΂ĐRecp[^Ɋւ炸1̂Ƃ)
	 * ɗpLbVT[rX̃T[rXB̐ݒ肪sȂꍇ͑Oq̏ɓĂ͂܂Rec̓LbVȂB
	 */
	protected ServiceName defaultCacheServiceName = null;

	/**
	 * LbṼL[̂ƂɗpLbVT[rX
	 */
	protected Cache defaultCacheService = null;

	/**
	 * LbṼL[łȂƂ(܂AActionŐRecp[^ɂĈقȂƂ)
	 * ɗpLbVT[rX(ActionƂɃLbVT[rXKv)쐬FactoryServicẽT[rXB
	 * ̐ݒ肪sȂꍇ͑Oq̏ɂĂ͂܂Rec̓LbVȂB
	 */
	protected ServiceName cacheFactoryServiceName = null;

	/**
	 * ActionURIɑ΂Ă炩ߍ\ꂽLbVT[rX蓖Ă邽߂
	 * ServiceNameRefB
	 * ̐ݒɂăLbVT[rX蓖ĂꂽꍇAActionɂFactoryServiceT[rX쐬ƂƂ͂ȂB
	 */
	protected ServiceNameRef[] predefinedCacheNames = null;

	/**
	 * FactoryService쐬ꂽT[rXێList
	 */
	protected List generatedCaches = new ArrayList();

	/**
	 * LbVT[rXێMap
	 */
	protected Map caches = new HashMap();

//	private static Log log = LogFactory.getLog(DefaultCacheHolderService.class);
	// TODO T[rXcommons-logginggĂ͂Ȃ

	/**
	 * LbṼL[̂Ƃ(܂AActionɑ΂ĐRecp[^Ɋւ炸1̂Ƃ)
	 * ɗpLbVT[rX̃T[rXݒ肷B̐ݒ肪sȂꍇ͑Oq̏ɓĂ͂܂Rec̓LbVȂB
	 */
	public void setDefaultCacheServiceName(ServiceName name) {
		defaultCacheServiceName = name;
	}

	/**
	 * ftHgCacheT[rX擾
	 * @return T[rX
	 */
	public ServiceName getDefaultCacheServiceName() {
		return defaultCacheServiceName;
	}

	/**
	 * LbVt@NgT[rX̎擾
	 */
	public ServiceName getCacheFactoryServiceName() {
		return cacheFactoryServiceName;
	}

	/**
	 * LbVt@NgT[rX̐ݒ
	 */
	public void setCacheFactoryServiceName(ServiceName name) {
		cacheFactoryServiceName = name;
	}

	/**
	 * ActionURIɑ΂č\ς݃LbVT[rX֘At邽߂
	 * ServiceNameRefݒ
	 * @param refs
	 */
	public void setCacheServiceNameReferences(ServiceNameRef[] refs) {
		predefinedCacheNames = refs;
	}

	/**
	 * ActionURIɑ΂č\ς݃LbVT[rX֘At邽߂
	 * ServiceNameRef擾
	 * @return
	 */
	public ServiceNameRef[] getCacheServiceNameReferences() {
		return predefinedCacheNames;
	}
	
	/* ( Javadoc)
	 * @see jp.ossc.nimbus.core.Service#startService()
	 */
	public void startService() throws Exception {
		// cacheFactoryService擾AFactoryServiceł邱ƂmF
		if (cacheFactoryServiceName != null) {
			Service service = ServiceManagerFactory.getService(
				cacheFactoryServiceName);
			if (!(service instanceof FactoryService)) {
				throw new DeploymentException("Specified cacheFactoryServiceName '" +
					cacheFactoryServiceName + "' is not FactoryService");
			}
		}
		// defaultCacheService擾
		if (defaultCacheServiceName != null) {
			defaultCacheService = (Cache)ServiceManagerFactory.getService(
				defaultCacheServiceName);
		}

		// \ς݃LbVT[rX擾
		if (predefinedCacheNames == null) {
			return;
		}
		for (int i = 0; i < predefinedCacheNames.length; ++i) {
			caches.put(predefinedCacheNames[i].getReferenceServiceName(),
				ServiceManagerFactory.getServiceObject(
					predefinedCacheNames[i].getServiceName()));
		}
	}	

	/* (non-Javadoc)
	 * @see jp.ossc.nimbus.core.ServiceBaseSupport#stopService()
	 */
	public void stopService() throws Exception {
		synchronized (caches) {
			caches.clear();
		}
		defaultCacheService = null;
		synchronized (generatedCaches) {
			for (Iterator iter = generatedCaches.iterator(); iter.hasNext();) {
				Service service = (Service)iter.next();
				service.stop();
				service.destroy();
			}
			generatedCaches.clear();
		}
	}

	/* (non-Javadoc)
	 * @see jp.ossc.nimbus.core.ServiceBaseSupport#destroyService()
	 */
	public void destroyService() throws Exception {
		cacheFactoryServiceName = null;
		defaultCacheServiceName = null;
		predefinedCacheNames = null;
	}

	public CacheEntry createNewEntry() {
		return new CacheEntryImpl();
	}

	public CacheKey createNewKey(String path) {
		return new CacheKeyImpl(path);
	}

	public CacheEntry get(CacheKey key) {
		String path = key.getPath();
		if (key.getKeyLength() == 0) {
			if (defaultCacheService == null) {
				return null;
			}
			return (CacheEntry)defaultCacheService.get(path);
		}
		Cache cache;
		synchronized (caches) {
			cache = (Cache)caches.get(path);
		}
		if (cache == null) {
			return null;
		}
		return (CacheEntry)cache.get(key);
	}

	public void put(CacheKey key, CacheEntry entry) {
		String path = key.getPath();
		
		if (key.getKeyLength() == 0) {
			if (defaultCacheService == null) {
				return;
			}
			defaultCacheService.insert(key, entry);
			return;
		}
		
		Cache cache;
		synchronized (caches) {
			cache = (Cache)caches.get(path);
			if (cache == null && cacheFactoryServiceName != null) {
				cache = (Cache)ServiceManagerFactory.getServiceObject(
						cacheFactoryServiceName);
				caches.put(path, cache);
			}
		}
		if (cache != null) {
			cache.insert(key, entry);
		}
	}

	public void remove(String path) {
		if (defaultCacheService != null) {
			defaultCacheService.remove(path);
		}
		Cache cache = null;
		synchronized (caches) {
			cache = (Cache)caches.get(path);
		}
		if (cache == null) {
			return;
		}
		cache.flush();
	}

	public void remove(CacheKey key) {
		if (key.getKeyLength() == 0) {
			remove(key.getPath());
			return;
		}

		Cache cache = null;
		synchronized (caches) {
			cache = (Cache)caches.get(key.getPath());
		}
		if (cache == null) {
			return;
		}
		cache.remove(key);
	}

	public void removeAll() {
		if (defaultCacheService != null) {
			defaultCacheService.flush();
		}
		synchronized (caches) {
			for (Iterator iter = caches.values().iterator(); iter.hasNext();) {
				Cache cache = (Cache)iter.next();
				cache.flush();
			}
		}
	}
}
