/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.cache;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class CacheKeyImpl implements CacheKey {
	
	private String path = null;
	private List keysList = null;
	private CacheKeyEntry[] sortedKeys = null;
	private String combined = null;
	private int hashCode;
	
	public CacheKeyImpl(String path) {
		this.path = path;
	}
	
	public String getPath() {
		return path;
	}

	public void addKey(String name, String value) {
		sortedKeys = null;
		combined = null;
		CacheKeyEntry entry = new CacheKeyEntry(name, value);
		if (keysList == null) {
			keysList = new LinkedList();
		}
		keysList.add(entry);
	}

	public int getKeyLength() {
		if (keysList == null) {
			return 0;
		}
		return keysList.size();
	}

	public CacheKeyEntry[] getKeyEntries() {
		if (sortedKeys != null)
			return sortedKeys;
		if (keysList == null) {
			sortedKeys = new CacheKeyEntry[0];
		} else {
			Collections.sort(keysList);
			sortedKeys = (CacheKeyEntry[])keysList.toArray(new CacheKeyEntry[keysList.size()]);
		}
		return sortedKeys;
	}
	
	public CacheKeyEntry getKeyEntry(String name) {
		if (keysList == null) {
			return null;
		}
		for (Iterator iter = keysList.iterator(); iter.hasNext();) {
			CacheKeyEntry key = (CacheKeyEntry)iter.next();
			if (key.name.equals(name))
				return key;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		CacheKeyImpl another = (CacheKeyImpl)obj;
		return internalToString().equals(another.internalToString());
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		internalToString();
		return hashCode;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("CacheKey[");
		buf.append(internalToString());
		buf.append(']');
		return buf.toString();
	}

	protected String internalToString() {
		if (combined != null)
			return combined;
		StringBuffer buf = new StringBuffer();
		buf.append(path);
		buf.append(',');
		CacheKeyEntry[] entries = getKeyEntries();
		for (int i = 0; i < entries.length; ++i) {
			buf.append(entries[i].name);
			if (entries[i].value != null) {
				buf.append('=');
				buf.append(entries[i].value);
			}
			if (i < entries.length - 1)
				buf.append(',');
		}
		combined = buf.toString();
		hashCode = combined.hashCode();
		return combined;
	}
}
