/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.auth;

import java.io.IOException;
import java.security.Principal;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.config.UserProfileConfig;
import jp.ossc.tstruts.util.MyRequestUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.util.RequestUtils;

/**
 * [Uݒ肷FilterB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class UserProfileFilter implements Filter {
	private static final Log log = LogFactory.getLog(UserProfileFilter.class);

	private ServletContext context = null;

	/**
	 *  FilteȑBServletContextۑĂB
	 */
	public void init(FilterConfig config) throws ServletException {
		context = config.getServletContext();
	}

	/**
	 *
	 */
	public void doFilter(
		ServletRequest request,
		ServletResponse response,
		FilterChain chain)
	throws IOException, ServletException {
		
		HttpServletRequest httpRequest = (HttpServletRequest)request;
		if (request.getAttribute(MyGlobals.USER_PROFILE_KEY) != null) {
			chain.doFilter(request, response);
			return;
		}

		HttpSession session = httpRequest.getSession(false);
		if (session == null) {
			log.debug("The request doesn't have HttpSession.");
			Principal principal = (Principal)httpRequest.getUserPrincipal();

			UserProfileConfig factory = MyRequestUtil.getRootModuleConfig(context).getUserProfileConfig();
			if (factory == null) {
				log.debug("UserProfile is not configured.");
				chain.doFilter(request, response);
				return;
			}

			if (request.getAttribute(Globals.MODULE_KEY) == null) {
				RequestUtils.selectModule(httpRequest, context);
			}

			if (principal == null) {
				log.debug("Request user is not authenticated. Create default UserProfile.");
				Object profile = factory.createDefaultUserProfile(httpRequest);
				httpRequest.setAttribute(MyGlobals.USER_PROFILE_KEY, profile);
				chain.doFilter(request, response);
				return;
			}

			log.debug("Request user is authenticated. Create user specific UserProfile.");
			Object profile = factory.createAuthenticatedUserProfile(principal, httpRequest);
			session = httpRequest.getSession(true);
			session.setAttribute(MyGlobals.USER_PROFILE_KEY, profile);
			httpRequest.setAttribute(MyGlobals.USER_PROFILE_KEY, profile);
			chain.doFilter(request, response);
			return;
		}

		log.debug("The request has HttpSession.");

		Object profile = session.getAttribute(MyGlobals.USER_PROFILE_KEY);

		if (profile == null) {
			log.debug("The request doesn't have UserProfile.");

			UserProfileConfig factory = MyRequestUtil.getRootModuleConfig(context).getUserProfileConfig();
			if (factory == null) {
				log.debug("UserProfile is not configured.");
				chain.doFilter(request, response);
				return;
			}

			if (request.getAttribute(Globals.MODULE_KEY) == null) {
				RequestUtils.selectModule(httpRequest, context);
			}

			Principal principal = httpRequest.getUserPrincipal();
			if (principal != null) {
				log.debug("Request user is authenticated. Create user specific UserProfile.");
				profile = factory.createAuthenticatedUserProfile(principal, httpRequest);
				session.setAttribute(MyGlobals.USER_PROFILE_KEY, profile);
			} else {
				log.debug("Request user is not authenticated. Create default UserProfile.");
				profile = factory.createDefaultUserProfile(httpRequest);
			}
		} else {
			log.debug("Request has UserProfile.");
		}
		
		httpRequest.setAttribute(MyGlobals.USER_PROFILE_KEY, profile);
		chain.doFilter(request, response);
		return;
		
	}

	/**
	 * Filter̃N[Abv\bhBɏȂB
	 */
	public void destroy() {
	}

}
