/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.auth;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.*;

import org.apache.catalina.*;
import org.apache.catalina.authenticator.*;
import org.apache.catalina.deploy.LoginConfig;

/**
 * OCʂ𒼐ڕ\ł悤ɂ邽߂AuthenticatorB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public class DirectFormAuthenticator extends FormAuthenticator{
    
    public static final String REQUEST_URI_PARAMETER_NAME
         = "jp.ossc.tstruts.auth.RequestURI";
    
    public boolean authenticate(
        HttpRequest request,
        HttpResponse response,
        LoginConfig config
    ) throws IOException{
        final HttpServletRequest hreq
             = (HttpServletRequest)request.getRequest();
        String contextPath = hreq.getContextPath();
        String requestURI = request.getDecodedRequestURI();
        final boolean isLoginAction = requestURI.startsWith(contextPath)
            && requestURI.endsWith(Constants.FORM_ACTION);
        
        if(isLoginAction && !matchRequest(request)){
            final HttpServletResponse hres
                 = (HttpServletResponse)response.getResponse();
            requestURI = hreq.getParameter(REQUEST_URI_PARAMETER_NAME);
            if(requestURI != null){
                final Realm realm = context.getRealm();
                final String userName
                     = hreq.getParameter(Constants.FORM_USERNAME);
                final String password
                     = hreq.getParameter(Constants.FORM_PASSWORD);
                if(debug >= 1){
                    log("Authenticating username '" + userName + '\'');
                }
                final Principal principal = realm.authenticate(
                    userName,
                    password
                );
                if(principal == null){
                    final String errorURI = contextPath + config.getErrorPage();
                    if(debug >= 1){
                        log("Redirect to error page '" + errorURI + '\'');
                    }
                    hres.sendRedirect(hres.encodeRedirectURL(errorURI));
                    return false;
                }
                if(debug >= 1){
                    log("Authentication of '" + userName + "' was successful");
                }
                final Session session = getSession(request, true);
                session.setNote(Constants.FORM_PRINCIPAL_NOTE, principal);
                
                if(!cache){
                    session.setNote(Constants.SESS_USERNAME_NOTE, userName);
                    session.setNote(Constants.SESS_PASSWORD_NOTE, password);
                }
                hres.sendRedirect(
                    hres.encodeRedirectURL(contextPath + requestURI)
                );
                return true;
            }
        }
        
        return super.authenticate(request, response, config);
    }
}
