/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.auth;

import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.util.MessageResources;

import jp.ossc.tstruts.config.JDBCInitializerConfig;
import jp.ossc.tstruts.config.JDBCInitializerMappingConfig;
import jp.ossc.tstruts.config.UserProfileConfig;
import jp.ossc.tstruts.config.UserProfilePropertyConfig;

/**
 * F؏̏JNDI𗘗pčsNXB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class DefaultJDBCInitializer extends DefaultInitializer {
	private static final Log log = LogFactory.getLog(DefaultJDBCInitializer.class);

	private DataSource datasource = null;
	private JDBCInitializerConfig jdbcConfig = null;

	/**
	 *	InitializeȑBf[^\[X擾AϐɃLbVB
	 */
	public void initialize(UserProfileConfig config) throws Exception {
		super.initialize(config);
		jdbcConfig = config.getJDBCInitializerConfig();
		InitialContext ctx = new InitialContext();
		datasource = (DataSource)ctx.lookup(jdbcConfig.getDsJndiName());
	}

	/**
	 *  F؏DBA[Uvt@C쐬B
	 */
	public void initializeAuthorized(
		Object userProfile,
		Principal principal,
		HttpServletRequest request) {

		Connection con = null;
		PreparedStatement stmt = null;
		try {
			BeanUtils.setProperty(userProfile, PROFILEKEY_AUTHENTICATED, "true");
			con = getConnection();
			stmt = con.prepareStatement(jdbcConfig.getQuery());
			stmt.setString(1, principal.getName());
			ResultSet rs = stmt.executeQuery();
			if (!rs.next()) {
				String msg = "User[" + principal.getName() + "]'s profile is not found.";
				log.error(msg);
				return;
			}
			JDBCInitializerMappingConfig mappings[] = getJdbcConfig().getMappings();
			for (int i = 0; i < mappings.length; ++i) {
				String str = rs.getString(mappings[i].getColumn());
				String name = mappings[i].getProperty();
				UserProfilePropertyConfig propertyConfig = mappings[i].getAssociatedProperty();
				if (propertyConfig == null) {
					BeanUtils.setProperty(userProfile, name, str);
					continue;
				}
				Object value = propertyConfig.convert(str);
				BeanUtils.setProperty(userProfile, name, value);
			}
		} catch (Exception e) {
			String msg = "Failed to lookup UserProfile for user '" + principal.getName() + "'.";
			log.error(msg, e);
		} finally {
			if (stmt != null) {
				try {
					stmt.close();
				} catch (Exception e) {
					String msg = "Failed to close database statement.";
					log.error(msg, e);
				}
			}
			if (con != null) {
				try {
					con.close();
				} catch (Exception e) {
					String msg = "Failed to close database connection.";
					log.error(msg, e);
				}
			}
		}
		
		UserProfilePropertyConfig unmappedProperties[] = getJdbcConfig().getUnmappedPropertyConfig();
		if (unmappedProperties.length == 0)
			return;

		MessageResources resource = (MessageResources)request.getAttribute(Globals.MESSAGES_KEY);
		HttpSession session = request.getSession(false);
		Locale locale = null;
		// Only check session if sessions are enabled
		if (session != null) {
			locale = (Locale) session.getAttribute(Globals.LOCALE_KEY);
		}
		if (locale == null) {
			// Returns Locale based on Accept-Language header or the server default
			locale = request.getLocale();
		}
		
		for (int i = 0; i < unmappedProperties.length; ++i) {
			setProperty(userProfile, resource, locale, unmappedProperties[i]);
		}
	}

	public DataSource getDataSource() {
		return datasource;
	}
	
	public JDBCInitializerConfig getJdbcConfig() {
		return jdbcConfig;
	}
	
	public Connection getConnection() throws SQLException {
		return datasource.getConnection();
	}
}
