/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.web;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;

import jp.ossc.nimbus.service.context.Context;
import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.action.ejb.facade.BusinessGroup;
import jp.ossc.tstruts.common.InvocationContext;
import jp.ossc.tstruts.util.MyServiceUtil;

/**
  * PLeXgpInterceptorB<p>
  * BL쐬ĂȂԂPLeXg邽߂InterceptorB<p>
  * 
  *
  * @version $Revision: 1.8 $
  * @author H.Matsuno
  * @since 1.0
  * @see jp.ossc.tstruts.action.web.CallBusinessInterceptorBase
  */
public class FakeEJBActionInterceptor extends CallBusinessInterceptorBase {

	protected static boolean isTestMode = false;

	protected static final Log log =
		LogFactory.getLog(CallBusinessInterceptorBase.class);

	/**
	 * Test̃T[rXB<p>
	 */
	protected static final String TEST_SERVICE_NAME = "PLTestService";

	public InvocationContext next(
		BusinessGroup group,
		ActionMapping mapping,
		HttpServletRequest request,
		InvocationContext context,
		EJBAction action)
		throws Exception {

		/* Nimbus̃eXgT[rXeXg[hǂ𔻒f */

		final Context test =
			(Context) MyServiceUtil.getServiceObjectBySystemConfigProperty(TEST_SERVICE_NAME);

		if (test != null) {
			String isTestMode =
				(String) test.get("isTestMode");
			setIsTestMode((new Boolean(isTestMode)).booleanValue());
		} else {
			log.info("Nimbus TestService is null. ");
		}

		log.info("testMode is: " + isTestMode);
		if (!isTestMode) {
			return super.next(group, mapping, request, context, action);
		}

		String className =
			(String) request.getParameter(MyGlobals.TESTCASE_CLASS_NAME);
		if (className == null) {
			log.info("className is null.");
			return super.next(group, mapping, request, context, action);
		}
		Class clazz = Class.forName(className);
		Object testCase = clazz.newInstance();

		String methodName =
			(String) request.getParameter(MyGlobals.TESTCASE_METHOD_NAME);
		if (methodName == null) {
			log.info("methodName is null.");
			clazz = null;
			testCase = null;
			return super.next(group, mapping, request, context, action);
		}

		Method runMethod = null;
		Class param[] = new Class[1];
		param[0] = InvocationContext.class;
		runMethod = clazz.getMethod(methodName, param);

		Object obj[] = new Object[1];
		obj[0] = (Object) context;
		Object ret = runMethod.invoke(testCase, obj);

		clazz = null;
		testCase = null;
		runMethod = null;
		param = null;
		obj = null;

		return (InvocationContext)ret;
	}

	/**
	 * @return
	 */
	public boolean getIsTestMode() {
		return isTestMode;
	}

	/**
	 * @param b
	 */
	public void setIsTestMode(boolean b) {
		isTestMode = b;
	}

}
