/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.web;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;

import jp.ossc.tstruts.action.ejb.facade.BusinessGroup;
import jp.ossc.tstruts.common.InvocationContext;

/**
  * CallBusinessInterceptor̊NXB<p>
  * EJBActioncallBusiness\bhOɎsInterceptoŕÃNXpč쐬B
  *
  * @version $Revision: 1.6 $
  * @author H.Matsuno
  * @since 1.0
  * @see jp.ossc.tstruts.action.web.CallBusinessInterceptor
  */
public class CallBusinessInterceptorBase implements CallBusinessInterceptor {

	protected CallBusinessInterceptor next = null;
	protected String name = null;

	public CallBusinessInterceptorBase() {
		this(null);
	}
	public CallBusinessInterceptorBase(String name) {
		this.name = name;
	}

	public InvocationContext next(
        BusinessGroup group,
		ActionMapping mapping,
        HttpServletRequest request,
		InvocationContext context,
		EJBAction action)
		throws Exception {

        InvocationContext ctx = null;
        if (getNext() == null) {
            ctx = action.callBusiness(group, mapping, request, context);
        } else {
            ctx = getNext().next(group, mapping, request, context, action);
        }
        
        return ctx;
	}

	public CallBusinessInterceptor getNext() {
		return next;
	}

	public void setNext(CallBusinessInterceptor interceptor) {
		this.next = interceptor;
	}
}
