/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.transaction;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * dMh~@\gpɎgpTransactionId𐶐NXB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author sakata
 * @since 1.0
 */
public class TransactionCreateId{

	/**
	 * TransactionCreateIdNXŎgpłorg.apache.commons.logging.Log̎łB
	 */
	protected static final Log log = LogFactory.getLog(TransactionCreateId.class);
    
	/** dM}~̃L[JE^ */
	private static long counter_ = 0L;
	
	/** dM}~̃L[JE^ől */
	private long COUNTER_MAX = 9999L;
        
    public TransactionCreateId(){
    }
    
	/**
	 * TransactedID̍쐬\bh<BR>
	 * TransactedID́uݎ{JE^vō쐬
	 * @return transactedId@dMh~@\gpɎgpID
	 */
	public String createTransactionId(){        

		String currentDate = "";
		String transactedCounter = "";
		String transactedId = "";

		// t擾
		currentDate = getCurrentDate();
		// JE^擾
		transactedCounter = getTransactedIdCounter();
		// NGXgID̐ݒ
		transactedId = currentDate + transactedCounter;
		
		return transactedId;
	}       
    
	/**
	 * t擾\bh<BR>
	 * tH[}bg"YYYYMMDD"B<BR>
	 * <br>
	 * @return t
	 */
	public String getCurrentDate() {
		String currentDate = "";
    
		Calendar  calendar = Calendar.getInstance();

		// N
		String yyyy = Integer.toString(calendar.get(Calendar.YEAR));

		// 
		int mmValue = calendar.get(Calendar.MONTH) + 1;
		String mm = Integer.toString(mmValue);
		if(mmValue < 10) {
			mm = "0" + mm;
		}

		// 
		int ddValue = calendar.get(Calendar.DAY_OF_MONTH);
		String dd = Integer.toString(ddValue);
		if(ddValue < 10) {
			dd = "0" + dd;
		}

		currentDate = yyyy + mm + dd;

		return currentDate;
	}

	/** JE^擾\bhB<BR>
	* tH[}bg4B4ȂEl0pfBOB<BR>
	* 9999̎̓JE^0ɖ߂đsB
	* <br>
	* ȉExceptionꍇASystemփbZ[Wo͂܂B
	* [exception]IndexOutOfBoundsExceptionFJE^̒ls̏ꍇ
	* <br>
	* @return JE^
	*/
	protected synchronized String getTransactedIdCounter() {
	   String tmpCounter = "";
	   String transactedCounter = "";
	   String padding = "0000";
	   int transactedCounterLength = 4;
	   int startIndex = 0;

	   try{
			// JE^̎擾
			tmpCounter = Long.toString(counter_,10);
			tmpCounter = padding + tmpCounter;
			startIndex = tmpCounter.length() - transactedCounterLength;

			transactedCounter = tmpCounter.substring(startIndex);
		   
			if(counter_ >= COUNTER_MAX){
				counter_ = 0;
			} else {
				counter_++;
			}		   

	   }catch(IndexOutOfBoundsException e){
			// JE^̒ls̏ꍇ
			transactedCounter = "-----------";
			log.error("Counter Error.",e);
	   }
	   return transactedCounter;
	}
	
}