/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.facade;

import java.net.*;
import java.util.*;
import java.rmi.RemoteException;
import javax.ejb.*;
import javax.naming.*;

import jp.ossc.nimbus.core.*;

import jp.ossc.tstruts.action.ejb.*;
import jp.ossc.tstruts.action.ejb.business.Business;
import jp.ossc.tstruts.common.InvocationContext;

/**
 * ƖO[vEJBNXB<p>
 * ƖO[vFacadeƂȂStateless Session Bean̎NXłB<br>
 * EJBNXgpꍇAEJB̃fvCgLqqejb-jar.xml&lt;ejb-class&gt;vfɁÃNX̃NXw肷KvB<br>
 * <pre>
 *   &lt;ejb-jar&gt;
 *     &lt;enterprise-beans&gt;
 *       &lt;session&gt;
 *         &lt;ejb-name&gt;BusinessGroup1&lt;/ejb-name&gt;
 *               :
 *         &lt;ejb-class&gt;jp.ossc.tstruts.action.ejb.facade.BusinessGroupBean&lt;/ejb-class&gt;
 *               :
 * </pre>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 * @see BusinessGroupHome
 * @see BusinessGroup
 * @see <a href="doc-files/ejb-jar.xml">ejb-jar.xmlTv</a>
 */
public class BusinessGroupBean implements SessionBean{
    
    /**
     * EJB̊ϐJNDIlookupׂJNDIReLXgB<p>
     */
    private static final String JAVA_ENV_KEY = "java:comp/env";
    
    /**
     * &lt;env-entry&gt;vf̎qvf&lt;env-entry-name&gt;Ŏw肷ƖO[ṽL[B<p>
     */
    private static final String GROUP_ENV_KEY = "group-name";
    
    /**
     * &lt;env-entry&gt;vf̎qvf&lt;env-entry-name&gt;Ŏw肷ƖO[v`t@CpX̃L[B<p>
     */
    private static final String SERVICE_PATH_ENV_KEY = "service-path";
    
    /**
     * ftHg̋ƖO[vB<p>
     */
    private static final String DEFAULT_GROUP_NAME = "default";
    
    /**
     * SessionContext IuWFNgB<p>
     */
    private SessionContext sessionContext;
    
    /**
     * ƖO[vB<p>
     */
    private String groupName;
    
    /**
     * ƖO[v`t@CpXB<p>
     */
    private String servicePath;
    
    /**
     * ƖO[v擾B<p>
     * EJB̃fvCgLqqejb-jar.xml&lt;env-entry&gt;vfŎw肵"group-name"擾łB<br>
     * &lt;env-entry&gt;vf̎ẃAȉ̂悤ɍsB
     * <pre>
     *               :
     *         &lt;env-entry&gt;
     *           &lt;env-entry-name&gt;group-name&lt;/env-entry-name&gt;
     *           &lt;env-entry-type&gt;java.lang.String&lt;/env-entry-type&gt;
     *           &lt;env-entry-value&gt;Group1&lt;/env-entry-value&gt;
     *         &lt;/env-entry&gt;
     *               :
     * </pre>
     * AA&lt;env-entry-value&gt;vfŎw肷ƖO[v́AΉƖO[v`t@CŎw肷&lt;manager&gt;name̒lƈvȂ΂ȂȂB
     * 
     * @return ƖO[v
     * @see BusinessGroup#getGroupName()
     * @see <a href="doc-files/ejb-jar.xml">ejb-jar.xmlTv</a>
     * @see <a href="../business/doc-files/business-group1.xml">ƖO[v`t@CTv</a>
     */
    public String getGroupName(){
        return groupName;
    }
    
    /**
     * ̋ƖO[v́Aw肳ꂽƖ̋ƖsB<p>
     *
     * @param name Ɩ
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖsɗOꍇ
     * @exception BusinessSystemException EJBł̃VXeOiO[vȂꍇj
     * @see BusinessGroup#doBusiness(String, InvocationContext)
     * @see BusinessGroup#doBusiness(String, InvocationContext)
     * @see jp.ossc.tstruts.action.ejb.BusinessGroupNotFoundException
     * @see jp.ossc.tstruts.action.ejb.BusinessSystemException
     * @see jp.ossc.tstruts.action.ejb.IllegalBusinessStateException
     * @see jp.ossc.tstruts.action.ejb.BusinessTransactionManagerException
     */
    public InvocationContext doBusiness(String name, InvocationContext context)
     throws BusinessException, BusinessSystemException{
        
        final ServiceManager manager
             = ServiceManagerFactory.findManager(groupName);
        if(manager == null){
            throw new BusinessGroupNotFoundException(groupName);
        }
        
        Business business = null;
        try{
            business = (Business)manager.getServiceObject(name);
        }catch(ServiceNotFoundException e){
            throw new BusinessNotFoundException(groupName, name);
        }
        
        business.setBusinessGroup(
            (BusinessGroup)getEJBObject()
        );
        
        return business.work(context);
    }
    
    /**
     * ֘AtꂽSessionContextݒ肷B<p>
     * 
     * @param context SessionContextIuWFNg
     * @exception EJBException VXex̃G[ŏQꍇ
     * @exception RemoteException ̗ÓAEJB 1.0dlɏꂽG^[vCYBean ɉʌ݊邽߂Ƀ\bh̃VOj`[ɒ`ĂBEJB 1.1dlɏꂽG^[vCYBeańA̗Ȏjavax.ejb.EJBExceptionX[KvBEJB2.0ȍ~̎dlɏꂽG^[vCYBeańA̗Ȏjavax.ejb.EJBExceptionX[Kv
     * @see #getSessionContext()
     */
    public void setSessionContext(final SessionContext context)
     throws EJBException, RemoteException{
        sessionContext = context;
    }
    
    /**
     * ֘AtꂽSessionContext擾B<p>
     * 
     * @return SessionContextIuWFNg
     * @see #setSessionContext(SessionContext)
     */
    public SessionContext getSessionContext(){
        if(sessionContext == null){
            throw new IllegalStateException("session context is invalid");
        }
        return sessionContext;
    }
    
    /**
     * ֘AtꂽEJBContext擾B<p>
     * 
     * @return EJBContextIuWFNg
     */
    public EJBContext getEJBContext(){
        return getSessionContext();
    }
    
    /**
     * EJB̃[gQƂłEJBObjectIuWFNg擾B<p>
     * 
     * @return EJBObjectIuWFNg
     */
    public EJBObject getEJBObject() {
        return getSessionContext().getEJBObject();
    }
    
    /**
     * activate\bh́ACX^Xu񊈐vԂ犈ԂɂȂƂɌĂяoB<p>
     * ̃CX^Xł́AȑOejbPassivate()\bhŉ\[XׂĎ擾KvB<br>
     * <p>
     * ̃\bh́AgUNVReLXggpȂŌĂяoB
     *
     * @exception EJBException VXex̃G[ŏQꍇ
     * @exception RemoteException ̗ÓAEJB 1.0dlɏꂽG^[vCYBean ɉʌ݊邽߂Ƀ\bh̃VOj`[ɒ`ĂBEJB 1.1dlɏꂽG^[vCYBeańA̗Ȏjavax.ejb.EJBExceptionX[KvBEJB2.0ȍ~̎dlɏꂽG^[vCYBeańA̗Ȏjavax.ejb.EJBExceptionX[Kv
     */
    public void ejbActivate() throws EJBException, RemoteException{}
    
    /**
     * passivate\bh́ACX^Xu񊈐vԂɂȂOɌĂяoB<p>
     * ̃CX^Xł́AƂejbActivate()\bhŎ擾ȂƂł郊\[XׂĉKvB<br>
     * <p>
     * passivate\bhÃCX^X́AReiJava SerializationvgRgăCX^X̏ԂOAۊǂĂԂɂȂȂ΂Ȃ܂B<br>
     * <p>
     * ̃\bh́AgUNVReLXggpȂŌĂяo܂B<br>
     * 
     * @exception EJBException VXex̃G[ŏQꍇ
     * @exception RemoteException ̗ÓAEJB 1.0dlɏꂽG^[vCYBean ɉʌ݊邽߂Ƀ\bh̃VOj`[ɒ`ĂBEJB 1.1dlɏꂽG^[vCYBeańA̗Ȏjavax.ejb.EJBExceptionX[KvBEJB2.0ȍ~̎dlɏꂽG^[vCYBeańA̗Ȏjavax.ejb.EJBExceptionX[Kv
     */
    public void ejbPassivate() throws EJBException, RemoteException{}
    
    /**
     * Reił́AZbVIuWFNg̗LԂI点OɁÃ\bhĂяo܂B<p>
     * ̏́ANCAg폜Iy[VĂяoʂƂāA܂̓Rei^CAEgɃZbVIuWFNgIƂɍs܂B<br>
     * <p>
     * ̃\bh́AgUNVReLXggpȂŌĂяo܂B<br>
     * 
     * @exception EJBException VXex̃G[ŏQꍇ
     * @exception RemoteException ̗ÓAEJB 1.0dlɏꂽG^[vCYBean ɉʌ݊邽߂Ƀ\bh̃VOj`[ɒ`ĂBEJB 1.1dlɏꂽG^[vCYBeańA̗Ȏjavax.ejb.EJBExceptionX[KvBEJB2.0ȍ~̎dlɏꂽG^[vCYBeańA̗Ȏjavax.ejb.EJBExceptionX[Kv
     */
    public void ejbRemove() throws EJBException, RemoteException{
        if(servicePath != null){
            final ServiceManager manager
                 = ServiceManagerFactory.findManager(groupName);
            if(manager != null){
                manager.stop();
                manager.destroy();
            }
        }
    }
    
    /**
     * Reił́AZbVIuWFNg̗LԂJnOɁÃ\bhĂяo܂B<p>
     * ̏́ANCAgIy[VĂяoʂƂčs܂B<br>
     * <p>
     * ̃\bh́AgUNVReLXggpȂŌĂяo܂B<br>
     * 
     * @exception EJBException VXex̃G[ŏQꍇ
     * @exception RemoteException ̗ÓAEJB 1.0dlɏꂽG^[vCYBean ɉʌ݊邽߂Ƀ\bh̃VOj`[ɒ`ĂBEJB 1.1dlɏꂽG^[vCYBeańA̗Ȏjavax.ejb.EJBExceptionX[KvBEJB2.0ȍ~̎dlɏꂽG^[vCYBeańA̗Ȏjavax.ejb.EJBExceptionX[Kv
     */
    public void ejbCreate() throws EJBException, RemoteException{
        groupName = getEnvProperty(GROUP_ENV_KEY, DEFAULT_GROUP_NAME);
        servicePath = getEnvProperty(SERVICE_PATH_ENV_KEY);
        if(servicePath != null){
            final URL serviceURL
                 = getClass().getClassLoader().getResource(servicePath);
            ServiceManagerFactory.loadManager(serviceURL);
            final ServiceManager manager
                 = ServiceManagerFactory.findManager(groupName);
            if(manager != null){
                final Iterator businesses
                     = manager.serviceObjectSet().iterator();
                while(businesses.hasNext()){
                    final Object obj = businesses.next();
                    if(obj instanceof Business){
                        final Business business = (Business)obj;
                        business.setBusinessGroup(
                            (BusinessGroup)getEJBObject()
                        );
                        business.setEJBContext(getEJBContext());
                    }
                }
            }
        }
    }
    
    /**
     * EJB̊ϐJNDIlookupāA擾B<p>
     *
     * @param name ϐ
     * @return ϐBȂꍇ́AnullԂB
     */
    private static String getEnvProperty(String name){
        String value = null;
        try{
            final Context context = new InitialContext();
            final Context env = (Context)context.lookup(JAVA_ENV_KEY);
            value = (String)env.lookup(name);
        }catch(NamingException e){
        }
        return value;
    }
    
    /**
     * EJB̊ϐJNDIlookupāA擾B<p>
     *
     * @param name ϐ
     * @param defaultValue ftHgl
     * @return ϐBȂꍇ́AŎw肳ꂽftHglԂB
     */
    private static String getEnvProperty(String name, String defaultValue){
        String value = getEnvProperty(name);
        if(value == null){
            value = defaultValue;
        }
        return value;
    }
}