/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.business;

import java.util.*;
import java.io.Serializable;

import jp.ossc.nimbus.service.journal.editor.MapJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

import jp.ossc.tstruts.common.InvocationContext;

/**
 * {@link InvocationContext}MaptH[}bgGfB^B<p>
 * ̃GfB^ɂĕҏWꂽMaṕAȉ̍\B<br>
 * <table broder="1">
 *   <tr bgcolor="#CCCCFF"><th colspan="2">L[</th><th colspan="5">l</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>^</th><th>e</th><th>^</th><th colspan="4">e</th></tr>
 *   <tr><td>java.lang.String</td><td>{@link #REQUEST_ID_KEY}</td><td>java.lang.String</td><td colspan="4">NGXgID</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #USER_PROFILE_KEY}</td><td>java.lang.Object</td><td colspan="4">[U</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #ACTION_FORM_KEY}</td><td>org.apache.struts.action.ActionForm</td><td colspan="4">ActionForm</td></tr>
 *   <tr><td rowspan="3">java.lang.String</td><td rowspan="3">{@link #ATTRIBUTES_KEY}</td><td rowspan="3">java.util.Map</td><td colspan="4">̃}bv</td></tr>
 *   <tr bgcolor="#CCCCFF"><th>^</th><th>e</th><th>^</th><th>e</th></tr>
 *   <tr><td>java.lang.String</td><td></td><td>java.lang.Object</td><td>l</td></tr>
 *   <tr><td rowspan="3">java.lang.String</td><td rowspan="3">{@link #ERRORS_KEY}</td><td rowspan="3">java.util.Map</td><td colspan="4">ActionError̃}bv</td></tr>
 *   <tr bgcolor="#CCCCFF"><th>^</th><th>e</th><th>^</th><th>e</th></tr>
 *   <tr><td>java.lang.String</td><td>ActionError̃L[</td><td>org.apache.struts.action.ActionError</td><td>ActionError</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #FORWARD_NAME_KEY}</td><td>java.lang.String</td><td colspan="4">tH[h</td></tr>
 * </table>
 * AAo͂Ȃ悤ɐݒ肳Ă̂AInvocationContextɊ܂܂ĂȂ͊܂܂ȂB<br>
 * 
 * @author M.Takata
 */
public class InvocationContextMapJournalEditor
 extends MapJournalEditorServiceBase
 implements InvocationContextMapJournalEditorMBean, Serializable{
    
    private boolean isOutputRequestId = true;
    private boolean isOutputUserProfile = true;
    private boolean isOutputActionForm = true;
    private boolean isOutputAttributes = true;
    private boolean isOutputErrors = true;
    private boolean isOutputForwardName = true;
    
    private String[] secretAttributes;
    protected Set secretAttributeSet;
    private String[] enabledAttributes;
    protected Set enabledAttributeSet;
    
    public void setSecretAttributes(String[] names){
        secretAttributes = names;
    }
    
    public String[] getSecretAttributes(){
        return secretAttributes;
    }
    
    public void setOutputRequestId(boolean isOutput){
        isOutputRequestId = isOutput;
    }
    
    public boolean isOutputRequestId(){
        return isOutputRequestId;
    }
    
    public void setOutputUserProfile(boolean isOutput){
        isOutputUserProfile = isOutput;
    }
    
    public boolean isOutputUserProfile(){
        return isOutputUserProfile;
    }
    
    public void setOutputActionForm(boolean isOutput){
        isOutputActionForm = isOutput;
    }
    
    public boolean isOutputActionForm(){
        return isOutputActionForm;
    }
    
    public void setOutputAttributes(boolean isOutput){
        isOutputAttributes = isOutput;
    }
    
    public boolean isOutputAttributes(){
        return isOutputAttributes;
    }
    
    public void setOutputErrors(boolean isOutput){
        isOutputErrors = isOutput;
    }
    
    public boolean isOutputErrors(){
        return isOutputErrors;
    }
    
    public void setOutputForwardName(boolean isOutput){
        isOutputForwardName = isOutput;
    }
    
    public boolean isOutputForwardName(){
        return isOutputForwardName;
    }
    
    public void setEnabledAttributes(String[] names){
        enabledAttributes = names;
    }
    
    public String[] getEnabledAttributes(){
        return enabledAttributes;
    }
    
    public void createService(){
        secretAttributeSet = new HashSet();
        enabledAttributeSet = new HashSet();
    }
    
    public void startService(){
        if(secretAttributes != null){
            for(int i = 0; i < secretAttributes.length; i++){
                secretAttributeSet.add(secretAttributes[i]);
            }
        }
        if(enabledAttributes != null){
            for(int i = 0; i < enabledAttributes.length; i++){
                enabledAttributeSet.add(enabledAttributes[i]);
            }
        }
    }
    
    public void stopService(){
        secretAttributeSet.clear();
        enabledAttributeSet.clear();
    }
    
    public void destroyService(){
        secretAttributeSet = null;
        enabledAttributeSet = null;
    }
    
    /**
     * W[iƂė^ꂽInvocationContext^̏W[iƂďo͂MapɕϊB<br>
     * 
     * @param finder K؂JournalEditor񋟂EditorFinder
     * @param key W[ĩL[
     * @param value W[i
     * @return W[iƂďo͂Map
     */
    public Map toMap(EditorFinder finder, Object key, Object value){
        final InvocationContext context = (InvocationContext)value;
        final Map result = new HashMap();
        if(isOutputRequestId()){
            makeRequestIdFormat(finder, key, context, result);
        }
        if(isOutputUserProfile()){
            makeUserProfileFormat(finder, key, context, result);
        }
        if(isOutputActionForm()){
            makeActionFormFormat(finder, key, context, result);
        }
        if(isOutputAttributes()){
            makeAttributesFormat(finder, key, context, result);
        }
        if(isOutputErrors()){
            makeErrorsFormat(finder, key, context, result);
        }
        if(isOutputForwardName()){
            makeForwardNameFormat(finder, key, context, result);
        }
        return result;
    }
    
    protected Map makeRequestIdFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        Map map
    ){
        map.put(REQUEST_ID_KEY, context.getRequestID());
        return map;
    }
    
    protected Map makeUserProfileFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        Map map
    ){
        map.put(
            USER_PROFILE_KEY,
            makeObjectFormat(
                finder,
                null,
                context.getUserProfile()
            )
        );
        return map;
    }
    
    protected Map makeActionFormFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        Map map
    ){
        map.put(
            ACTION_FORM_KEY,
            makeObjectFormat(
                finder,
                null,
                context.getActionForm()
            )
        );
        return map;
    }
    
    protected Map makeAttributesFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        Map map
    ){
        final Iterator attrNames = context.getAttributeNames();
        if(!attrNames.hasNext()){
            return map;
        }
        final Map subMap = new HashMap();
        while(attrNames.hasNext()){
            final String name = (String)attrNames.next();
            if(!enabledAttributeSet.isEmpty()
                 && !enabledAttributeSet.contains(name)){
                continue;
            }
            if(secretAttributeSet.contains(name)){
                subMap.put(name, null);
            }else{
                subMap.put(
                    name,
                    makeObjectFormat(
                        finder,
                        null,
                        context.getAttribute(name)
                    )
                );
            }
        }
        map.put(ATTRIBUTES_KEY, subMap);
        return map;
    }
    
    protected Map makeErrorsFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        Map map
    ){
        final String[] errorKeys = context.getErrorKeys();
        if(errorKeys == null || errorKeys.length == 0){
            return map;
        }
        final Map subMap = new HashMap();
        for(int i = 0, max = errorKeys.length; i < max; i++){
            subMap.put(
                errorKeys[i],
                makeObjectFormat(
                    finder,
                    null,
                    context.getError(errorKeys[i])
                )
            );
        }
        map.put(ERRORS_KEY, subMap);
        return map;
    }
    
    protected Map makeForwardNameFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        Map map
    ){
        map.put(FORWARD_NAME_KEY, context.getForwardName());
        return map;
    }
}