/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.business;

import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link BusinessJournalInterceptor}MBeanC^tF[XB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 * @see BusinessJournalInterceptor
 */
public interface BusinessJournalInterceptorMBean
 extends BusinessInterceptorServiceBaseMBean{
    
    /**
     * W[io͂W[iT[rX̃T[rXݒ肷B<p>
     * ŁAݒ肷T[rX̃T[rX́A{@link jp.ossc.nimbus.service.journal.Journal}C^tF[XĂKvB<br>
     * <p>
     * ̃T[rXw肵Ȃꍇ́ÃIuWFNgɂW[io͂ȂB<br>
     *
     * @param name o͐̃W[iT[rX̃T[rX
     * @see #getJournal()
     */
    public void setJournal(ServiceName name);
    
    /**
     * W[io͂W[iT[rX̃T[rX擾B<p>
     *
     * @return o͐̃W[iT[rX̃T[rX
     * @see #setJournal(ServiceName)
     */
    public ServiceName getJournal();
    
    /**
     * W[ȉo̓tH[}bg𐶐GfB^T[rXGfB^t@C_T[rX̃T[rXݒ肷B<p>
     * ŁAݒ肷T[rX̃T[rX́A{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder}C^tF[XĂKvB<br>
     * <p>
     * ̃T[rXw肷ƁA{@link #setJournal(ServiceName)}Ŏw肳ꂽW[iT[rXɐݒ肳ĂGfB^t@C_D悳B<br>
     * w肵Ȃꍇ́A{@link #setJournal(ServiceName)}Ŏw肳ꂽW[iT[rXɐݒ肳ĂGfB^t@C_gpB<br>
     *
     * @param name GfB^t@C_T[rX̃T[rX
     * @see #getEditorFinder()
     */
    public void setEditorFinder(ServiceName name);
    
    /**
     * W[ȉo̓tH[}bg𐶐GfB^T[rXGfB^t@C_T[rX̃T[rX擾B<p>
     *
     * @return GfB^t@C_T[rX̃T[rX
     * @see #setEditorFinder(ServiceName)
     */
    public ServiceName getEditorFinder();
    
    /**
     * ŏo͂W[ĩ[gvf̃L[ݒ肷B<p>
     * Ŏw肳ꂽL[́A{@link jp.ossc.nimbus.service.journal.Journal#startJournal(String)}̈ƂĎgpB<br>
     *
     * @param key ŏo͂W[ĩ[gvf̃L[
     * @see #getRequestJournalKey()
     */
    public void setRequestJournalKey(String key);
    
    /**
     * ŏo͂W[ĩ[gvf̃L[擾B<p>
     *
     * @return ŏo͂W[ĩ[gvf̃L[
     * @see #setRequestJournalKey(String)
     */
    public String getRequestJournalKey();
    
    /**
     * ŏo͂W[ĩ\bhĂяovf̃L[ݒ肷B<p>
     * Ŏw肳ꂽL[́A{@link jp.ossc.nimbus.service.journal.Journal#addInfo(String, Object)}̑ƂĎgpB<br>
     *
     * @param key ŏo͂W[ĩ\bhĂяovf̃L[
     * @see #getMethodCallJournalKey()
     */
    public void setMethodCallJournalKey(String key);
    
    /**
     * ŏo͂W[ĩ\bhĂяovf̃L[擾B<p>
     *
     * @return ŏo͂W[ĩ\bhĂяovf̃L[
     * @see #setMethodCallJournalKey(String)
     */
    public String getMethodCallJournalKey();
    
    /**
     * ŏo͂W[ĩ\bh߂vf̃L[ݒ肷B<p>
     * Ŏw肳ꂽL[́A{@link jp.ossc.nimbus.service.journal.Journal#addInfo(String, Object)}̑ƂĎgpB<br>
     *
     * @param key ŏo͂W[ĩ\bh߂vf̃L[
     * @see #getMethodReturnJournalKey()
     */
    public void setMethodReturnJournalKey(String key);
    
    /**
     * ŏo͂W[ĩ\bh߂vf̃L[擾B<p>
     *
     * @return ŏo͂W[ĩ\bh߂vf̃L[
     * @see #setMethodReturnJournalKey(String)
     */
    public String getMethodReturnJournalKey();
}