/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.business;

import jp.ossc.nimbus.core.*;

import jp.ossc.tstruts.action.ejb.*;
import jp.ossc.tstruts.common.InvocationContext;

/**
 * ƖC^Zv^T[rXNXB<p>
 * {@link BusinessInterceptor}̊ȈՎƁAT[rXsT[rXNXłB<br>
 * ̃NX̃TuNX́A{@link BusinessBase#setBusinessInterceptorName(ServiceName)}ŁABusinessBasẽC^Zv^T[rXƂĐݒłB܂A{@link #setNextBusinessInterceptorName(ServiceName)}ŁÃC^Zv^T[rX̎̃C^Zv^T[rXݒłB<br>
 *
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public abstract class BusinessInterceptorServiceBase extends ServiceBase
 implements BusinessInterceptor, BusinessInterceptorServiceBaseMBean{
    
    /**
     * ̃C^Zv^̖OB<p>
     */
    private ServiceName interceptorName;
    
    /**
     * ̃C^Zv^B<p>
     */
    private BusinessInterceptor nextInterceptor;
    
    /**
     * C^ZvgƖT[rXB<p>
     */
    private ServiceName interceptBusinessName;
    
    /**
     * BusinessInterceptorĂяoB<p>
     * BusinessInterceptořĂяȏOɁA{@link #preNext(InvocationContext)}ĂяoB܂ABusinessInterceptořĂяǒŁA{@link #postNext(InvocationContext)}ĂяoB<br>
     * ܂ABusinessInterceptor݂Ȃꍇ́ApreNext(InvocationContext)ApostNext(InvocationContext)sāAĂяo֕ԂB<br>
     *
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖɗOꍇ
     */
    public InvocationContext next(InvocationContext context)
     throws BusinessException{
        InvocationContext ctx = context;
        try{
            ctx = preNext(ctx);
            try{
                if(nextInterceptor != null){
                    final boolean isLocal = ctx.isLocal();
                    try{
                        ctx.setLocal(true);
                        ctx = nextInterceptor.next(ctx);
                    }finally{
                        ctx.setLocal(isLocal);
                    }
                }
            }catch(BusinessException e){
                final BusinessException be = throwBusinessException(ctx, e);
                if(be != null){
                    throw be;
                }
            }catch(RuntimeException e){
                final RuntimeException re = throwRuntimeException(ctx, e);
                if(re != null){
                    throw re;
                }
            }catch(Error err){
                final Error error = throwError(ctx, err);
                if(error != null){
                    throw error;
                }
            }
            ctx = postNext(ctx);
        }finally{
            ctx = finallyNext(ctx);
        }
        return ctx;
    }
    
    public void setNext(BusinessInterceptor interceptor){
        nextInterceptor = interceptor;
    }
    
    public BusinessInterceptor getNext(){
        return nextInterceptor;
    }
    
    /**
     * BusinessInterceptorĂяoOsB<p>
     * BusinessInterceptorĂяoOɕKĂяoB<br>
     * Ă̂ŁATuNXŕKvȏ邱ƁB<br>
     *
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖɗOꍇ
     */
    public InvocationContext preNext(InvocationContext context)
     throws BusinessException{
         return context;
    }
    
    /**
     * BusinessInterceptorĂяo㏈sB<p>
     * BusinessInterceptorĂяoAɍsꂽꍇA܂́A{@link #throwBusinessException}ŗOׂꂽꍇɌĂяoB<br>
     * Ă̂ŁATuNXŕKvȏ邱ƁB<br>
     *
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖɗOꍇ
     */
    public InvocationContext postNext(InvocationContext context)
     throws BusinessException{
         return context;
    }
    
    /**
     * BusinessInterceptorĂяoʁABusinessExceptionthrowꂽꍇ̏sB<p>
     * ߂lŕԂBusinessExceptionthrowBnullԂƁAOthrowꂸ{@link #postNext}ĂяoB<br>
     * Ă̂ŁATuNXŕKvȏ邱ƁB<br>
     *
     * @param context sɕKvȂ̂i[ReLXg
     * @param e BusinessInterceptorĂяoʁAthrowꂽBusinessException
     * @return throwBusinessExceptionB
     */
    public BusinessException throwBusinessException(
        InvocationContext context,
        BusinessException e
    ) throws BusinessException{
        return e;
    }
    
    /**
     * BusinessInterceptorĂяoʁARuntimeExceptionthrowꂽꍇ̏sB<p>
     * ߂lŕԂRuntimeExceptionthrowBnullԂƁAOthrowꂸ{@link #postNext}ĂяoB<br>
     * Ă̂ŁATuNXŕKvȏ邱ƁB<br>
     *
     * @param context sɕKvȂ̂i[ReLXg
     * @param e BusinessInterceptorĂяoʁAthrowꂽRuntimeException
     * @return throwRuntimeExceptionB
     */
    public RuntimeException throwRuntimeException(
        InvocationContext context,
        RuntimeException e
    ) throws BusinessException{
        return e;
    }
    
    /**
     * BusinessInterceptorĂяoʁAErrorthrowꂽꍇ̏sB<p>
     * ߂lŕԂErrorthrowBnullԂƁAOthrowꂸ{@link #postNext}ĂяoB<br>
     * Ă̂ŁATuNXŕKvȏ邱ƁB<br>
     *
     * @param context sɕKvȂ̂i[ReLXg
     * @param error BusinessInterceptorĂяoʁAthrowꂽError
     * @return throwErrorB
     */
    public Error throwError(
        InvocationContext context,
        Error error
    ) throws BusinessException{
        return error;
    }
    
    /**
     * BusinessInterceptorĂяo̍ŏIsB<p>
     * BusinessInterceptorĂяoɕKĂяoB<br>
     * Ă̂ŁATuNXŕKvȏ邱ƁB<br>
     *
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖɗOꍇ
     */
    public InvocationContext finallyNext(InvocationContext context)
     throws BusinessException{
         return context;
    }
    
    public void setNextBusinessInterceptorName(ServiceName interceptor){
        interceptorName = interceptor;
    }
    
    public ServiceName getNextBusinessInterceptorName(){
        return interceptorName;
    }
    
    public void setInterceptBusinessName(ServiceName name){
        interceptBusinessName = name;
    }
    
    public ServiceName getInterceptBusinessName(){
        return interceptBusinessName;
    }
    
    /**
     * Jn̑OsB<p>
     * {@link #setNextBusinessInterceptorName(ServiceName)}Őݒ肳ꂽBusinessInterceptor擾āA{@link #setNext(BusinessInterceptor)}Őݒ肷B<br>
     * 
     * @exception Exception JnŖ肪ċNłȂꍇ
     * @see #createService()
     */
    protected void preStartService() throws Exception{
        super.preStartService();
        if(interceptorName != null){
            final BusinessInterceptor itc
                 = (BusinessInterceptor)ServiceManagerFactory
                    .getServiceObject(interceptorName);
            setNext(itc);
        }
    }
}