/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.business;

import jp.ossc.nimbus.core.*;

/**
 * {@link BusinessBase}NXMBeanC^tF[XB<p>
 *
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 * @see BusinessBase
 */
public interface BusinessBaseMBean
 extends Business, TransactionSupport, BusinessInterceptorServiceBaseMBean{
    
    /**
     * C^Zv^T[rXݒ肷B<p>
     * Őݒ肷T[rX́A{@link BusinessInterceptor}C^tF[XT[rXłKvB<br>
     * ݒ肳ꂽBusinessInterceptorT[rX́AMBeanC^tF[X{@link BusinessBase}{@link BusinessBase#processBusiness(InvocationContext) processBusiness(InvocationContext)}AĂяoOɁA{@link BusinessInterceptor#next(InvocationContext)}ĂяoB<br>
     * ܂AŐݒ肳ꂽBusinessInterceptorT[rX̃`F[̍Ōɂ́ABusinessBaseݒ肳AŌprocessBusiness(InvocationContext)AĂяoB<br>
     * 
     * @param name BusinessInterceptorC^tF[XT[rX̖O
     * @see #getBusinessInterceptorName()
     */
    public void setBusinessInterceptorName(ServiceName name);
    
    /**
     * ݒ肳ĂC^Zv^T[rX̖O擾B<p>
     * 
     * @return {@link BusinessInterceptor}C^tF[XT[rX̃T[rX
     * @see #setBusinessInterceptorName(ServiceName)
     */
    public ServiceName getBusinessInterceptorName();
    
    /**
     * EJBĂяoꍇɎgpEJBt@Ngݒ肷B<p>
     *
     * @param name {@link jp.ossc.nimbus.service.ejb.EJBFactory}C^tF[XT[rX̖O
     * @see #getEJBFactoryName()
     */
    public void setEJBFactoryName(ServiceName name);
    
    /**
     * EJBĂяoꍇɎgpEJBt@Ng̃T[rX擾B<p>
     *
     * @return {@link jp.ossc.nimbus.service.ejb.EJBFactory}C^tF[XT[rX̖O
     * @see #setEJBFactoryName(ServiceName)
     */
    public ServiceName getEJBFactoryName();
}