/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.business;

import javax.ejb.*;
import java.lang.reflect.InvocationTargetException;
import javax.naming.*;
import javax.transaction.*;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.ejb.EJBFactory;

import jp.ossc.tstruts.action.ejb.*;
import jp.ossc.tstruts.action.ejb.facade.*;
import jp.ossc.tstruts.common.InvocationContext;

/**
 * ƖNXB<p>
 * {@link BusinessGroup}ɂăO[sOAĂяoƖNX̊NXłBBusinessGroupɃO[sOƖ́ÃNX̃TuNX쐬ĎB
 * <pre>
 *   public class MyBusiness extends BusinessBase{
 *                     :
 * </pre>
 * TuNXł́A{@link #processBusiness(InvocationContext)}ɍē\ȋƖȂ΂ȂȂBȂȂ΁ÃNX́ANimbusvWFNg̃T[rXՂɂāAPCX^XāAT[rXƂċNÃXbh瓯ɌĂяo\邽߂łB<br>
 * <pre>
 *                     :
 *       protected void processBusiness(InvocationContext context)
 *         throws BusinessException{
 *                         :
 *       }
 *                     :
 * </pre>
 * AAĂяoɂ͕ω鎖̂Ȃ́A\łB̂悤ȐÓÍAANZTigettersetterA܂͂̂ǂ炩jB
 * <pre>
 *                     :
 *       private int timeout;
 *                     :
 *       public void setTimeout(int time){
 *           timeout = time;
 *       }
 *
 *       public int getTimeout(){
 *           return timeout;
 *       }
 *                     :
 * </pre>
 * ANZT́AƖO[v`t@C<attribute>vfŐݒ\łB
 * <pre>
 *   &lt;server&gt;
 *     &lt;manager name="Group1"&gt;
 *               :
 *       &lt;service code="MyBusiness" name="Business1"&gt;
 *         &lt;attribute name="timeout"&gt;100&lt;/attribute&gt;
 *       &lt;/service&gt;
 *               :
 *     &lt;/manager&gt;
 *   &lt;/server&gt;
 * </pre>
 * NimbusT[rXՂ̃T[rXƂĎĂ邽߁AENE~Ep̂S̌_@̎słBꂼA{@link #createService()}A{@link #startService()}A{@link #stopService()}A{@link #destroyService()}I[o[Ch鎖ŎłB<br>
 * <pre>
 *                     :
 *       public void createService(){
 *                       :
 *       }
 *       public void startService(){
 *                       :
 *       }
 *       public void stopService(){
 *                       :
 *       }
 *       public void destroyService(){
 *                       :
 *       }
 *                     :
 * 
 * </pre>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 * @see BusinessGroup
 * @see <a href="doc-files/business-group1.xml">ƖO[v`t@CTv</a>
 * @see <a href="doc-files/nimbus-service.dtd.txt">ƖO[v`t@CDTDiNimbusT[rX`t@Cj</a>
 */
public abstract class BusinessBase extends BusinessInterceptorServiceBase
 implements BusinessBaseMBean{
    
    /**
     * EJBϐJNDIReLXgB<p>
     */
    private static final String JAVA_ENV_KEY = "java:comp/env";
    
    /**
     * gUNV^Cv RequiredB<p>
     * gUNVȂΐVJnBΉȂB
     */
    private static final int REQUIRED_VALUE = 0;
    
    /**
     * gUNV^Cv RequiresNewB<p>
     * gUNVȂΐVJnBsuspendĐVJnB
     */
    private static final int REQUIRESNEW_VALUE = 1;
    
    /**
     * gUNV^Cv SupportsB<p>
     * gUNVȂΉȂBΒ~B
     */
    private static final int SUPPORTS_VALUE = 2;
    
    /**
     * gUNV^Cv MandatoryB<p>
     * gUNVȂ΃G[BΉȂB
     */
    private static final int MANDATORY_VALUE = 3;
    
    /**
     * gUNV^Cv NeverB<p>
     * gUNVȂΉȂB΃G[B
     */
    private static final int NEVER_VALUE = 4;
    
    /**
     * gUNV^Cv NotSupportedB<p>
     * gUNVĂAȂĂȂB
     */
    private static final int NOT_SUPPORTED_VALUE = 5;
    
    /**
     * TransactionManagerJNDIB<p>
     * J2EE̎dlŁA\񂳂ĂJNDIłB
     */
    private static final String TRANSACTION_MANAGER_JNDI_NAME
         = "java:/TransactionManager";
    
    /**
     * gUNV^Cv̕\B<p>
     * 
     * @see TransactionSupport#REQUIRED
     * @see TransactionSupport#REQUIRESNEW
     * @see TransactionSupport#SUPPORTS
     * @see TransactionSupport#MANDATORY
     * @see TransactionSupport#NEVER
     * @see TransactionSupport#NOT_SUPPORTED
     */
    private String transactionAttribute = NOT_SUPPORTED;
    
    /**
     * gUNV^Cv̐l\B<p>
     */
    private int transactionType = NOT_SUPPORTED_VALUE;
    
    /**
     * gUNV^CAEgB<p>
     */
    private int transactionTimeout = -1;
    
    /**
     * O[sOĂƖO[vB<p>
     */
    private BusinessGroup group;
    
    /**
     * O[sOĂƖO[vEJBContextB<p>
     */
    private EJBContext context;
    
    /**
     * gUNVs߂lookupTransactionManagerB<p>
     */
    private TransactionManager tranManager;
    
    /**
     * OɎsC^Zv^̃T[rXB<p>
     */
    private ServiceName interceptorName;
    
    /**
     * OɎsC^Zv^B<p>
     */
    private BusinessInterceptor interceptor;
    
    /**
     * EJBĂяoɎgpEJBt@Ng̃T[rXB<p>
     */
    private ServiceName ejbFactoryName;
    
    /**
     * EJBĂяoɎgpEJBt@NgB<p>
     */
    private EJBFactory ejbFactory;
    
    public void setBusinessGroup(BusinessGroup group){
        this.group = group;
    }
    
    public BusinessGroup getBusinessGroup(){
        return group;
    }
    
    public void setEJBContext(EJBContext context){
        this.context = context;
    }
    
    public EJBContext getEJBContext(){
        return context;
    }
    
    public void setBusinessInterceptorName(ServiceName name){
        interceptorName = name;
    }
    
    public ServiceName getBusinessInterceptorName(){
        return interceptorName;
    }
    
    public void setBusinessInterceptor(BusinessInterceptor interceptor){
        this.interceptor = interceptor;
    }
    
    public void setEJBFactoryName(ServiceName name){
        this.ejbFactoryName = name;
    }
    
    public ServiceName getEJBFactoryName(){
        return ejbFactoryName;
    }
    
    public String getBusinessGroupName(){
        if(group == null){
            return getServiceManagerName();
        }
        try{
            return group.getGroupName();
        }catch(java.rmi.RemoteException e){
            return getServiceManagerName();
        }
    }
    
    public String getBusinessName(){
        return getServiceName();
    }
    
    /**
     * ƖsB<p>
     * ƖT[rX񋟉\ǂ`FbNsAss\ȏꍇ́AOthrow܂Bs\ȏꍇ́A{@link #setTransactionAttribute(String)}Őݒ肳ꂽgUNV^Cvɏ]āAgUNV̐sB܂AgUNVVKɊJnꍇ́A{@link #setTransactionTimeout(int)}ɏ]āAgUNṼ^CAEgݒ肷B<br>
     * ̌A{@link #setBusinessInterceptor(BusinessInterceptor)}Őݒ肳ꂽC^Zv^{@link BusinessInterceptor#next(InvocationContext)}ĂяoAC^Zv^ɏϏBC^Zv^`F[̍Ōɂ́ÃCX^Xݒ肳ĂA{@link #preNext(InvocationContext)}ŁA{@link #processBusiness(InvocationContext)}ĂяoBOȂ΁AgUNṼR~bgsBOꍇ́AgUNṼ[obNsBAÃIuWFNgŃgUNVJnĂȂꍇ́AR~bgA[obN͍sȂB̌A{@link #setNextBusinessInterceptorName(ServiceName)}Őݒ肳ꂽC^Zv^next(InvocationContext)ĂяoAC^Zv^ɏϏAŌ{@link #postNext(InvocationContext)}Ō㏈sB<br>
     * 
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖɗOꍇ
     * @exception IllegalBusinessStateException ̋ƖIuWFNgT[rXƂĎsłȂԂɂꍇ
     * @see TransactionSupport
     * @see BusinessInterceptor
     */
    public final InvocationContext work(InvocationContext context)
     throws BusinessException, BusinessSystemException{
        final int state = getState();
        switch(state){
        case STARTED:
            break;
        case CREATING:
        case CREATED:
        case STARTING:
        case STOPPING:
        case STOPPED:
        case DESTROYING:
        case DESTROYED:
        case FAILED:
        case UNKNOWN:
        default:
            throw new IllegalBusinessStateException(
                getBusinessGroupName(),
                getBusinessName(),
                getStateString(),
                state
            );
        }
        
        try{
            InvocationContext ctx = null;
            InvocationContext preCtx = null;
            if(context.isLocal()){
                preCtx = context;
                ctx = (InvocationContext)preCtx.clone();
            }else{
                preCtx = context;
                ctx = context;
            }
            Transaction oldTransaction = null;
            Transaction newTransaction = null;
            switch(transactionType){
            case REQUIRED_VALUE:
                oldTransaction = tranManager.getTransaction();
                if(oldTransaction == null){
                    tranManager.begin();
                    newTransaction = tranManager.getTransaction();
                }
                if(transactionTimeout != -1 && newTransaction != null){
                    tranManager.setTransactionTimeout(transactionTimeout);
                }
                try{
                    ctx = interceptor.next(ctx);
                }catch(BusinessException be){
                    if(newTransaction != null){
                        newTransaction.rollback();
                        ctx = preCtx;
                    }
                    throw be;
                }catch(RuntimeException re){
                    if(newTransaction != null){
                        newTransaction.rollback();
                        ctx = preCtx;
                    }
                    throw re;
                }
                if(newTransaction != null){
                    newTransaction.commit();
                }
                break;
            case REQUIRESNEW_VALUE:
                oldTransaction = tranManager.suspend();
                try{
                    tranManager.begin();
                    newTransaction = tranManager.getTransaction();
                    if(transactionTimeout != -1){
                        tranManager.setTransactionTimeout(transactionTimeout);
                    }
                    try{
                        ctx = interceptor.next(ctx);
                    }catch(BusinessException be){
                        newTransaction.rollback();
                        ctx = preCtx;
                        throw be;
                    }catch(RuntimeException re){
                        newTransaction.rollback();
                        ctx = preCtx;
                        throw re;
                    }
                    newTransaction.commit();
                }finally{
                    if(oldTransaction != null){
                        tranManager.resume(oldTransaction);
                    }
                }
                break;
            case NOT_SUPPORTED_VALUE:
                oldTransaction = tranManager.suspend();
                try{
                    ctx = interceptor.next(ctx);
                }finally{
                    if(oldTransaction != null){
                        tranManager.resume(oldTransaction);
                    }
                }
                break;
            case MANDATORY_VALUE:
                oldTransaction = tranManager.getTransaction();
                if(oldTransaction == null){
                    throw new BusinessException(
                        getBusinessGroupName(),
                        getBusinessName(),
                        new TransactionRequiredException(
                            "Require transaction."
                        )
                    );
                }
                ctx = interceptor.next(ctx);
                break;
            case NEVER_VALUE:
                oldTransaction = tranManager.getTransaction();
                if(oldTransaction != null){
                    throw new BusinessException(
                        getBusinessGroupName(),
                        getBusinessName(),
                        "Must not allow transaction."
                    );
                }
                ctx = interceptor.next(ctx);
                break;
            case SUPPORTS_VALUE:
            default:
                ctx = interceptor.next(ctx);
            }
            return ctx;
        }catch(HeuristicMixedException e){
            throw new BusinessTransactionManagerException(
                getBusinessGroupName(),
                getBusinessName(),
                e
            );
        }catch(HeuristicRollbackException e){
            throw new BusinessTransactionManagerException(
                getBusinessGroupName(),
                getBusinessName(),
                e
            );
        }catch(NotSupportedException e){
            throw new BusinessTransactionManagerException(
                getBusinessGroupName(),
                getBusinessName(),
                e
            );
        }catch(RollbackException e){
            throw new BusinessTransactionManagerException(
                getBusinessGroupName(),
                getBusinessName(),
                e
            );
        }catch(InvalidTransactionException e){
            throw new BusinessTransactionManagerException(
                getBusinessGroupName(),
                getBusinessName(),
                e
            );
        }catch(SystemException e){
            throw new BusinessTransactionManagerException(
                getBusinessGroupName(),
                getBusinessName(),
                e
            );
        }
    }
    
    /**
     * ƖO[v̋ƖĂяoB<p>
     *
     * @param name ĂяoƖ
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖsɗOꍇ
     * @exception BusinessNotFoundException ĂяoƖƖO[vŌȂꍇ
     */
    protected InvocationContext call(String name, InvocationContext context)
     throws BusinessException, BusinessSystemException{
        Business business = null;
        try{
            business = (Business)manager.getServiceObject(name);
        }catch(ServiceNotFoundException e){
            throw new BusinessNotFoundException(getBusinessGroupName(), name);
        }
        InvocationContext ctx = context;
        final boolean isLocal = ctx.isLocal();
        try{
            ctx.setLocal(true);
            ctx = business.work(ctx);
        }finally{
            ctx.setLocal(isLocal);
        }
        return ctx;
        
// FacadeEJBoRŌĂяoB
//        // TODO TStrutsJNDINCAggH
//        InvocationContext ctx = context;
//        final boolean isLocal = ctx.isLocal();
//        final BusinessGroup group = getBusinessGroup();
//        try{
//            ctx = group.doBusiness(name, ctx);
//        }catch(java.rmi.RemoteException e){
//            throw new BusinessException(getServiceName(), e);
//        }finally{
//            ctx.setLocal(isLocal);
//        }
//        return ctx;
    }
    
    /**
     * VM̑ƖO[v̋ƖĂяoB<p>
     *
     * @param group ĂяoƖO[sOĂƖO[v
     * @param business ĂяoƖ
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖsɗOꍇ
     * @exception BusinessSystemException ĂяoBusinessŃVXeOꍇ
     */
    protected InvocationContext callLocally(
        String group,
        String business,
        InvocationContext context
    ) throws BusinessException, BusinessSystemException{
        final ServiceManager manager = ServiceManagerFactory.findManager(group);
        if(manager == null){
            throw new BusinessGroupNotFoundException(group);
        }
        Business busi = null;
        try{
            busi = (Business)manager.getServiceObject(business);
        }catch(ServiceNotFoundException e){
            throw new BusinessNotFoundException(group, business);
        }
        InvocationContext ctx = context;
        final boolean isLocal = ctx.isLocal();
        try{
            ctx.setLocal(true);
            ctx = busi.work(ctx);
        }finally{
            ctx.setLocal(isLocal);
        }
        return ctx;
     }
    
    /**
     * ƖO[v̋ƖĂяoB<p>
     * {@link #setEJBFactoryName(ServiceName)}Őݒ肳ꂽ{@link EJBFactory}{@link EJBFactory#get(String, Class, Class, Class[], Object[]) get(String name, Class homeType, Class remoteType, Class[] paramTypes, Object[] params)}ɈŎw肵ƖO[vnāAƖO[vEJB擾B]āAŎw肷ƖO[v́AEJBFactory̐ݒɈˑB<br>
     * <p>
     * EJBFactoryݒ肳ĂȂꍇɂ́AJNDI"java:comp/env"ReLXglookupB]āAŎw肷ƖO[v́A̋ƖNXO[sO{@link BusinessGroup}́AEJBfvCgLqqejb-jar.xml&lt;ejb-ref&gt;vfŎw肵ĂKvB<br>
     * <pre>
     *   &lt;ejb-ref&gt;
     *     &lt;ejb-ref-name&gt;Group2&lt;/ejb-ref-name&gt;
     *     &lt;ejb-ref-type&gt;Session&lt;/ejb-ref-type&gt;
     *     &lt;home&gt;jp.ossc.tstruts.action.ejb.facade.BusinessGroupHome&lt;/home&gt;
     *     &lt;remote&gt;jp.ossc.tstruts.action.ejb.facade.BusinessGroup&lt;/remote&gt;
     *   &lt;/ejb-ref&gt;
     * </pre>
     * 
     * @param group ĂяoƖO[sOĂƖO[v
     * @param business ĂяoƖ
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖsɗOꍇ
     * @exception BusinessSystemException EJBt[[NƂĂ̗O
     * @see BusinessGroup
     * @see <a href="../facade/doc-files/ejb-jar.xml">ejb-jar.xmlTv</a>
     */
    protected InvocationContext call(
        String group,
        String business,
        InvocationContext context
    ) throws BusinessException, BusinessSystemException {
        
        // TODO TStrutsJNDINCAggH
        BusinessGroup grp = null;
        if(ejbFactory == null){
            try{
                final InitialContext ctx = new InitialContext();
                final BusinessGroupHome home
                     = (BusinessGroupHome)getEnvObject(group);
                grp = home.create();
            }catch(NameNotFoundException e){
                throw new BusinessGroupNotFoundException(group,e);
            }catch(NamingException e){
                throw new BusinessGroupNotFoundException(group,e);
            }catch(CreateException e){
                throw new BusinessGroupNotFoundException(group,e);
            }catch(java.rmi.RemoteException e){
                throw new BusinessGroupNotFoundException(group,e);
            }
        }else{
            try{
                grp = (BusinessGroup)ejbFactory.get(
                    group,
                    BusinessGroupHome.class,
                    BusinessGroup.class,
                    null,
                    null
                );
            }catch(NameNotFoundException e){
                throw new BusinessGroupNotFoundException(group,e);
            }catch(NamingException e){
                throw new BusinessGroupNotFoundException(group,e);
            }catch(CreateException e){
                throw new BusinessGroupNotFoundException(group,e);
            }catch(NoSuchMethodException e){
                throw new BusinessGroupNotFoundException(group,e);
            }catch(IllegalAccessException e){
                throw new BusinessGroupNotFoundException(group,e);
            }catch(InvocationTargetException e){
                throw new BusinessGroupNotFoundException(group,e);
            }
        }
        
        String groupServiceName = null;
        try{
            groupServiceName = grp.getGroupName();
        }catch(java.rmi.RemoteException e){
            throw new BusinessGroupNotFoundException(getBusinessGroupName(),e);
        }
        
        final ServiceManager manager
             = ServiceManagerFactory.findManager(groupServiceName);
        InvocationContext ctx = context;
        final boolean isLocal = ctx.isLocal();
        if(manager != null){
            Business busi = null; 
            try{
                busi = (Business)manager.getServiceObject(business);
            }catch(ServiceNotFoundException e){
                throw new BusinessNotFoundException(groupServiceName, business);
            }
            try{
                ctx.setLocal(true);
                ctx = busi.work(ctx);
            }finally{
                ctx.setLocal(isLocal);
            }
        }else{
            try{
                ctx.setLocal(true);
                ctx = grp.doBusiness(business, ctx);
            }catch(java.rmi.RemoteException e){
                throw new BusinessNotFoundException(
                    getBusinessGroupName(),
                    getBusinessName(),
                    e
                );
            }finally{
                ctx.setLocal(isLocal);
            }
        }
        return ctx;
    }
    
    /**
     * ̏sB<p>
     * Ă̂ŁAKvΎĂ悢B<br>
     * 
     * @exception Exception Ŗ肪ĐłȂꍇ
     */
    public void createService() throws Exception{
    }
    
    /**
     * N̑OsB<p>
     * {@link #setBusinessInterceptorName(ServiceName)}Őݒ肳ꂽBusinessInterceptor擾B<br>
     * TransactionManagerlookupB<br>
     * gUNV^CvA{@link TransactionSupport#NOT_SUPPORTED}łȂATransactionManagerȂꍇ́AOthrowB
     * 
     * @exception Exception NŖ肪ċNłȂꍇ
     * @see #startService()
     */
    protected void preStartService() throws Exception{
        super.preStartService();
        if(interceptorName != null){
            final BusinessInterceptor itc
                 = (BusinessInterceptor)ServiceManagerFactory
                    .getServiceObject(interceptorName);
            if(itc == null){
                throw new Exception(interceptorName + " not found!");
            }
            setBusinessInterceptor(itc);
            
            final ServiceName myName = new ServiceName(
                getServiceManagerName(),
                getServiceName()
            );
            
            BusinessInterceptor pre = interceptor;
            BusinessInterceptor next = null;
            pre.setInterceptBusinessName(myName);
            while((next = pre.getNext()) != null){
                next.setInterceptBusinessName(myName);
                pre = next;
            }
            pre.setNext(this);
        }else{
            setBusinessInterceptor(this);
        }
        if(ejbFactoryName != null){
            ejbFactory = (EJBFactory)ServiceManagerFactory
                .getServiceObject(ejbFactoryName);
        }
        
        try{
            final Context context = new InitialContext();
            tranManager = (TransactionManager)context.lookup(
                TRANSACTION_MANAGER_JNDI_NAME
            );
        }catch(NamingException e){
            tranManager = null;
            if(transactionType != NOT_SUPPORTED_VALUE){
                throw e;
            }
        }
    }
    
    /**
     * N̏sB<p>
     * Ă̂ŁAKvΎĂ悢B<br>
     * 
     * @exception Exception NŖ肪ċNłȂꍇ
     */
    public void startService() throws Exception{
    }
    
    /**
     * ~̏sB<p>
     * Ă̂ŁAKvΎĂ悢B<br>
     * 
     * @exception Exception ~Ŗ肪ꍇ
     */
    public void stopService() throws Exception{
    }
    
    /**
     * p̏sB<p>
     * Ă̂ŁAKvΎĂ悢B<br>
     * 
     * @exception Exception pŖ肪ꍇ
     */
    public void destroyService() throws Exception{
    }
    
    /**
     * ƖsB<p>
     * TuNX́Ã\bhċƖsKvB<br>
     * {@link #work(InvocationContext)}ɌĂяo܂B
     * 
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖɗOꍇ
     * @see #work(InvocationContext)
     */
    protected abstract InvocationContext processBusiness(
        InvocationContext context
    ) throws BusinessException;
    
    /**
     * gUNV^Cvݒ肷B<p>
     *
     * @param type gUNV^Cv
     * @exception IllegalArgumentException `ȃgUNV^Cvw肵ꍇ
     * @see <a href="doc-files/business-group1.xml">ƖO[v`t@CTv</a>
     * @see TransactionSupport#REQUIRED
     * @see TransactionSupport#REQUIRESNEW
     * @see TransactionSupport#SUPPORTS
     * @see TransactionSupport#MANDATORY
     * @see TransactionSupport#NEVER
     * @see TransactionSupport#NOT_SUPPORTED
     * @see #getTransactionAttribute()
     */
    public void setTransactionAttribute(String type)
     throws IllegalArgumentException{
        if(type == null || type.length() == 0){
            throw new IllegalArgumentException("Invalid type : " + type);
        }else if(REQUIRED.equals(type)){
            transactionType = REQUIRED_VALUE;
        }else if(REQUIRESNEW.equals(type)){
            transactionType = REQUIRESNEW_VALUE;
        }else if(SUPPORTS.equals(type)){
            transactionType = SUPPORTS_VALUE;
        }else if(MANDATORY.equals(type)){
            transactionType = MANDATORY_VALUE;
        }else if(NEVER.equals(type)){
            transactionType = NEVER_VALUE;
        }else if(NOT_SUPPORTED.equals(type)){
            transactionType = NOT_SUPPORTED_VALUE;
        }else{
            throw new IllegalArgumentException("Invalid type : " + type);
        }
        transactionAttribute = type;
    }
    
    public String getTransactionAttribute(){
        return transactionAttribute;
    }
    
    /**
     * gUNV^CAEgݒ肷B<p>
     * Pʂ́AbŎw肷B<br>
     * Ŏw肵gUNV^CAEǵA{@link #work(InvocationContext)}ŁAgUNV^Cvɏ]Đݒ肳Bwork(InvocationContext)ŃgUNVꂽꍇ̂݁AgUNVɐݒ肳B<br>
     *
     * @param seconds gUNV^CAEg[s]
     * @see #getTransactionTimeout()
     */
    public void setTransactionTimeout(int seconds){
        transactionTimeout = seconds;
    }
    
    /**
     * gUNV^CAEg擾B<p>
     * Pʂ́AbłB<br>
     *
     * @return gUNV^CAEg[s]
     * @see #setTransactionTimeout(int)
     */
    public int getTransactionTimeout(){
        return transactionTimeout;
    }
    
    /**
     * BusinessInterceptorĂяoOsB<p>
     * {@link #processBusiness(InvocationContext)}ĂяoB<br>
     *
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖɗOꍇ
     */
    public final InvocationContext preNext(InvocationContext context)
     throws BusinessException{
         return processBusiness(context);
    }
    
    /**
     * EJBϐReLXgAw肳ꂽÕIuWFNg擾B<p>
     *
     * @param name EJBϐReLXg擾IuWFNgJNDI
     * @return EJBϐReLXg擾IuWFNgB
     * @exceptin NamingException w肳ꂽJNDĨIuWFNgAEJBϐReLXgɌȂꍇ
     */
    private static Object getEnvObject(String name) throws NamingException{
        Object obj = null;
        final Context context = new InitialContext();
        final Context env = (Context)context.lookup(JAVA_ENV_KEY);
        obj = env.lookup(name);
        return obj;
    }
}