/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb;

/**
 * ƖsłȂԂł鎖OB<p>
 * ƖĂяoɁAƖsłȂԂɂꍇthrow܂B<br>
 *
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public class IllegalBusinessStateException extends BusinessSystemException{
    
    private static final String C_STATE_MSG = ", Business state : ";
	private static final String C_GROUP_NAME = "Business name : ";
	/**
     * Ɩ̏Ԃ\B<p>
     *
     * @see jp.ossc.nimbus.core.Service#STATES jp.ossc.nimbus.core.Service.STATES
     */
    private final String state;
    
    /**
     * Ɩ̏Ԃ\lB<p>
     *
     * @see jp.ossc.nimbus.core.Service#CREATING jp.ossc.nimbus.core.Service.CREATING
     * @see jp.ossc.nimbus.core.Service#CREATED jp.ossc.nimbus.core.Service.CREATED
     * @see jp.ossc.nimbus.core.Service#STARTING jp.ossc.nimbus.core.Service.STARTING
     * @see jp.ossc.nimbus.core.Service#STARTED jp.ossc.nimbus.core.Service.STARTED
     * @see jp.ossc.nimbus.core.Service#STOPPING jp.ossc.nimbus.core.Service.STOPPING
     * @see jp.ossc.nimbus.core.Service#STOPPED jp.ossc.nimbus.core.Service.STOPPED
     * @see jp.ossc.nimbus.core.Service#DESTROYING jp.ossc.nimbus.core.Service.DESTROYING
     * @see jp.ossc.nimbus.core.Service#DESTROYED jp.ossc.nimbus.core.Service.DESTROYED
     * @see jp.ossc.nimbus.core.Service#FAILED jp.ossc.nimbus.core.Service.FAILED
     * @see jp.ossc.nimbus.core.Service#UNKNOWN jp.ossc.nimbus.core.Service.UNKNOWN
     */
    private final int stateValue;
    
    /**
     * ĂяoƖAƖ̏ԂOIuWFNg𐶐B<p>
     *
     * @param group ƖO[v
     * @param business Ɩ
     * @param state Ɩ̏Ԃ
     * @param stateValue Ɩ̏Ԃl
     * @see jp.ossc.nimbus.core.Service#STATES jp.ossc.nimbus.core.Service.STATES
     * @see jp.ossc.nimbus.core.Service#CREATING jp.ossc.nimbus.core.Service.CREATING
     * @see jp.ossc.nimbus.core.Service#CREATED jp.ossc.nimbus.core.Service.CREATED
     * @see jp.ossc.nimbus.core.Service#STARTING jp.ossc.nimbus.core.Service.STARTING
     * @see jp.ossc.nimbus.core.Service#STARTED jp.ossc.nimbus.core.Service.STARTED
     * @see jp.ossc.nimbus.core.Service#STOPPING jp.ossc.nimbus.core.Service.STOPPING
     * @see jp.ossc.nimbus.core.Service#STOPPED jp.ossc.nimbus.core.Service.STOPPED
     * @see jp.ossc.nimbus.core.Service#DESTROYING jp.ossc.nimbus.core.Service.DESTROYING
     * @see jp.ossc.nimbus.core.Service#DESTROYED jp.ossc.nimbus.core.Service.DESTROYED
     * @see jp.ossc.nimbus.core.Service#FAILED jp.ossc.nimbus.core.Service.FAILED
     * @see jp.ossc.nimbus.core.Service#UNKNOWN jp.ossc.nimbus.core.Service.UNKNOWN
     */
    public IllegalBusinessStateException(
        String group,
        String business,
        String state,
        int stateValue
    ){
        this(group, business, state, stateValue, null);
    }
    
    /**
     * ĂяoƖAƖ̏ԁAbZ[WOIuWFNg𐶐B<p>
     *
     * @param name Ɩ
     * @param state Ɩ̏Ԃ
     * @param stateValue Ɩ̏Ԃl
     * @param message bZ[W
     * @see jp.ossc.nimbus.core.Service#STATES jp.ossc.nimbus.core.Service.STATES
     * @see jp.ossc.nimbus.core.Service#CREATING jp.ossc.nimbus.core.Service.CREATING
     * @see jp.ossc.nimbus.core.Service#CREATED jp.ossc.nimbus.core.Service.CREATED
     * @see jp.ossc.nimbus.core.Service#STARTING jp.ossc.nimbus.core.Service.STARTING
     * @see jp.ossc.nimbus.core.Service#STARTED jp.ossc.nimbus.core.Service.STARTED
     * @see jp.ossc.nimbus.core.Service#STOPPING jp.ossc.nimbus.core.Service.STOPPING
     * @see jp.ossc.nimbus.core.Service#STOPPED jp.ossc.nimbus.core.Service.STOPPED
     * @see jp.ossc.nimbus.core.Service#DESTROYING jp.ossc.nimbus.core.Service.DESTROYING
     * @see jp.ossc.nimbus.core.Service#DESTROYED jp.ossc.nimbus.core.Service.DESTROYED
     * @see jp.ossc.nimbus.core.Service#FAILED jp.ossc.nimbus.core.Service.FAILED
     * @see jp.ossc.nimbus.core.Service#UNKNOWN jp.ossc.nimbus.core.Service.UNKNOWN
     */
    public IllegalBusinessStateException(
        String group,
        String business,
        String state,
        int stateValue,
        String message
    ){
        super(group,business);
        this.state = state;
        this.stateValue = stateValue;
    }
    
    /**
     * Ɩ̏Ԃ擾B<p>
     *
     * @return Ɩ̏Ԃ
     * @see jp.ossc.nimbus.core.Service#STATES jp.ossc.nimbus.core.Service.STATES
     */
    public String getStateString(){
        return state;
    }
    
    /**
     * Ɩ̏Ԃl擾B<p>
     *
     * @return Ɩ̏Ԃl
     * @see jp.ossc.nimbus.core.Service#CREATING jp.ossc.nimbus.core.Service.CREATING
     * @see jp.ossc.nimbus.core.Service#CREATED jp.ossc.nimbus.core.Service.CREATED
     * @see jp.ossc.nimbus.core.Service#STARTING jp.ossc.nimbus.core.Service.STARTING
     * @see jp.ossc.nimbus.core.Service#STARTED jp.ossc.nimbus.core.Service.STARTED
     * @see jp.ossc.nimbus.core.Service#STOPPING jp.ossc.nimbus.core.Service.STOPPING
     * @see jp.ossc.nimbus.core.Service#STOPPED jp.ossc.nimbus.core.Service.STOPPED
     * @see jp.ossc.nimbus.core.Service#DESTROYING jp.ossc.nimbus.core.Service.DESTROYING
     * @see jp.ossc.nimbus.core.Service#DESTROYED jp.ossc.nimbus.core.Service.DESTROYED
     * @see jp.ossc.nimbus.core.Service#FAILED jp.ossc.nimbus.core.Service.FAILED
     * @see jp.ossc.nimbus.core.Service#UNKNOWN jp.ossc.nimbus.core.Service.UNKNOWN
     */
    public int getState(){
        return stateValue;
    }
    
    /**
     * bZ[W擾B<p>
     * bZ[WARXgN^ŖIɎw肳Ȃꍇ́AƖƋƖ̏ԂbZ[WԂB<br>
     * 
     * @return bZ[W
     */
    public String getMessage(){
        String message = super.getMessage();
        if(message == null){
            final StringBuffer buf = new StringBuffer();
            message = buf.append(C_GROUP_NAME)
                .append(this.getBusinessGroupName()).append('#').append(this.getBusinessName())
                .append(C_STATE_MSG).append(state).toString();
        }
        return message;
    }
}