/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.jexl.Expression;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.tstruts.config.CacheKeyConfig;
import jp.ossc.tstruts.config.ForwardValueConfig;
import jp.ossc.tstruts.config.SelectForwardConfig;
import jp.ossc.tstruts.config.SubModuleConfigImpl;
import jp.ossc.tstruts.config.SystemConfig;
import jp.ossc.tstruts.config.TileDefinitionConfig;
import jp.ossc.tstruts.config.TStrutsActionForward;
import jp.ossc.tstruts.config.TilePutConfigBase;
import jp.ossc.tstruts.common.InvocationContext;
import jp.ossc.tstruts.cache.CacheEntry;
import jp.ossc.tstruts.cache.ActionCache;
import jp.ossc.tstruts.cache.CacheKey;
import jp.ossc.tstruts.cache.CacheServletResponse;
import jp.ossc.tstruts.action.ExtendActionMapping;
import jp.ossc.tstruts.action.forward.ForwardContext;
import jp.ossc.tstruts.action.transaction.TransactionControl;

/**
 * TStrutspRequestProcessorgB<p>
 * TStrutst[[NŁANGXgPʂŕKvȏsB<br>
 *
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public class ExtendRequestProcessor extends RequestProcessor {
	private static final Log log =
		LogFactory.getLog(ExtendRequestProcessor.class);

	/**
	 * LbṼL[ɃNGXgP[ǉۂ̃p[^
	 */
	public static final String TILES_LOCALE_CACHE_KEY =
		"jp.ossc.tstruts.tiles.Locale";

	/**
	 * GlobalCacheServicẽT[rXB
	 * ݒ肳ĂȂnull
	 */
	protected ServiceName globalCacheServiceName = null;
	
	/**
	 * SessionCacheHolder̃T[rXB
	 * ݒ肳ĂȂnull
	 */
	protected ServiceName sessionCacheHolderName = null;

	/**
	 * SystemConfigvOCւ̎Q
	 */
	private SystemConfig systemConfig = null;
	
	/**
	 * LbṼL[ɃNGXgP[IɊ܂߂邩ۂ
	 */
	private boolean autoLocale = false;
	
	/**
	 * dMh~VXeZbVƂɋL^郊NGXg̍őێ
	 */
	private int transactedMax = 0;

	/* (non-Javadoc)
	 * @see org.apache.struts.action.RequestProcessor#init(org.apache.struts.action.ActionServlet, org.apache.struts.config.ModuleConfig)
	 */
	public void init(ActionServlet servlet, ModuleConfig config)
		throws ServletException {
		super.init(servlet, config);

		// SystemConfigvOCServletContextɂԂ牺ĂB
		// ƁANGXgƂThreadContextInitializeFilterSystemConfig
		// setLocalĂсAThreadLocalSystemConfigZbgB
		ServletContext context = servlet.getServletContext();
		systemConfig =
			(SystemConfig) context.getAttribute(MyGlobals.SYSTEM_CONFIG_KEY);

		// ^C̃LbVL[ɃNGXgP[Iɒǉ邩ǂ
		// ݒ擾
		String str =
			(String) systemConfig.getProperty(
				MyGlobals.CACHE_AUTO_LOCALE_PROPERTY);
		if (str != null) {
			autoLocale =
				str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("true");
			log.info("CacheAutoLocale:" + (autoLocale ? "enabled" : "disabled"));
		}

		// dMh~VXeZbVƂɕێ郊NGXg̐擾
		String t = context.getInitParameter("transactedMax");
		if (t != null) {
			transactedMax = Integer.parseInt(t);
			log.debug("transactedMax value in web.xml : " + transactedMax);
		} else {
			log.info("transactedMax value is not set.");
		}

		// ActionCacheVXeGlobalCacheT[rX擾
		try {
			globalCacheServiceName =
				systemConfig.getServiceNameProperty(
					MyGlobals.GLOBAL_ACTION_CACHE_SERVICE_NAME);
			if (globalCacheServiceName != null) {
				// T[rX擾Ă݂
				ServiceManagerFactory.getServiceObject(globalCacheServiceName);
			} else {
				log.debug("Tiles global cache service is not configured.");
			}
		} catch (ServiceNotFoundException e) {
			globalCacheServiceName = null;
			log.error("Tiles global cache service is not found.", e);
		}

		// ActionCacheVXeSessionCacheHolderT[rX擾
//		try {
//			sessionCacheHolderName =
//				systemConfig.getServiceNameProperty(
//					MyGlobals.SESSION_CACHE_HOLDER_SERVICE_NAME);
//			if (sessionCacheHolderName != null) {
//				// T[rX擾Ă݂
//				ServiceManagerFactory.getServiceObject(sessionCacheHolderName);
//			} else {
//				log.debug("Tiles session cache service is not configured.");
//			}
//		} catch (ServiceNotFoundException e) {
//			sessionCacheHolderName = null;
//			log.error("Tiles session cache service is not found.", e);
//		}
	}

	/* ( Javadoc)
	 * @see org.apache.struts.action.RequestProcessor#process(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void process(
		HttpServletRequest request,
		HttpServletResponse response)
		throws IOException, ServletException {

		systemConfig.setLocal();
		// Wrap multipart requests with a special wrapper
		request = processMultipart(request);

		// Identify the path component we will use to select a mapping
		String path = processPath(request, response);
		if (path == null) {
			return;
		}
		if (log.isDebugEnabled()) {
			log.debug(
				"Processing a '"
					+ request.getMethod()
					+ "' for path '"
					+ path
					+ "' req:" + request);
		}

		// Select a Locale for the current user if requested
		processLocale(request, response);

		// Set the content type and no-caching headers if requested
		processContent(request, response);
		processNoCache(request, response);

		// General purpose preprocessing hook
		if (!processPreprocess(request, response)) {
			return;
		}

		// Identify the mapping for this request
		ActionMapping mapping = processMapping(request, response, path);
		if (mapping == null) {
			return;
		}

		// Check for any role required to perform this action
		if (!processRoles(request, response, mapping)) {
			return;
		}

		// Process any ActionForm bean related to this request
		ActionForm form = processActionForm(request, response, mapping);
		processPopulate(request, response, form, mapping);

		// ActioñLbVʂ擾
		int cacheType = ((ExtendActionMapping) mapping).getCacheType();

		if (cacheType == ExtendActionMapping.CACHE_TYPE_NOCACHE) {
			// ActionLbV\łȂƂ́Aʏ폈sďIB
			if (!processValidate(request, response, form, mapping)) {
				return;
			}
		
			processMainProcess(request, response, mapping, form);
			return;
		}
	
		HttpServletResponse originalResponse = null;
		ActionCache cache = null;

		// LbV\ȂAcacheɂAActionCacheT[rX擾
		switch (cacheType) {
		case ExtendActionMapping.CACHE_TYPE_GLOBAL:
			if (globalCacheServiceName != null) {
				cache = (ActionCache)ServiceManagerFactory.getServiceObject(
					globalCacheServiceName);
			}
			break;
//		case ExtendActionMapping.CACHE_TYPE_SESSION:
//			if (sessionCacheHolderName != null) {
//				holder = (ActionCache)ServiceManagerFactory.getServiceObject(
//					sessionCacheHolderName);
//			}
//			break;
		default:
			log.error("Invalid cache type! Action:" +  mapping.getPath());
			break;
		}

		if (cache == null) {
			// ActionCacheT[rX擾łȂƂALbVłȂ̂
			// ʂɏďIB
			if (!processValidate(request, response, form, mapping)) {
				return;
			}
		
			processMainProcess(request, response, mapping, form);
			return;
		}

		// ActionCacheT[rX擾łALbVɃRec
		// ɃLbVĂ邩ǂ`FbNA
		// LbVĂALbVԂB

		// ActionCacheCacheT[rX邽߂̃pX쐬
		String cachePath = moduleConfig.getPrefix() + path;

		CacheKey cacheKey = createCacheKey(cache, cachePath, request, mapping);

		CacheEntry cacheEntry = cache.get(cacheKey);

		if (cacheEntry != null) {
			// Rec擾łꍇÃRecԂ
			// TODO RecStringbinary̏ꍇŏ𕪂
			response.getWriter().write((String)cacheEntry.getContent());
			response.setContentType(cacheEntry.getContentType());
			if (log.isDebugEnabled()) {
				log.debug("We use cache for path '" + path + "'");
			}

			return;
		}

		// Validations
		if (!processValidate(request, response, form, mapping)) {
			return;
		}
		
		// ResponseCacheServletResponseɍւ
		CacheServletResponse cacheResponse = new CacheServletResponse(response);

		try {
			
			processMainProcess(request, cacheResponse, mapping, form);

		} catch (IOException e) {
			String content = cacheResponse.getContent();
			String contentType = cacheResponse.getContentType();
			if (contentType == null) {
				contentType =
					"text/html; charset=" + request.getCharacterEncoding();
			}
			log.error("Exception[" + e.getMessage() + "] occured. Response is not cached.");
			response.getWriter().write(content);
			response.setContentType(contentType);
			throw e;
		}

		String content = cacheResponse.getContent();
		String contentType = cacheResponse.getContentType();
		if (contentType == null) {
			contentType =
				"text/html; charset=" + request.getCharacterEncoding();
		}

		CacheEntry entry = cache.createNewEntry();
		entry.setContent(content);
		entry.setContentType(contentType);
		entry.setContentDate(System.currentTimeMillis());

		if (log.isDebugEnabled()) {
			log.debug("CacheKey is: " + cacheKey);
		}
		if (cacheKey.getKeyEntries().length == 0) {
			cache.put(cacheKey, entry);
			if (log.isDebugEnabled()) {
				log.debug("Save Cache for path: '" + cachePath + "'.");
			}
		} else {
			cache.put(cacheKey, entry);
			if (log.isDebugEnabled()) {
				log.debug(
					"Save Cache: Cache-Key '"
						+ cacheKey
						+ "', path '"
						+ cachePath
						+ "'.");
			}
		}

		response.getWriter().write(content);
		response.setContentType(contentType);
	}

	/**
	 * NGXg̃CsB
	 * <ol>
	 *   <li>processForward</li>
	 *   <li>processInclude</li>
	 *   <li>processAction</li>
	 *   <li>processForwardConfig</li>
	 * </ol>
	 * @param request
	 * @param response
	 * @param mapping
	 * @param form
	 * @throws IOException
	 * @throws ServletException
	 */
	protected void processMainProcess(
		HttpServletRequest request,
		HttpServletResponse response,
		ActionMapping mapping,
		ActionForm form)
		throws IOException, ServletException {

		// Process a forward or include specified by this mapping
		if (!processForward(request, response, mapping)) {
			return;
		}
		if (!processInclude(request, response, mapping)) {
			return;
		}
		
		ActionForward forward =
			processAction(request, response, mapping, form);
		
		processForwardConfig(request, response, forward);
	}
	
	/**
	 * ANVB
	 * @param request
	 * @param response
	 * @param mapping
	 * @param form
	 * @return
	 * @throws IOException
	 * @throws ServletException
	 */
	protected ActionForward processAction(
		HttpServletRequest request,
		HttpServletResponse response,
		ActionMapping mapping,
		ActionForm form)
		throws IOException, ServletException {
		// Create or acquire the Action instance to process this request
		Action action = processActionCreate(request, response, mapping);
		ActionForward forward = null;
		if (action != null) {
			// Call the Action instance itself
			forward =
				processActionPerform(
					request,
					response,
					action,
					form,
					mapping);
		}
		
		if (forward == null) {
			forward =
				processSelectForward(request, response, form, mapping);
		}
		if (forward == null) {
			forward = processForwardTest(request, response, form, mapping);
		}
		return forward;
	}

	/**
	 * @param request
	 * @param response
	 * @param action
	 * @param form
	 * @param mapping
	 */
	protected ActionForward processSelectForward(
		HttpServletRequest request,
		HttpServletResponse response,
		ActionForm form,
		ActionMapping mapping)
		throws ServletException {

		ExtendActionMapping exMapping = (ExtendActionMapping) mapping;
		SelectForwardConfig selectForward = exMapping.getSelectForwardConfig();
		if (selectForward == null) {
			return null;
		}

		Object o = null;
		try {
			o = BeanUtils.getProperty(form, selectForward.getProperty());
		} catch (Exception e) {
			; // Ȃ
		}
		String result = null;
		if (o != null) {
			result = o.toString();
		}

		//			ForwardValueConfig forwardValue =
		//				selectForward.findForwardValueConfig(result);
		MessageResources resources =
			(MessageResources) request.getAttribute(Globals.MESSAGES_KEY);
		ForwardValueConfig forwardValue =
			selectForward.findForwardValueConfig(
				result,
				resources,
				request.getLocale());

		if (forwardValue == null) {
			// requestp[^猟
			String prefix = selectForward.getProperty() + ".";
			Iterator i = IteratorUtils.asIterator(request.getParameterNames());

			while (i.hasNext()) {
				String param_name = (String) i.next();
				if (param_name.startsWith(prefix)) {
					result = param_name.substring(prefix.length());
					String result_body[] = StringUtils.split(result, ".");

					forwardValue =
						selectForward.findForwardValueConfig(
							result_body[0],
							resources,
							request.getLocale());
				}
			}
		}

		if (forwardValue == null) {
			forwardValue = selectForward.getForwardDefaultConfig();
		}

		if (forwardValue != null) {
			return mapping.findForward(forwardValue.getName());
		}

		return null;
	}

	protected ActionForward processForwardTest(
		HttpServletRequest request,
		HttpServletResponse response,
		ActionForm form,
		ActionMapping mapping) throws ServletException {
		
		ForwardContext context = null;
		ForwardConfig[] forwards = ((ExtendActionMapping)mapping).getForwardConfigs();
		try {
			for (int i = 0; i < forwards.length; ++i) {
				if (!(forwards[i] instanceof TStrutsActionForward)) {
					continue;
				}
				TStrutsActionForward forward = (TStrutsActionForward)forwards[i];
				if (forward.getTest() == null) {
					continue;
				}
				if (context == null) {
					context = new ForwardContext(request, getServletContext());
				}
				Expression expr = forward.getTestExpr();
				Object result = expr.evaluate(context);
				if (result instanceof Boolean) {
					if (((Boolean)result).booleanValue()) {
						return forward;
					}
					continue;
				}
				String str = null;
				if (result instanceof String) {
					str = (String)result;
				} else {
					str = result.toString();
				}
				if (str.equals("on") ||
					str.equals("yes") ||
					str.equals("1") ||
					str.equals("true")) {
					return forward;
				}
			}
		} catch (Exception e) {
			throw new ServletException(e);
		}
		return null;
	}

	/**
	 * NGXg̑OsB<p>
	 * ł́Aȉ̏sB<br>
	 * <ol>
	 *   <li>ServletContext{@link SystemConfig}擾āA{@link SystemConfig#setLocal()}ĂяoB</li>
	 *   <li>{@link SystemConfig#createInvocationContext()}ŁAInvocationContext𐶐āArequestɑ{@link MyGlobals#INVOCATION_CONTEXT_KEY}Őݒ肷B</li>
	 *   <li>superĂяoB</li>
	 * </ol>
	 * 
	 * @param request HTTPNGXg
	 * @param response HTTPX|X
	 * @return ꍇAtrue
	 */
	protected boolean processPreprocess(
		HttpServletRequest request,
		HttpServletResponse response) {
		if (request.getAttribute(MyGlobals.INVOCATION_CONTEXT_KEY) == null) {
			try {
				final InvocationContext invokeContext =
					systemConfig.createInvocationContext();
				request.setAttribute(
					MyGlobals.INVOCATION_CONTEXT_KEY,
					invokeContext);
			} catch (Exception e) {
				log.fatal("Failed to create InvocationContext", e);
			}
		}

		return super.processPreprocess(request, response);
	}

	/**
	 * dMh~@\Ăяo\bhB<p>
	 * TransactionIdSessionɊi[Ă邩`FbNsNXĂяo܂B<br>
	 * TransactionId𐶐ASessionRequestɊi[NXĂяo܂B<br>
	 * @param request HTTPNGXg
	 * @param response HTTPX|X
	 * @param action &lt;action&gt;vf\ActionIuWFNg
	 * @param form &lt;action&gt;vf\ActionformIuWFNg
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @exception IOException
	 * @exception ServletException
	 */
	protected ActionForward processActionPerform(
		HttpServletRequest request,
		HttpServletResponse response,
		Action action,
		ActionForm form,
		ActionMapping mapping)
		throws IOException, ServletException {

		try {
			log.debug("processActionPerform() start.");
			ExtendActionMapping exMapping = (ExtendActionMapping)mapping;

			if (exMapping.getTransacted()) {
				TransactionControl tControl = new TransactionControl();
				tControl.checkTransactionId(request, action, mapping);
				tControl.saveTransactionId(request, getTransactedMax());
			}

			ActionForward forward =
				action.execute(mapping, form, request, response);

			return (forward);
		} catch (Exception e) {
			return (processException(request, response, e, form, mapping));
		}
	}

	/* (non-Javadoc)
	 * @see org.apache.struts.action.RequestProcessor#processForward(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionMapping)
	 */
	protected boolean processForward(
		HttpServletRequest request,
		HttpServletResponse response,
		ActionMapping mapping)
		throws IOException, ServletException {

		String path = mapping.getForward();
		if (path == null) {
			return (true);
		}

		TStrutsActionForward forward = new TStrutsActionForward(path);
		internalForward(request, response, forward);

		return false;
	}

	/* (non-Javadoc)
	 * @see org.apache.struts.action.RequestProcessor#processForwardConfig(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.config.ForwardConfig)
	 */
	protected void processForwardConfig(
		HttpServletRequest request,
		HttpServletResponse response,
		ForwardConfig forward)
		throws IOException, ServletException {
		if (forward == null) {
			return;
		}

		internalForward(request, response, forward);
	}

	protected void internalForward(
		HttpServletRequest request,
		HttpServletResponse response,
		ForwardConfig forward)
		throws ServletException, IOException {
			
		TilePutConfigBase oldConfig =
			(TilePutConfigBase) request.getAttribute(
				MyGlobals.TILES_CONFIG_KEY);

		TileDefinitionConfig tileDef =
			((SubModuleConfigImpl) moduleConfig).findTileDefinition(
				forward.getPath());
		boolean topLevelTile = false;
		try {
			if (tileDef != null) {
				// ԊÕ^Cۂ
				TileDefinitionConfig topLevelTileDef = (TileDefinitionConfig)request.getAttribute(MyGlobals.TOP_TILE_KEY);
				if (topLevelTileDef == null) {
					topLevelTile = true;
					topLevelTileDef = tileDef;
					request.setAttribute(MyGlobals.TOP_TILE_KEY, tileDef);
					request.setAttribute(MyGlobals.ERROR_CONTROL_KEY, tileDef.getErrorControl());
				}

				// ^CsOɁAG[ɂ邩ǂ𒲂ׂĂ
				// ^CŃG[̂ɂ̂ʂ邽߁B
				ActionErrors errors = (ActionErrors)request.getAttribute(Globals.ERROR_KEY);
				boolean error = (errors != null && !errors.isEmpty());

				// s(^C`Ɉ˗)
				tileDef.init();
				tileDef.makeResponse(request, response, getServletContext());
				request.setAttribute(MyGlobals.TILES_CONFIG_KEY, tileDef);
				forward = new TStrutsActionForward(tileDef.getPath());

				if (error) {
					// ^CsOG[Ƃ́AG[\Ƃ
					// ^C`IĂɗĂ̂ŁÂ܂ܕ\
				} else if (topLevelTileDef != tileDef) {
					// gbvx(ԊO)^CłȂƂ͂̂܂܏s
				} else {
					// ^CsOɃG[ȂAgbvx^C`̂Ƃ́A
					// ^CsɃG[ǂ𒲂ׂ

					String errorControl = (String) request.getAttribute(MyGlobals.ERROR_CONTROL_KEY);
					errors = (ActionErrors)request.getAttribute(Globals.ERROR_KEY);
					if (errors != null && !errors.isEmpty() &&
						(errorControl == null || Boolean.valueOf(errorControl).booleanValue())) {
						// G[Ăяo
						errorForward(request, response);
						// errorForward̓X|XŕԂ̂ŏI
						return;
					}
				}
			}

			String path = forward.getPath();
			if (!path.startsWith("/")) {
				path = RequestUtils.forwardURL(request, forward);
			}

			if (forward.getRedirect()) {
				if (!(response instanceof CacheServletResponse)) {
					path = request.getContextPath() + path;
					response.sendRedirect(response.encodeRedirectURL(path));
				}
			} else {
				if (response instanceof CacheServletResponse) {
					doInclude(path, request, response);
				} else {
					doForward(path, request, response);
				}
			}
		} finally {
			if (topLevelTile) {
				tileDef.init();
			}
			request.setAttribute(MyGlobals.TILES_CONFIG_KEY, oldConfig);
		}
	}

	/**
	 * @param request
	 * @return
	 */
	protected void errorForward(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {
		// JڐG[pX擾
		ActionMapping mapping = (ActionMapping) request.getAttribute(Globals.MAPPING_KEY);
		String input = mapping.getInput();
		// inputȂꍇ́AnullԂ
		if ((input == null) || input.length() == 0) {
			return;
		}

		ForwardConfig forward = null;
		if (moduleConfig.getControllerConfig().getInputForward()) {
			forward = mapping.findForward(input);
		} else {
			forward = new TStrutsActionForward(input);
		}
		internalForward(request, response, forward);
	}

	/**
	 * LbVL[𐶐郁\bhB<br>
	 * 
	 * @param request
	 * @param mapping
	 * @return
	 */
	protected CacheKey createCacheKey(
		ActionCache cache,
		String cachePath,
		HttpServletRequest request,
		ActionMapping mapping)
		throws ServletException {

		CacheKey cacheKey = cache.createNewKey(cachePath);

		StringBuffer buf = new StringBuffer();
		CacheKeyConfig[] keyConfigs =
			((ExtendActionMapping) mapping).getCacheKeyConfigs();
		for (int i = 0; i < keyConfigs.length; ++i) {
			String parameter = keyConfigs[i].getParameter();
			if (parameter != null) {
				StringTokenizer t = new StringTokenizer(parameter, ", ");
				while (t.hasMoreTokens()) {
					String name = t.nextToken();
					String[] values = request.getParameterValues(name);
					String value;
					if (values == null || values.length == 0) {
						value = null;
					} else if (values.length == 1){
						value = values[0];
					} else {
						buf.setLength(0);
						for (int j = 0; j < values.length; ++j) {
							buf.append(values[j]);
							if (j + 1 < values.length) {
								buf.append(',');
							}
						}
						value = buf.toString();
					}
					cacheKey.addKey("P#" + name, value);
					if (log.isDebugEnabled()) {
						log.debug("Add cacheKey : key=" + name + ", value=" + value);
					}
				}
				continue;
			}

			String beanName = keyConfigs[i].getBeanName();
			String property = keyConfigs[i].getProperty();
			// requestformBeanproperty̒lƂĂ
			Object bean = request.getAttribute(beanName);
			if (bean == null) {
				HttpSession session = request.getSession(false);
				if (session != null) {
					bean = session.getAttribute(beanName);
				}
				if (bean == null) {
					bean = getServletContext().getAttribute(beanName);
				}
			}

			if (bean == null) {
				throw new ServletException(
					"beanName '" + beanName + "' is not defined.");
			}

			if (property == null) {
				// vpeBw肳ȂꍇAbeangcache-key
				cacheKey.addKey(beanName, bean.toString());
				if (log.isDebugEnabled()) {
					log.debug("Add cacheKey : key=" + beanName + ", value=" + bean);
				}
				continue;
			} else {
				StringTokenizer t = new StringTokenizer(property, ", ");
				while (t.hasMoreTokens()) {
					String name = t.nextToken();
					String value = null;
					try {
						value = BeanUtils.getProperty(bean, name);
					} catch (IllegalAccessException e) {
						throw new ServletException(e);
					} catch (InvocationTargetException e) {
						throw new ServletException(e);
					} catch (NoSuchMethodException e) {
						throw new ServletException(
							"property '" + property + "' is not defined.",
							e);
					}

					String key = "B#" + name;
					cacheKey.addKey(key, value);
					if (log.isDebugEnabled()) {
						log.debug(
							"Add cacheKey : key="
								+ beanName + "#" + name
								+ ", value="
								+ value);
					}
				}
			}
		}

		if (autoLocale) {
			log.debug("CacheAutoLocale:on, add locale key.");
			Locale locale = request.getLocale();
			cacheKey.addKey(TILES_LOCALE_CACHE_KEY, locale.toString());
		}

		return cacheKey;
	}

	/**
	 * @return
	 */
	public int getTransactedMax() {
		return transactedMax;
	}

	/* ( Javadoc)
	 * @see org.apache.struts.action.RequestProcessor#processActionCreate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionMapping)
	 */
	protected Action processActionCreate(
		HttpServletRequest arg0,
		HttpServletResponse arg1,
		ActionMapping arg2)
		throws IOException {

		String className = arg2.getType();
		if (className == null) {
			return null;
		}

		return super.processActionCreate(arg0, arg1, arg2);
	}

	/**
	 * <p>If this request was not cancelled, and the request's
	 * {@link ActionMapping} has not disabled validation, call the
	 * <code>validate()</code> method of the specified {@link ActionForm},
	 * and forward back to the input form if there were any errors.
	 * Return <code>true</code> if we should continue processing,
	 * or <code>false</code> if we have already forwarded control back
	 * to the input form.</p>
	 * 
	 * @param request The servlet request we are processing
	 * @param response The servlet response we are creating
	 * @param form The ActionForm instance we are populating
	 * @param mapping The ActionMapping we are using
	 * 
	 * @exception IOException if an input/output error occurs
	 * @exception ServletException if a servlet exception occur
	 */
	protected boolean processValidate(HttpServletRequest request,
									HttpServletResponse response,
									ActionForm form,
									ActionMapping mapping)
		throws IOException, ServletException {

		if (form == null) {
			return (true);
		}

		// Was this request cancelled?
		if (request.getAttribute(Globals.CANCEL_KEY) != null) {
			if (log.isDebugEnabled()) {
				log.debug(" Cancelled transaction, skipping validation");
			}
			return (true);
		}

		// Has validation been turned off for this mapping?
		if (!mapping.getValidate()) {
			return (true);
		}

		// Call the form bean's validation method
		if (log.isDebugEnabled()) {
			log.debug(" Validating input form properties");
		}
    
		ActionErrors errors = form.validate(mapping, request);
    
		if ((errors == null) || errors.isEmpty()) {
			if (log.isTraceEnabled()) {
				log.trace("  No errors detected, accepting input");
			}
			return (true);
		}

		ActionErrors org = (ActionErrors)request.getAttribute(Globals.ERROR_KEY);
		if (org == null) {
			request.setAttribute(Globals.ERROR_KEY, errors);
		} else {
			org.add(errors);
		}

		// Special handling for multipart request
		if (form.getMultipartRequestHandler() != null) {
			if (log.isTraceEnabled()) {
				log.trace("  Rolling back multipart request");
			}
			form.getMultipartRequestHandler().rollback();
		}

		// Has an input form been specified for this mapping?
		String input = mapping.getInput();
		if (input == null) {

			if (log.isTraceEnabled()) {
				log.trace("  Validation failed but no input form available");
			}
			response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,
							   getInternal().getMessage("noInput",
														mapping.getPath()));
			return (false);
		}

		// Save our error messages and return to the input form if possible
		if (log.isDebugEnabled()) {
			log.debug(" Validation failed, returning to '" + input + "'");
		}
    
		if (moduleConfig.getControllerConfig().getInputForward()) {
			ForwardConfig forward = mapping.findForward(input);
			processForwardConfig(request, response, forward);
		} else if (mapping.getInputForward() != null) {
			ForwardConfig forward = mapping.getInputForward();
			processForwardConfig(request, response, forward);
		} else {
			internalModuleRelativeForward(input, request, response);
		}
		
		return (false);
	}
}
