/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts;

import java.net.MalformedURLException;
import java.net.URL;

import javax.servlet.ServletException;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.util.RequestUtils;
import jp.ossc.tstruts.config.ExtendModuleConfigFactory;
import jp.ossc.tstruts.config.SubModuleConfigImpl;
import jp.ossc.tstruts.config.TilesDefinitionsConfig;


/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class ExtendActionServlet extends ActionServlet {
	/**
	 * ftHgDigester[Zbg`
	 */
	public static final String DEFAULT_DIGESTER_RULE_PATH =
		"jp/ossc/tstruts/config/digester-rules.xml";

	/**
	 * ActionServlet̏
	 * ModuleConfig̕ێNXւANX̏s
	 */
	public void init() throws ServletException {
		ModuleConfigFactory.setFactoryClass(ExtendModuleConfigFactory.class.getName());
		super.init();
	}

	/**
	 * Digesteȑ
	 */
	protected Digester initConfigDigester() throws ServletException {

		// Do we have an existing instance?
		if (configDigester != null) {
			return (configDigester);
		}

		// Digester[Zbg̃pX擾
		String rulePath = getServletConfig().getInitParameter("digesterRule");
		if (rulePath == null) {
			// ActionServletp[^Ƀ[Zbg̃pXw肳ĂȂƂ
			// ftHgl𗘗pB
			rulePath = DEFAULT_DIGESTER_RULE_PATH;
		}

		// [Zbg̃pXURLɕϊ
		URL url = null;
		try {
			// ܂WebAvɑ݂邩𒲂ׂ
			url = getServletContext().getResource(rulePath);
		} catch (MalformedURLException e) {
		}
		
		if (url == null) {
			// WebAvɑ݂Ȃꍇ̓NXpX擾
			ClassLoader cl = getClass().getClassLoader();
			url = cl.getResource(rulePath);
		}

		// łȂ΃G[
		if (url == null) {
			throw new ServletException("Cannot find " + rulePath);
		}

		// Digester쐬
		configDigester = DigesterLoader.createDigester(url);

		// Check the status of the "validating" initialization parameter
		String value = getServletConfig().getInitParameter("validating");
		if ("false".equalsIgnoreCase(value)
			|| "no".equalsIgnoreCase(value)
			|| "n".equalsIgnoreCase(value)
			|| "0".equalsIgnoreCase(value)) {

			configDigester.setValidating(false);
		} else {
			configDigester.setValidating(true);
		}

		configDigester.setNamespaceAware(true);
		configDigester.setUseContextClassLoader(true);

		// GeBeBQ(DTD)o^
		for (int i = 0; i < registrations.length; i += 2) {
			url = this.getClass().getResource(registrations[i+1]);
			if (url != null) {
				configDigester.register(registrations[i], url.toString());
			}
		}

		// ActionServletp[^Ɏw肳ꂽǉ̃[Zbgo^
		String rulesets = getServletConfig().getInitParameter("rulesets");
		if (rulesets == null) {
			rulesets = "";
		}
		rulesets = rulesets.trim();
		String ruleset = null;
		while (rulesets.length() > 0) {
			int comma = rulesets.indexOf(",");
			if (comma < 0) {
				ruleset = rulesets.trim();
				rulesets = "";
			} else {
				ruleset = rulesets.substring(0, comma).trim();
				rulesets = rulesets.substring(comma + 1).trim();
			}
			if (log.isDebugEnabled()) {
				log.debug("Configuring custom Digester Ruleset of type " + ruleset);
			}
			try {
				RuleSet instance = (RuleSet) RequestUtils.applicationInstance(ruleset);
				configDigester.addRuleSet(instance);
			} catch (Exception e) {
				log.error("Exception configuring custom Digester RuleSet", e);
				throw new ServletException(e);
			}
		}

		// Return the completely configured Digester instance
		return (configDigester);
	}

	/* (non-Javadoc)
	 * @see org.apache.struts.action.ActionServlet#initModuleConfig(java.lang.String, java.lang.String)
	 */
	protected ModuleConfig initModuleConfig(String prefix, String paths)
		throws ServletException {
		SubModuleConfigImpl config = (SubModuleConfigImpl)super.initModuleConfig(prefix, paths); 
		TilesDefinitionsConfig tilesConfig = config.getTilesDefinitionsConfig();
		if (tilesConfig != null) {
			tilesConfig.processTilesExtentions();
		}
		return config;
	}

}
