package net.smokerz.linux.misc.batterymonitor.model;
import java.io.Serializable;

/**
 * ACPI INFO MODEL
 *
 * @author smoker
 * @version 0.0.1(2002/06/02)
 */
public class ACPIProcInfoModel implements Serializable{
	private String PRESENT = null;
	private int DESIGN_CAPACITY = 0;
	private int LAST_FULL_CAPACITY = 0;
	private String BATTERY_TECHNOLOGY = null;
	private int DESIGN_VOLTAGE = 0;
	private int DESIGN_CAPACITY_WARNING = 0;
	private int DESIGN_CAPACITY_LOW = 0;
	private int CAPACITY_GRANULARITY_1 = 0;
	private int CAPACITY_GRANULARITY_2 = 0;
	private String MODEL_NUMBER = null;
	private String SERIAL_NUMBER = null;
	private String BATTERY_TYPE = null;
	private String OEM_INFO = null;
	
	public ACPIProcInfoModel(
			String PRESENT,
			int DESIGN_CAPACITY,
			int LAST_FULL_CAPACITY,
			String BATTERY_TECHNOLOGY,
			int DESIGN_VOLTAGE,
			int DESIGN_CAPACITY_WARNING,
			int DESIGN_CAPACITY_LOW,
			int CAPACITY_GRANULARITY_1,
			int CAPACITY_GRANULARITY_2,
			String MODEL_NUMBER,
			String SERIAL_NUMBER,
			String BATTERY_TYPE,
			String OEM_INFO
				) {
		this.PRESENT = PRESENT;
		this.DESIGN_CAPACITY = DESIGN_CAPACITY;
		this.LAST_FULL_CAPACITY = LAST_FULL_CAPACITY;
		this.BATTERY_TECHNOLOGY = BATTERY_TECHNOLOGY;
		this.DESIGN_VOLTAGE = DESIGN_VOLTAGE;
		this.DESIGN_CAPACITY = DESIGN_CAPACITY_WARNING;
		this.DESIGN_CAPACITY_LOW = DESIGN_CAPACITY_LOW;
		this.CAPACITY_GRANULARITY_1 = CAPACITY_GRANULARITY_1;
		this.CAPACITY_GRANULARITY_2 = CAPACITY_GRANULARITY_2;
		this.MODEL_NUMBER = MODEL_NUMBER;
		this.SERIAL_NUMBER = SERIAL_NUMBER;
		this.BATTERY_TYPE = BATTERY_TYPE;
		this.OEM_INFO = OEM_INFO;

	}

	public String getPresent() {
		return this.PRESENT;
	}

	public int getDesignCapacity() {
		return this.DESIGN_CAPACITY;
	}

	public int getLastFullCapacity() {
		return this.LAST_FULL_CAPACITY;
	}

	public String getBatteryTechnology() {
		return this.BATTERY_TECHNOLOGY;
	}

	public int getDesignCapacityWarning() {
		return this.DESIGN_CAPACITY_WARNING;
	}

	public int getDesignCapacityLow() {
		return this.DESIGN_CAPACITY_LOW;
	}

	public int getCapacityGranularity1() {
		return this.CAPACITY_GRANULARITY_1;
	}
	
	public int getCapacityGranularity2() {
		return this.CAPACITY_GRANULARITY_2;
	}

	public String getModelNumer() {
		return this.MODEL_NUMBER;
	}

	public String getSerialNumber() {
		return this.SERIAL_NUMBER;
	}

	public String getBatteryType() {
		return this.OEM_INFO;
	}
}

