package net.smokerz.linux.misc.batterymonitor.model;
import java.io.Serializable;

/**
 * ACPI STATE MODEL
 *
 * @author smoker
 * @version 0.0.1(2002/06/02)
 */
public class ACPIProcStateModel implements Serializable{
	private String PRESENT = null;
	private String CAPACITY_STATE = null;
	private String CHARGING_STATE = null;
	private int PRESENT_RATE = 0;
	private int REMAINING_CAPACITY = 0;
	private int PRESENT_VOLTAGE = 0;
	
	public ACPIProcStateModel (
				String PRESENT,
				String CAPACITY_STATE,
				String CHARGING_STATE,
				int PRESENT_RATE,
				int REMAINING_CAPACITY,
				int PRESENT_VOLTAGE
				) {
		this.PRESENT = PRESENT;
		this.CAPACITY_STATE = CAPACITY_STATE;
		this.CHARGING_STATE = CHARGING_STATE;
		this.PRESENT_RATE = PRESENT_RATE;
		this.REMAINING_CAPACITY = REMAINING_CAPACITY;
		this.PRESENT_VOLTAGE = PRESENT_VOLTAGE;
	}

	public String getPresent() {
		return this.PRESENT;
	}

	public String getCapacityState() {
		return this.CAPACITY_STATE;
	}

	public String getChargingState() {
		return this.CHARGING_STATE;
	}
	
	public int getPresentRate() {
		return this.PRESENT_RATE;
	}

	public int getRemainingCapacity() {
		return this.REMAINING_CAPACITY;
	}

	public int getPresentVoltage() {
		return this.PRESENT_VOLTAGE;
	}
}

